<?php

require '../../../../wp-blog-header.php';
if(!defined('ABSPATH')) die('-1');
do_action('awesome_live_chat_iframe'); // @since v1.2.7
header($_SERVER['SERVER_PROTOCOL'] . ' 200 Ok');

class AwesomeLiveChat_iFrame extends AwesomeLiveChat
{
    private $Boots;
    private $Options;
    private $_;
    public function __construct()
    {
        $this->Boots   = $this->boots();
        $this->Options = $this->options();
        $this->_       = new AwesomeLiveChat_Library();
        $url           = $this->Options['APP_URL'];

        $socket = $this->_->settings('socket', 'socket') == 'yes';
        $socket_host = rtrim($this->_->settings('socket', 'host'), '/');
        $socket_port = $this->_->settings('socket', 'port', false);
        ?>

        <!DOCTYPE html>
        <html>
        <head>
            <meta charset="<?php echo $this->Boots->Database->term('blog_charset')->get(); ?>" />
            <title>Awesome Live Chat</title>
            <meta name="description" content="Awesome Live Chat">
            <meta name="author" content="Kamal Khan">

            <!-- Viewport -->
            <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

            <!-- Stylesheets -->
            <link href="<?php echo $url; ?>/css/cssreset-min.css" rel="stylesheet">
            <link href="<?php echo $url; ?>/css/font-awesome.min.css" rel="stylesheet">
            <link href="<?php echo $url; ?>/frontend/css/awesome-live-chat.min.css" rel="stylesheet">
            <link href="<?php echo $url; ?>/frontend/css/alc.css.php" rel="stylesheet">
            <style>
                html, body {
                    background: none;
                    margin-bottom: -5px;
                }
                #awesome-live-chat {
                    display: inline-block;
                    position: relative;
                    top: auto;
                    left: auto;
                    right: auto;
                    bottom: 0;
                }
                #awesome-live-chat .alc-body .alc-form .alc-wrap-right i.fa {
                    right: 1px;
                }
            </style>
            <?php do_action('awesome_live_chat_iframe_header'); ?>
            <!--[if lt IE 9]>
                <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
            <![endif]-->
        </head>
        <body>

            <?php
                $bg = false;
                $iframe = true;
                include dirname(__FILE__) . '/chat.php';
            ?>

            <!-- Scripts -->
            <script src="<?php echo $url; ?>/js/jquery-1.11.1.min.js"></script>
            <script src="<?php echo $url; ?>/js/iframeResizer.contentWindow.min.js"></script>
            <script src="<?php echo $url; ?>/js/jquery-ui-1.11.0.min.js"></script>
            <script src="<?php echo $url; ?>/js/underscore-min.js"></script>
            <script src="<?php echo $url; ?>/js/backbone-min.js"></script>
            <?php if($socket) : ?>
            <script src="<?php echo $socket_host . (empty($socket_port) ? '' : (':' . $socket_port)); ?>/socket.io/socket.io.js"></script>
            <?php endif; ?>
            <script src="<?php echo $url; ?>/js/bootstrap.min.js"></script>
            <script src="<?php echo $url; ?>/js/Autolinker.min.js"></script>
            <script>
                var awesome_live_chat = <?php echo json_encode(AwesomeLiveChat_Frontend::getVars()); ?>;
            </script>
            <script src="<?php echo $url; ?>/frontend/js/awesome-live-chat.min.js"></script>
            <script>
                $('body').css('marginTop',
                    $('#awesome-live-chat .alc-status').outerHeight() + 5
                );
            </script>
            <?php do_action('awesome_live_chat_iframe_footer'); ?>
            <script src="<?php echo $url; ?>/frontend/js/alc.js.php"></script>
            <script>
                (function ($){
                    document.addEventListener('DOMContentLoaded', function () {
                        AwesomeLiveChat.$el.css('min-width', AwesomeLiveChat.$el.width() + 32);
                    });
                })(jQuery);
            </script>
        </body>
        </html>

        <?php
    }
}
new AwesomeLiveChat_iFrame();
