<?php

define('WP_USE_THEMES', false);
require '../../../../../wp-blog-header.php';
if(!defined('ABSPATH')) die('-1');

$lastModified = get_option('alc_last_modified');

$etagFile = md5_file(__FILE__);
$ifModifiedSince = isset($_SERVER['HTTP_IF_MODIFIED_SINCE'])
    ? $_SERVER['HTTP_IF_MODIFIED_SINCE']
    : false;
$etagHeader = isset($_SERVER['HTTP_IF_NONE_MATCH'])
    ? trim($_SERVER['HTTP_IF_NONE_MATCH'])
    : false;

header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $lastModified) . ' GMT');
header('Etag: $etagFile');
header('Cache-Control: public');

if(@strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE']) == $lastModified || $etagHeader == $etagFile)
{
       header("HTTP/1.1 304 Not Modified");
       die();
}

header("HTTP/1.1 200 OK");
header('Content-type: text/css');

$ALCLibrary = new AwesomeLiveChat_Library();
$ALCUtility = new AwesomeLiveChat_Utility();

$font_header = $ALCLibrary->settings('skin', 'font_header');
$font_header = preg_replace('/:.*$/', '', $font_header);
$font_body = $ALCLibrary->settings('skin', 'font_body');
$font_body = preg_replace('/:.*$/', '', $font_body);
$chat_width = $ALCLibrary->settings('general', 'width');
$chat_height = $ALCLibrary->settings('general', 'height');
$chat_icon = $ALCLibrary->settings('general', 'icon');
$primary_color_bg = $ALCLibrary->settings('skin', 'color_primary_bg');
$secondary_color_bg = $ALCLibrary->settings('skin', 'color_secondary_bg');
$primary_color_bg2 = $ALCUtility->darkenColor($primary_color_bg, 10);
$secondary_color_bg2 = $ALCUtility->darkenColor($secondary_color_bg, 10);
$primary_color_text = $ALCLibrary->settings('skin', 'color_primary_text');
$secondary_color_text = $ALCLibrary->settings('skin', 'color_secondary_text');
$glass = $ALCLibrary->settings('general', 'glass') == 'yes';
$border_width = $ALCLibrary->settings('general', 'width_border');
$border_color = $ALCLibrary->settings('skin', 'color_border');
$border_transparency = $ALCLibrary->settings('skin', 'border_transparency');
$bt = is_numeric($border_transparency)
    ? $border_transparency
    : 20;
$btp = $bt / 100;
?>

#awesome-live-chat {
    font-family: <?php echo $font_body; ?>, helvetica, sans-serif;
}
#awesome-live-chat .alc-border {
    width: <?php echo $border_width; ?>px;
    background-color: <?php echo $border_color; ?>;
    -khtml-opacity: <?php echo $btp; ?>;
    -moz-opacity: <?php echo $btp; ?>;
    -ms-filter: alpha(opacity=<?php echo $bt; ?>%);
    -ms-filter: alpha(Opacity=<?php echo $bt; ?>%);
    filter: alpha(opacity=<?php echo $bt; ?>%);
    opacity: <?php echo $btp; ?>;
}

#awesome-live-chat .alc-title-bar,
#awesome-live-chat .alc-title-bar h3,
#awesome-live-chat .alc-status {
    font-family: <?php echo $font_header; ?>, helvetica, sans-serif;
    max-width: <?php echo $chat_width; ?>px;
}
#awesome-live-chat .alc-body {
    width: <?php echo $chat_width; ?>px;
}
#awesome-live-chat .alc-body .alc-chat ul {
    height: <?php echo $chat_height; ?>px;
}
#awesome-live-chat .alc-title-bar,
#awesome-live-chat .alc-title-bar a.alc-meta,
#awesome-live-chat .alc-body .alc-form .alc-button.alc-button-primary,
#awesome-live-chat .alc-body .alc-chat .alc-chat-input .alc-toggle-layout:hover,
.alc-fancy#awesome-live-chat .alc-body .alc-chat li.alc-chat-you .alc-chat-message,
.alc-fancy#awesome-live-chat .alc-body .alc-chat li.alc-chat-you .alc-chat-message p a {
    background-color: <?php echo $primary_color_bg; ?>;
    color: <?php echo $primary_color_text; ?>;
}
#awesome-live-chat .alc-title-bar h3 a {
    color: <?php echo $primary_color_text; ?>;
}
#awesome-live-chat .alc-body .alc-chat li .alc-chat-message p a,
#awesome-live-chat .alc-body .alc-chat li.alc-chat-end a.alc-end-transcript {
    color: <?php echo $primary_color_bg; ?>;
}
.alc-fancy#awesome-live-chat .alc-body .alc-chat li.alc-chat-you .alc-chat-message {
    border-color: <?php echo $primary_color_bg; ?>;
}
#awesome-live-chat .alc-body .alc-form .alc-button.alc-button-primary:hover {
    background-color: <?php echo $primary_color_bg2; ?>;
}
#awesome-live-chat .alc-body .alc-chat li.alc-chat-end a.alc-end-transcript:hover {
    color: <?php echo $primary_color_bg2; ?>;
}
.alc-fancy#awesome-live-chat .alc-body .alc-chat li.alc-chat-you .alc-chat-message p a:hover {
    color: <?php echo $ALCUtility->darkenColor($primary_color_bg, 30); ?>;
}
#awesome-live-chat .alc-title-bar,
#awesome-live-chat .alc-body .alc-form .alc-button.alc-button-primary {
    border-color: <?php echo $primary_color_bg2; ?>;
}

#awesome-live-chat .alc-status {
    background-color: <?php echo $secondary_color_bg; ?>;
    color: <?php echo $secondary_color_text; ?>;
}
#awesome-live-chat .alc-status:after, #awesome-live-chat .alc-status:before {
    border-color: <?php echo $secondary_color_bg; ?> transparent transparent;
}
#awesome-live-chat .alc-body .alc-chat li .alc-chat-message p a:hover,
#awesome-live-chat .alc-body .alc-form .alc-button.alc-button-secondary,
#awesome-live-chat .alc-body .alc-chat li.alc-chat-end a.alc-end-close {
    color: <?php echo $secondary_color_bg; ?>;
}
#awesome-live-chat .alc-status {
    border-color: <?php echo $secondary_color_bg; ?>;
}
#awesome-live-chat .alc-body .alc-form .alc-button.alc-button-secondary:hover,
#awesome-live-chat .alc-body .alc-chat li.alc-chat-end a.alc-end-close:hover {
    color: <?php echo $secondary_color_bg2; ?>;
}

.alc-fancy#awesome-live-chat .alc-body .alc-chat li.alc-chat-you .alc-chat-message:after,
.alc-fancy#awesome-live-chat .alc-body .alc-chat li.alc-chat-you .alc-chat-message:before {
    border-color: transparent <?php echo $primary_color_bg; ?> transparent transparent;
}

<?php if(!empty($chat_icon)) : ?>
    #awesome-live-chat .alc-title-bar .alc-icon {
        background-image: url(<?php echo $chat_icon; ?>);
    }
<?php endif; ?>

<?php if($glass) : ?>
    #awesome-live-chat {
        background-color: transparent;
    }
    .alc-busy#awesome-live-chat .alc-body {
        opacity: 0.9;
    }
<?php endif; ?>

<?php echo stripslashes($ALCLibrary->settings('css')); ?>

<?php die(); ?>
