<?php
    $online = $this->_->isOnline();
    $position = $this->_->settings('general', 'position');
    $icon = $this->_->settings('general', 'icon');
    $power = $this->_->settings('about', 'power');
    $sound = $this->_->settings('general', 'sound') == 'yes'
        ? true : false;
    $border = $this->_->settings('general', 'hide_border') == 'no'
        ? true : false;
    $email_field = $this->_->settings('general', 'email_field');
    $Status = $this->_->settings('general', 'hide_status');
    $status = true;
    if($online) $status = !in_array('online', $Status);
    else $status = !in_array('offline', $Status);
    $Website = $this->_->settings('general', 'hide_website');
    $show_website = false;
    if($online) $show_website = !in_array('online', $Website);
    else $show_website = !in_array('offline', $Website);
    $bg = !isset($bg) && $this->_->settings('general', 'bg') == 'yes'
        ? true : false;
    $title = $this->_->settings('strings', 'title');
    $name = $this->_->settings('strings', 'field_name');
    $email = $this->_->settings('strings', 'field_email');
    $website = $this->_->settings('strings', 'field_website');
    $dept = $this->_->settings('strings', 'field_dept');
    $message = $this->_->settings('strings', 'field_message');
    $button = $online
        ? $this->_->settings('strings', 'button_online')
        : $this->_->settings('strings', 'button_offline');
    $intro = $online
        ? $this->_->settings('strings', 'intro_online')
        : $this->_->settings('strings', 'intro_offline');
    $intro = stripcslashes($intro);

    $name_val = '';
    $email_val = '';
    $user_id = get_current_user_id();
    if($user_id)
    {
        $User = get_userdata($user_id);
        $name_val = $User->display_name;
        $email_val = $User->user_email;
    }

    $class = '';
    $class .= $online ? 'alc-online ' : 'alc-offline ';
    $class .= $position == 'left' ? 'alc-left ' : 'alc-right ';
    $class .= isset($iframe) ? 'alc-iframe' : ' alc-inline';

    $class_form = $online ? 'alc-form-online' : 'alc-form-offline';

    $Departments = $this->_->getAllDepartments(true);
    $total_departments = count($Departments);
    if(!$total_departments)
    {
        $this->_->addDepartments(array(__('Support', 'awesome-live-chat')));
        $Departments = $this->_->getAllDepartments(true);
        $total_departments = count($Departments);
    }
    $show_department = $this->_->settings('general', 'hide_dept') == 'yes'
        ? ($total_departments > 1)
        : true;
?>
<div id="awesome-live-chat" class="awesome-live-chat <?php echo $class; ?> alc-clearfix cssreset">
    <?php if($border) : ?><div class="alc-border"></div><?php endif; ?>
    <div class="alc-title-bar alc-clearfix">
        <i class="alc-icon <?php echo empty($icon) ? 'fa fa-comments' : ''; ?>"></i>
        <h3><a href="#"><?php echo $title; ?></a></h3>
        <a href="#" class="alc-meta alc-close alc-tooltip-danger alc-transition js_alc_tooltip"
            data-toggle="tooltip"
            data-placement="top"
            data-trigger="manual"
            title="<?php echo str_replace(' ', '&nbsp;', __('End Chat', 'awesome-live-chat')); ?>">
            <i class="fa fa-times-circle"></i>
        </a>
        <a href="#" class="alc-meta alc-minimize alc-tooltip alc-transition js_alc_tooltip"
            data-toggle="tooltip"
            data-placement="left"
            title="<?php echo str_replace(' ', '&nbsp;', __('Minimize', 'awesome-live-chat')); ?>">
            <i class="fa fa-angle-down"></i>
        </a>
    </div>
    <?php if($status) : ?>
    <div class="alc-status alc-clearfix">
        <i class="fa fa-circle"></i>
        <span></span>
    </div>
    <?php endif; ?>
    <div class="alc-body alc-clearfix">
        <div class="alc-chat alc-clearfix">
            <i class="fa fa-spin fa-circle">)</i>
            <ul></ul>
            <div class="alc-chat-input">
                <a href="#" class="alc-toggle-layout js_alc_tooltip"
                    data-toggle="tooltip"
                    data-placement="left"
                    data-trigger="hover"
                    title="<?php echo str_replace(' ', '&nbsp;', __('Toggle Layout', 'awesome-live-chat')); ?>">
                    <i class="fa fa-comments"></i>
                </a>
                <div class="alc-typing"><i class="fa fa-spin fa-spinner"></i> <span class="alc-typing-who"></span> <?php _e('is typing', 'awesome-live-chat'); ?><span class="alc-typing-dots">...</span></div>
                <input type="text" name="alc_message" id="alc_message" autocomplete="off" placeholder="<?php _e('Enter a message and hit return to send.', 'awesome-live-chat'); ?>" disabled="disabled" />
            </div>
        </div>
        <div class="alc-form alc-clearfix <?php echo $class_form; ?>">
            <?php echo $intro; ?>
            <div class="alc-split"></div>
            <ul class="alc-clearfix">
                <li>
                    <label for="alc_input_name"><?php echo $name; ?></label>
                    <div class="alc-input-wrap alc-wrap-left">
                        <input type="text" name="alc_input_name" id="alc_input_name" class="alc-input" placeholder="<?php echo $name; ?>" value="<?php echo $name_val; ?>" required />
                        <i class="fa fa-user"></i>
                    </div>
                </li>
                <?php if($email_field != 'hide' || !$online) : ?>
                <li>
                    <label for="alc_input_email"><?php echo $email; ?></label>
                    <div class="alc-input-wrap alc-wrap-left">
                        <input type="email" name="alc_input_email" id="alc_input_email" class="alc-input<?php echo $email_field == 'optional' ? ' alc-optional' : ''; ?>" placeholder="<?php echo $email; ?>" value="<?php echo $email_val; ?>" required />
                        <i class="fa fa-envelope"></i>
                    </div>
                </li>
                <?php endif; ?>
                <?php if($show_website) : ?>
                <li>
                    <label for="alc_input_website"><?php echo $website; ?></label>
                    <div class="alc-input-wrap alc-wrap-left">
                        <input type="text" name="alc_input_website" id="alc_input_website" class="alc-input" placeholder="<?php echo $website; ?>" />
                        <i class="fa fa-globe"></i>
                    </div>
                </li>
                <?php endif; ?>
                <?php if($show_department) : ?>
                <li>
                    <label for="alc_input_department"><?php echo $dept; ?></label>
                    <div class="alc-input-wrap alc-wrap-right">
                        <select name="alc_input_department" id="alc_input_department" class="alc-input">
                            <?php
                                foreach($Departments as $Department)
                                {
                                    if(!$online || $this->_->isOnline($Department->id))
                                    {
                                        echo '<option value="' . $Department->id . '">';
                                        echo $Department->name;
                                        echo '</option>';
                                    }
                                }
                            ?>
                        </select>
                        <i class="fa fa-unsorted"></i>
                    </div>
                </li>
                <?php endif; if(!$online) : ?>
                <li class="alc-wide">
                    <label for="alc_input_message"><?php echo $message; ?></label>
                    <textarea type="url" name="alc_input_message" id="alc_input_message" class="alc-input" placeholder="<?php echo $message; ?>"></textarea>
                </li>
                <?php endif; ?>
            </ul>
            <div class="alc-split"></div>
            <a href="#" class="alc-button alc-button-primary alc-transition">
                <i class="fa fa-comments"></i><?php echo $button; ?>
            </a>
            <a href="#" class="alc-button alc-button-secondary alc-transition">
                <i class="fa fa-times"></i><?php _e('Cancel', 'awesome-live-chat'); ?>
            </a>
            <i class="fa fa-spin fa-spinner"></i>
        </div>
        <!-- alc-form -->
    </div>
    <!-- alc-body -->
    <?php if(!empty($power)) : ?>
    <div class="alc-power">Powered by <a href="http://codecanyon.net/item/awesome-live-chat/9931156?ref=<?php echo $power; ?>" target="_blank">Awesome Live Chat</a></div>
    <?php endif; ?>
    <?php if($sound) : ?>
    <audio id="alc_sound" src="<?php echo $this->Options['APP_URL'] . '/sound/message.mp3'; ?>" controls preload="auto" autobuffer></audio>
    <?php endif; ?>
</div>
<!-- awesome-live-chat -->
<?php if($bg) : ?><div class="awesome-live-chat-bg"></div><?php endif; ?>

<script type="text/template" id="alc_template-form-offline-message">
    <li class="alc-wide">
        <label for="alc_input_message"><?php echo $message; ?></label>
        <textarea type="url" name="alc_input_message" id="alc_input_message" class="alc-input" placeholder="<?php echo $message; ?>"></textarea>
    </li>
</script>

<script type="text/template" id="alc_template-message">
    <li class="<%=classname%>">
        <div class="alc-chat-head">
            <img src="<%=gravatar%>" />
            <div class="alc-chat-time"><%=time%></div>
        </div>
        <div class="alc-chat-message">
            <div class="alc-chat-name"><%=name%> <span><%=who%></span></div>
            <p><%=message%></p>
        </div>
    </li>
</script>

<script type="text/template" id="alc_template-end">
    <li class="alc-chat-end">
        <p><?php _e('Chat has been terminated.', 'awesome-live-chat'); ?></p>
        <a href="#" class="alc-end-transcript">
            <i class="fa fa-mail-forward"></i> <?php _e('Send me a transcript', 'awesome-live-chat'); ?>
        </a>
        <a href="#" class="alc-end-close">
            <i class="fa fa-times"></i> <?php _e('Close', 'awesome-live-chat'); ?>
        </a>
    </li>
</script>
<script type="text/template" id="alc_template-tick">
    <i class="fa fa-check"></i>
</script>
<script type="text/template" id="alc_template-spin">
    <i class="fa fa-spin fa-spinner"></i>
</script>
