<?php

$this->Admin->section(__('Mail', 'awesome-live-chat'))
->add('textbox', array(
    'title' => __('Offline Message - Subject', 'awesome-live-chat'),
    'id'    => 'alc_settings_mail_offline_subject',
    'name'  => 'alc_settings[mail][offline_subject]',
    'help'  => __('Subject of the email that will be sent when a visitor sends an offline message.', 'awesome-live-chat'),
    'value' => $Settings['offline_subject']
))->add('textbox', array(
    'title' => __('Offline Message - Sender Name', 'awesome-live-chat'),
    'id'    => 'alc_settings_mail_offline_sender_name',
    'name'  => 'alc_settings[mail][offline_sender_name]',
    'help'  => __('Sender name associated with the offline message email.<br />Leave this empty if you would like this to be set as the visitor\'s name.', 'awesome-live-chat'),
    'value' => $Settings['offline_sender_name']
))->add('email', array(
    'title' => __('Offline Message - Sender Email', 'awesome-live-chat'),
    'id'    => 'alc_settings_mail_offline_sender_email',
    'name'  => 'alc_settings[mail][offline_sender_email]',
    'help'  => __('Email address associated with the offline message.<br />Leave this empty if you would like this to be set as the visitor\'s email.', 'awesome-live-chat'),
    'value' => $Settings['offline_sender_email']
))->add('email', array(
    'title' => __('Offline Message - Receiver Email', 'awesome-live-chat'),
    'id'    => 'alc_settings_mail_offline_receiver_email',
    'name'  => 'alc_settings[mail][offline_receiver_email]',
    'help'  => __('The email address which should receive the offline message sent by a visitor. This would be you.', 'awesome-live-chat'),
    'value' => $Settings['offline_receiver_email']
))->add('textbox', array(
    'title' => __('Transcript - Subject', 'awesome-live-chat'),
    'id'    => 'alc_settings_mail_transcript_subject',
    'name'  => 'alc_settings[mail][transcript_subject]',
    'help'  => __('Subject of the transcript email.', 'awesome-live-chat'),
    'value' => $Settings['transcript_subject']
))->add('textbox', array(
    'title' => __('Transcript - Sender Name', 'awesome-live-chat'),
    'id'    => 'alc_settings_mail_transcript_sender_name',
    'name'  => 'alc_settings[mail][transcript_sender_name]',
    'help'  => __('Sender name associated with the transcript email.', 'awesome-live-chat'),
    'value' => $Settings['transcript_sender_name']
))->add('email', array(
    'title' => __('Transcript - Sender Email', 'awesome-live-chat'),
    'id'    => 'alc_settings_mail_transcript_sender_email',
    'name'  => 'alc_settings[mail][transcript_sender_email]',
    'help'  => __('Email address associated with the transcript email.', 'awesome-live-chat'),
    'value' => $Settings['transcript_sender_email']
))->add('textarea', array(
    'title' => __('Transcript - Intro email', 'awesome-live-chat'),
    'id'    => 'alc_settings_mail_transcript',
    'name'  => 'alc_settings[mail][transcript]',
    'help'  => sprintf(__('Introductory transcript email.<br />Use %s, %s and %s as variables.', 'awesome-live-chat'),
                        '<code>[name]</code>', '<code>[email]</code>', '<code>[department]</code>'),
    'value' => $Settings['transcript']
));
