(function($){
    "use strict";

    var alc_archives = '.alc-archives';
    var $alc_archives = $(alc_archives);

    $(document).ready(function(){
        var hash = '';
        if(window.location.hash)
            hash = window.location.hash;
        // http://bit.ly/1rpS05H
        function reloadWithQueryStringVars (queryStringVars) {
            var href = location.href.substr(0, window.location.href.indexOf('#'));
            var existingQueryVars = location.search ? location.search.substring(1).split("&") : [],
                currentUrl = location.search ? href.replace(location.search,"") : href,
                newQueryVars = {},
                newUrl = currentUrl + "?";
            if(existingQueryVars.length > 0) {
                for (var i = 0; i < existingQueryVars.length; i++) {
                    var pair = existingQueryVars[i].split("=");
                    newQueryVars[pair[0]] = pair[1];
                }
            }
            if(queryStringVars) {
                for (var queryStringVar in queryStringVars) {
                    newQueryVars[queryStringVar] = queryStringVars[queryStringVar];
                }
            }
            if(newQueryVars) {
                for (var newQueryVar in newQueryVars) {
                    newUrl += newQueryVar + "=" + newQueryVars[newQueryVar] + "&";
                }
                newUrl = newUrl.substring(0, newUrl.length-1);
                window.location.href = newUrl + hash;
            } else {
                window.location.href = location.href + hash;
            }
        }

        $(window).bind('keydown', function (event){
            if(event.ctrlKey || event.metaKey)
            {
                switch (String.fromCharCode(event.which).toLowerCase())
                {
                    case 's':
                        event.preventDefault();
                        $('a.js-save-all').trigger('click');
                        break;
                }
            }
        });

        $('.alc-visitors > ul > li > a', $alc_archives).on('click', function(e){
            e.preventDefault();

            // silent
            var $target = $(e.target);
            if($(e.target).hasClass('alc-visitor-badge'))
            {
                var $form = $('<form method="post">'
                + '<input type="hidden" value="'+($(e.target).data('token'))+'" '
                + 'name="alc_silent" />'
                + '</form>');
                $(document.body).append($form);
                $form.submit();
                /*
                reloadWithQueryStringVars({
                    alc_silent: $(e.target).data('token')
                });*/
                return false;
            }

            // toggle
            var $chat = $('.alc-chat > ul', $(this).parent());
            $('.alc-visitors > ul > li', $alc_archives)
            .removeClass('alc-visitor-focus');
            $(this).parent().addClass('alc-visitor-focus');
            $('.alc-chat > ul', $alc_archives).hide();
            $chat.stop(true, true).show();
        });

        $('.alc-visitors > ul > li > a', $alc_archives).on('mouseenter', function(e){
            $('.alc-visitor-badge', $(this)).show();
        });
        $('.alc-visitors > ul > li > a', $alc_archives).on('mouseleave', function(e){
            $('.alc-visitor-badge', $(this)).hide();
        });

    });

})(jQuery);