<?php

$Posttypes = get_post_types(array(
    'public' => true,
    '_builtin' => false
), 'objects');

$Placement = array();
foreach($Posttypes as $Type)
{
    $Placement[$Type->name] = $Type->labels->name;
}

$this->Admin->section(__('General', 'awesome-live-chat'))
->add('select', array(
    'title' => __('Chat Mode', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_mode',
    'name'  => 'alc_settings[general][mode]',
    'help'  => __('Enable/disable live chat.', 'awesome-live-chat'),
    'data'  => array(
        'online'  => __('Online', 'awesome-live-chat'),
        'offline'   => __('Offline', 'awesome-live-chat')
    ), 'value' => $Settings['mode']
))->add('select', array(
    'title' => __('Message Sound', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_sound',
    'name'  => 'alc_settings[general][sound]',
    'help'  => __('Enable/disable sound on new message.', 'awesome-live-chat'),
    'data'  => array(
        'yes'  => __('Yes', 'awesome-live-chat'),
        'no'   => __('No', 'awesome-live-chat')
    ), 'value' => $Settings['sound']
))->add('multiple', array(
    'title' => __('Placement', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_placement',
    'name'  => 'alc_settings[general][placement]',
    'help'  => __('Where should the chat appear.', 'awesome-live-chat'),
    'data'  => array_merge($Placement, array(
        'post'    => __('Posts'),
        'page'    => __('Pages'),
        'archive' => __('Archives'),
        'home'    => __('Home', 'awesome-live-chat')
    )), 'value' => $Settings['placement']
))
->add('select', array(
    'title' => __('Position', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_position',
    'name'  => 'alc_settings[general][position]',
    'help'  => __('Position the chat panel on the left or right side of a page.', 'awesome-live-chat'),
    'data'  => array(
        'right'  => __('Right', 'awesome-live-chat'),
        'left'   => __('Left', 'awesome-live-chat')
    ), 'value' => $Settings['position']
))->add('select', array(
    'title' => __('Responsive', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_responsive',
    'name'  => 'alc_settings[general][responsive]',
    'help'  => __('Allow the chat panel to integrate well under handheld devices.', 'awesome-live-chat'),
    'data'  => array(
        'yes'  => __('Yes', 'awesome-live-chat'),
        'no'   => __('No', 'awesome-live-chat')
    ), 'value' => $Settings['responsive']
))->add('textbox', array(
    'title' => __('Chat Width', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_width',
    'name'  => 'alc_settings[general][width]',
    'help'  => __('Width of the chat panel (in pixels).', 'awesome-live-chat'),
    'value' => $Settings['width']
))->add('textbox', array(
    'title' => __('Chat Height', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_height',
    'name'  => 'alc_settings[general][height]',
    'help'  => __('Height of the chat panel (in pixels).', 'awesome-live-chat'),
    'value' => $Settings['height']
))->add('image', array(
    'title' => __('Chat Avatar', 'awesome-live-chat'),
    'id'  => 'alc_settings_general_avatar',
    'name'  => 'alc_settings[general][avatar]',
    'button' => __('Select Avatar', 'awesome-live-chat'),
    'help'  => sprintf(__('%s pixel avatar. Leave blank to use operator gravatars.', 'awesome-live-chat'), '45x45'),
    'value' => $Settings['avatar']
))->add('image', array(
    'title' => __('Chat Icon', 'awesome-live-chat'),
    'id'  => 'alc_settings_general_icon',
    'name'  => 'alc_settings[general][icon]',
    'button' => __('Select Icon', 'awesome-live-chat'),
    'help'  => sprintf(__('%s pixel chat icon.', 'awesome-live-chat'), '28x28'),
    'value' => $Settings['icon']
))->add('range', array(
    'title' => __('Timeout', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_timeout',
    'name'  => 'alc_settings[general][timeout]',
    'help'  => __('Ajax long polling timeout. Adjust this if encountering 500 Internal Server Error.', 'awesome-live-chat'),
    'value' => $Settings['timeout']
))->add('select', array(
    'title' => __('Show Offline', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_show_offline',
    'name'  => 'alc_settings[general][show_offline]',
    'help'  => __('Show offline form when offline.', 'awesome-live-chat'),
    'data'  => array(
        'no'  => __('No', 'awesome-live-chat'),
        'yes' => __('Yes', 'awesome-live-chat')
    ), 'value' => $Settings['show_offline']
))->add('select', array(
    'title' => __('Email Field - when online', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_email_field',
    'name'  => 'alc_settings[general][email_field]',
    'help'  => __('What would you like to do with the email field.', 'awesome-live-chat'),
    'data'  => array(
        'required'  => __('Required', 'awesome-live-chat'),
        'optional'  => __('Optional', 'awesome-live-chat'),
        'hide'      => __('Hide', 'awesome-live-chat')
    ), 'value' => $Settings['email_field']
))->add('textbox', array(
    'title' => __('Border Width', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_width_border',
    'name'  => 'alc_settings[general][width_border]',
    'help'  => __('Width of the border (in pixels).', 'awesome-live-chat'),
    'value' => $Settings['width_border']
))->add('select', array(
    'title' => __('Hide Border', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_hide_border',
    'name'  => 'alc_settings[general][hide_border]',
    'help'  => __('Hide transparent border around chat panel.', 'awesome-live-chat'),
    'data'  => array(
        'no'  => __('No', 'awesome-live-chat'),
        'yes' => __('Yes', 'awesome-live-chat')
    ), 'value' => $Settings['hide_border']
))->add('multiple', array(
    'title' => __('Hide Status', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_hide_status',
    'name'  => 'alc_settings[general][hide_status]',
    'help'  => __('Hide the status bar when online/offline.', 'awesome-live-chat'),
    'data'  => array(
        'online'  => __('Online', 'awesome-live-chat'),
        'offline' => __('Offline', 'awesome-live-chat')
    ), 'value' => $Settings['hide_status']
))->add('multiple', array(
    'title' => __('Hide Website Field', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_hide_website',
    'name'  => 'alc_settings[general][hide_website]',
    'help'  => __('Hide the website field when online/offline.', 'awesome-live-chat'),
    'data'  => array(
        'online'  => __('Online', 'awesome-live-chat'),
        'offline' => __('Offline', 'awesome-live-chat')
    ), 'value' => $Settings['hide_website']
))->add('select', array(
    'title' => __('Hide Department', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_hide_dept',
    'name'  => 'alc_settings[general][hide_dept]',
    'help'  => __('Hide department field when there is a single department.', 'awesome-live-chat'),
    'data'  => array(
        'no'  => __('No', 'awesome-live-chat'),
        'yes' => __('Yes', 'awesome-live-chat')
    ), 'value' => $Settings['hide_dept']
))->add('select', array(
    'title' => __('Glass Effect', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_glass',
    'name'  => 'alc_settings[general][glass]',
    'help'  => __('Display a see through effect during chat (will not show for iframe).', 'awesome-live-chat'),
    'data'  => array(
        'no'  => __('No', 'awesome-live-chat'),
        'yes' => __('Yes', 'awesome-live-chat')
    ), 'value' => $Settings['glass']
))->add('select', array(
    'title' => __('Transparent Modal', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_bg',
    'name'  => 'alc_settings[general][bg]',
    'help'  => __('Display transparent modal (will not show for iframe).', 'awesome-live-chat'),
    'data'  => array(
        'no'  => __('No', 'awesome-live-chat'),
        'yes' => __('Yes', 'awesome-live-chat')
    ), 'value' => $Settings['bg']
))->add('select', array(
    'title' => __('Restrict Operators', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_restrict_op',
    'name'  => 'alc_settings[general][restrict_op]',
    'help'  => __('Restrict operators to their profile and chat screen only.', 'awesome-live-chat'),
    'data'  => array(
        'no'  => __('No', 'awesome-live-chat'),
        'yes' => __('Yes', 'awesome-live-chat')
    ), 'value' => $Settings['restrict_op']
))->add('select', array(
    'title' => __('Use iFrame', 'awesome-live-chat'),
    'id'    => 'alc_settings_general_iframe',
    'name'  => 'alc_settings[general][iframe]',
    'help'  => __('Render chat panel in an iframe. Useful, if encountering layout issues.', 'awesome-live-chat'),
    'data'  => array(
        'no'  => __('No', 'awesome-live-chat'),
        'yes' => __('Yes', 'awesome-live-chat')
    ), 'value' => $Settings['iframe']
));
