<?php
namespace Bookly\Lib\Utils;

/**
 * Class Price
 * @package Bookly\Lib\Utils
 */
abstract class Price
{
    /** @var array */
    private static $currencies = array(
        'IRR' => array( 'symbol' => 'ریال',  'format' => '{price|0} {symbol}' ),
		'IRT' => array( 'symbol' => 'تومان',  'format' => '{price|0} {symbol}' ),
    );

    /** @var array */
    private static $formats = array(
        '{sign}{price|0} {symbol}',
    );

    /**
     * Format price.
     *
     * @param float $price
     * @return string
     */
    public static function format( $price )
    {
        $price    = (float) $price;
        $currency = get_option( 'bookly_pmt_currency' );
        $format   = get_option( 'bookly_pmt_price_format' );
        $symbol   = self::$currencies[ $currency ]['symbol'];

        if ( preg_match( '/{price\|(\d)}/', $format, $match ) ) {
            return strtr( $format, array(
                '{sign}' => $price < 0 ? '-' : '',
                '{symbol}' => $symbol,
                "{price|{$match[1]}}" => number_format_i18n( abs( $price ), $match[1] )
            ) );
        }

        return number_format_i18n( $price, 2 );
    }

    /**
     * Get supported currencies.
     *
     * @return array
     */
    public static function getCurrencies()
    {
        return self::$currencies;
    }

    /**
     * Get supported price formats.
     *
     * @return array
     */
    public static function getFormats()
    {
        return self::$formats;
    }

    /**
     * @param double $price
     * @param double $discount
     * @param double $deduction
     * @return float|int
     */
    public static function correction( $price, $discount, $deduction )
    {
        $price     = (float) $price;
        $discount  = (float) $discount;
        $deduction = (float) $deduction;
        $amount = round( $price * ( 100 - $discount ) / 100 - $deduction, 2 );

        return $amount > 0 ? $amount : 0;
    }
}