<?php
namespace Bookly\Frontend\Modules\Zarinpal;

use Bookly\Lib;

/**
 * Class Controller
 * @package Bookly\Frontend\Modules\Zarinpal
 */
class Controller extends Lib\Base\Component
{

    protected function getPermissions()
    {
        return array( '_this' => 'anonymous' );
    }
	
	/**
     * Init Express Checkout transaction.
     */
    public static function ecInit()
    {
        $form_id = self::parameter( 'bookly_fid' );
        if ( $form_id ) {
            // Create a zarinpal object.
            $zarinpal   = new Lib\Payment\Zarinpal();
            $userData = new Lib\UserBookingData( $form_id );

            if ( $userData->load() ) {
                $cart_info = $userData->cart->getInfo( Lib\Entities\Payment::TYPE_ZARIN );
                $cart_info->setPaymentMethodSettings( get_option( 'bookly_zarin_send_tax' ), 'tax_increases_the_cost' );

                $product = new \stdClass();
                $product->name  = $userData->cart->getItemsTitle( 126 );
                $product->price = $cart_info->getPaymentSystemPayNow();
                $product->qty   = 1;
                $zarinpal->setProduct( $product );
                $zarinpal->setTotalTax( $cart_info->getPaymentSystemPayTax() );

                // and send the payment request.
                $zarinpal->sendECRequest( $form_id );
            }
        }
    }

    /**
     * Process Express Checkout return request.
     */
    public static function ecReturn()
    {
        $form_id = self::Parameter( 'bookly_fid' );
        $ZarinPal  = new Lib\Payment\Zarinpal();
        $error_message = '';
            $response = $ZarinPal->sendNvpRequest( $form_id, array() );

            if ( strtoupper( $response['code'] ) == 100) {
						$payment = new Lib\Entities\Payment();
                        $payment
                            ->setType( Lib\Entities\Payment::TYPE_ZARIN )
                            ->setStatus( Lib\Entities\Payment::STATUS_COMPLETED );
                        $userData = new Lib\UserBookingData( $form_id );
                        if ( $userData->load() ) {
							$cart_info = $userData->cart->getInfo( Lib\Entities\Payment::TYPE_ZARIN );
							
							$coupon = $userData->getCoupon();
                            if ( $coupon ) {
                                $coupon->claim();
                                $coupon->save();
                            }
                            $paid     = (float) $cart_info->getPayNow();//$response['AMT'];
                            $expected = (float) $cart_info->getPayNow();
                            if ( $expected == $paid ) {
                                $payment
                                    ->setCartInfo( $cart_info )
                                    ->save();
                                $order = $userData->save( $payment );
                                $payment->setDetailsFromOrder( $order, $cart_info )->save();
                                Lib\NotificationSender::sendFromCart( $order );
                            }
						} else {
							// Information about customer’s cart (order) is no longer available.
                            $payment
                                ->setTotal( $paid )
                                ->setPaid( $paid )
                                ->setTax( $response['TAXAMT'] )
                                ->save();
						}
						$userData->setPaymentStatus( Lib\Entities\Payment::TYPE_ZARIN, 'success' );
						@wp_redirect( remove_query_arg( Lib\Payment\Zarinpal::$remove_parameters, Lib\Utils\Common::getCurrentPageURL() ) );
                        /*list ( $total, $deposit ) = $userData->cart->getInfo();
						$coupon = $userData->getCoupon();
                        if ( $coupon ) {
                            $coupon->claim();
                            $coupon->save();
                        }
                        $payment = new Lib\Entities\Payment();
                        $payment
                                ->setType(Lib\Entities\Payment::TYPE_ZARIN )
                                ->setStatus(Lib\Entities\Payment::STATUS_COMPLETED )
                                ->setTotal( $total )
                                ->setPaid( $deposit )
								->set( 'paid_type', $total == $deposit ? Lib\Entities\Payment::PAY_IN_FULL : Lib\Entities\Payment::PAY_DEPOSIT )
                                //->set( 'token',   intval($response['refid']) )
                                ->set( 'created',   current_time( 'mysql' ) )
                                ->save();
                            $ca_list = $userData->save( $payment->get( 'id' ) );
                            Lib\NotificationSender::sendFromCart( $ca_list );
                            $payment->setDetails( $ca_list, $coupon )->save();
							$userData->setPaymentStatus( Lib\Entities\Payment::TYPE_ZARIN, 'success' );
                        
                        @wp_redirect( remove_query_arg( Lib\Payment\Zarinpal::$remove_parameters, Lib\Utils\Common::getCurrentPageURL() ) );*/
                        exit;
            } else {
                $error_message = $response["msg"];
			}
        
        if ( ! empty( $error_message ) ) {
            header( 'Location: ' . wp_sanitize_redirect( add_query_arg( array(
                    'bookly_action'    => 'zarin-ec-error',
                    'bookly_fid'    => $form_id,
                    'error_msg' => urlencode( $error_message ),
                ), Lib\Utils\Common::getCurrentPageURL()
                ) ) );
            exit;
        }
    }
    
    /**
     * Process Express Checkout cancel request.
     */
    public static function ecCancel()
    {
        $userData = new Lib\UserBookingData( self::Parameter( 'bookly_fid' ) );
        $userData->load();
        $userData->setPaymentStatus( Lib\Entities\Payment::TYPE_ZARIN, 'cancelled' );
        @wp_redirect( remove_query_arg( Lib\Payment\Zarinpal::$remove_parameters, Lib\Utils\Common::getCurrentPageURL() ) );
        exit;
    }

    /**
     * Process Express Checkout error request.
     */
    public static function ecError()
    {
        $userData = new Lib\UserBookingData( self::Parameter( 'bookly_fid' ) );
        $userData->load();
        $userData->setPaymentStatus( Lib\Entities\Payment::TYPE_ZARIN, 'error', self::Parameter( 'error_msg' ) );
        @wp_redirect( remove_query_arg( Lib\Payment\Zarinpal::$remove_parameters, Lib\Utils\Common::getCurrentPageURL() ) );
        exit;
    }

}