<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use Bookly\Lib\Utils\Common;
use Bookly\Lib\Utils\Price;
?>
<div class="bookly-box bookly-list">
    <label>
        <input type="radio" class="bookly-payment" name="payment-method-<?php echo $form_id ?>" value="mellat"/>
        <span><?php echo Common::getTranslatedOption( 'bookly_l10n_label_pay_mellat' ) ?>
            <?php if ( $show_pay_now ) : ?>
                <?php
                $mellat = clone $cart_info;
                $mellat->setPriceCorrection( get_option( 'bookly_mellat_increase' ), get_option( 'bookly_mellat_addition' ) );
                ?>
                <span class="bookly-js-pay"><?php echo Price::format( $mellat->getPayNow() ) ?></span>
            <?php endif ?>
        </span>
        <img style="margin-left: 5px; float: right;width:25px;" src="<?php echo plugins_url( 'frontend/resources/images/mellat.png', \Bookly\Lib\Plugin::getMainFile() ) ?>" alt="mellat" />
    </label>
    <?php if ( $payment['gateway'] == \Bookly\Lib\Entities\Payment::TYPE_MELLAT && $payment['status'] == 'error' ) : ?>
        <div class="bookly-label-error"><?php echo $payment['data'] ?></div>
    <?php endif ?>
</div>