<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use Bookly\Backend\Components\Settings\Inputs;
use Bookly\Backend\Components\Settings\Selects;
use Bookly\Backend\Modules\Settings\Proxy;
use Bookly\Backend\Components;
?>
<div class="panel panel-default bookly-js-collapse" data-slug="zarin">
    <div class="panel-heading">
        <i class="bookly-js-handle bookly-margin-right-sm bookly-icon bookly-icon-draghandle bookly-cursor-move ui-sortable-handle" title="<?php esc_attr_e( 'Reorder', 'bookly' ) ?>"></i>
        <a href="#bookly_pmt_zarin" class="panel-title" role="button" data-toggle="collapse">
            زرین پال
        </a>
        <img style="margin-left: 10px; float: right;width:38px;" src="<?php echo plugins_url( 'frontend/resources/images/zarinpal.svg', \Bookly\Lib\Plugin::getMainFile() ) ?>" />
    </div>
    <div id="bookly_pmt_zarin" class="panel-collapse collapse in">
        <div class="panel-body">
            <div class="form-group">
                <?php Selects::renderSingle( 'bookly_pmt_zarin', null, null,array(array( 'disabled', __( 'Disabled', 'bookly' ) ),array( 'ec', __('Enable Zarin Pal','bookly' ) ) )) ?>
            </div>
            <div class="bookly-zarin">
                <div class="bookly-zarin-ec">
                    <?php Inputs::renderText( 'bookly_pmt_zarin_url', __( 'API Url', 'bookly' ) ) ?>
					<?php Inputs::renderText( 'bookly_pmt_zarin_merchantid', __( 'API Marchant ID', 'bookly' ) ) ?>
					<?php Selects::renderSingle( 'bookly_pmt_zarin_sandbox', __( 'Sandbox Mode', 'bookly' ), null, array( array( 1, __( 'Yes', 'bookly' ) ), array( 0, __( 'No', 'bookly' ) ) ) ) ?>
                </div>
            </div>
        </div>
    </div>
</div>