<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
use Bookly\Backend\Components\Settings\Inputs;
use Bookly\Backend\Components\Settings\Selects;
use Bookly\Backend\Modules\Settings\Proxy;
use Bookly\Backend\Components;
?>
<div class="panel panel-default bookly-js-collapse" data-slug="mellat">
    <div class="panel-heading">
        <i class="bookly-js-handle bookly-margin-right-sm bookly-icon bookly-icon-draghandle bookly-cursor-move ui-sortable-handle" title="<?php esc_attr_e( 'Reorder', 'bookly' ) ?>"></i>
        <a href="#bookly_pmt_mellat" class="panel-title" role="button" data-toggle="collapse">
            بانک ملت
        </a>
        <img style="margin-left: 10px; float: right;width:38px;" src="<?php echo plugins_url( 'frontend/resources/images/mellat.png', \Bookly\Lib\Plugin::getMainFile() ) ?>" />
    </div>
    <div id="bookly_pmt_mellat" class="panel-collapse collapse in">
        <div class="panel-body">
            <div class="form-group">
                <?php Selects::renderSingle( 'bookly_pmt_mellat', null, null,array(array( 'disabled', __( 'Disabled', 'bookly' ) ),array( 'ec', __('Enable Mellat Gateway','bookly' ) ) )) ?>
            </div>
            <div class="bookly-mellat">
                <div class="bookly-mellat-ec">
                    <?php Inputs::renderText( 'bookly_pmt_mellat_url', __( 'API Url', 'bookly' ) ) ?>
                    <?php Inputs::renderText( 'bookly_pmt_mellat_serverurl', __( 'API Server Url', 'bookly' ) ) ?>
                    <?php Inputs::renderText( 'bookly_pmt_mellat_namespace', __( 'API namespace', 'bookly' ) ) ?>
					<?php Inputs::renderText( 'bookly_pmt_mellat_terminalID', __( 'API Marchant ID', 'bookly' ) ) ?>
					<?php Inputs::renderText( 'bookly_pmt_mellat_username', __( 'API Username', 'bookly' ) ) ?>
					<?php Inputs::renderText( 'bookly_pmt_mellat_password', __( 'API Password', 'bookly' ) ) ?>
                </div>
            </div>
        </div>
    </div>
</div>