<?php
/*
Template Name: Blog Template
*/
?><?php get_header();

	while(have_posts()): the_post();

	  //GETTING META VALUES...
	  $meta_set = get_post_meta($post->ID, '_tpl_default_settings', true);
	  if($GLOBALS['force_enable'] == true)
	  	$page_layout = $GLOBALS['page_layout'];
	  else
	  	$page_layout = !empty($meta_set['layout']) ? $meta_set['layout'] : $GLOBALS['page_layout']; ?>

	  <div class="banner"></div>
      <!-- Page Section Starts here -->
      <section id="post-<?php the_ID(); ?>" <?php post_class('content inner-page'); ?>>
          <?php if(!is_front_page() and !is_home()): ?>
              <div class="main-title">
                  <div class="container">
                      <h1><?php the_title(); ?></h1>
                  </div>
              </div>
          <?php endif; ?>
          <div class="content-main">                
              <div class="container">
              
                  <!-- Primary -->
                  <div id="primary" class="<?php echo esc_attr($page_layout); ?>"><?php
				  	  the_content();
					  wp_link_pages(array('before' => '<div class="page-link"><strong>'.__('Pages:', 'appmojo').'</strong> ', 'after' => '</div>', 'next_or_number' => 'number'));
					  
					  //PERFORMING BLOG LAYOUT...
					  get_template_part('includes/blog-post-layout');
					  edit_post_link(__('Edit', 'appmojo'), '<span class="edit-link">', '</span>' ); ?>
                  </div><!-- Primary -->
                  
                  <!-- Secondary -->
				  <?php if($page_layout != 'content-full-width' && $page_layout == 'with-left-sidebar'): ?>
                      <div id="secondary" class="left-sidebar"><?php get_sidebar(); ?></div>
                  <?php elseif($page_layout != 'content-full-width' && $page_layout == 'with-right-sidebar'): ?>    
                      <div id="secondary"><?php get_sidebar(); ?></div>
                  <?php endif; ?><!-- Secondary -->
              
              </div>                                
          </div>
      </section><!-- Page Section Ends here -->
      
	<?php endwhile; ?>      

<?php get_footer(); ?>