<?php get_header(); ?>
	<?php
		//Getting Menu Items..
		$menuobj = dt_get_theme_menu('header_menu');
		
		$sections = array();
		if(!is_wp_error($menuobj) && !empty($menuobj)):
			$menu_items = wp_get_nav_menu_items( $menuobj->term_id, array('output' => ARRAY_A) );			
		endif;
		
		if(isset($menu_items) != NULL):
			foreach($menu_items as $menu_item):
				if($menu_item->post_status == 'publish' && $menu_item->menu_item_parent == 0 && $menu_item->object == 'page' && !in_array('external', $menu_item->classes)):
					$title = $menu_item->title;
					$page_id = $menu_item->object_id;
					$sections[$page_id] = $title;
				endif;
			endforeach;
		endif;

		//PERFORMING QUERY...
		if(count($sections) > 0):
			$args = array('post_type' => 'page', 'post__in' => array_keys($sections), 'orderby' => 'post__in', 'posts_per_page' => -1);
			$wp_query = new WP_Query($args);
			if($wp_query->have_posts()):
				$i = 0;
				while($wp_query->have_posts()):
					$wp_query->the_post();
					$page_meta = get_post_meta($post->ID, "_tpl_default_settings", true); ?>
					
					<section id="<?php echo $post->post_name; ?>" class="content">
					
                    	<?php if(isset($page_meta['show_slider']) && (isset($page_meta['layerslider_id']) || isset($page_meta['revolutionslider_id']))): ?>
                            <div class="banner">
								<div id="dtslider"><?php
									//GETTING SLIDERS...
									if($page_meta['slider_type'] == 'revolutionslider' && $page_meta['revolutionslider_id'] != NULL):									
										echo do_shortcode("[rev_slider ".$page_meta['revolutionslider_id']."]");
									elseif($page_meta['slider_type'] == 'layerslider' && $page_meta['layerslider_id'] != NULL):
										echo do_shortcode("[layerslider id='".$page_meta['layerslider_id']."']");
									endif; ?>
                                </div>
                                <div class="banner-shadow"></div>
                            </div>
						<?php endif; ?>
                        
						<?php if($i >= 1): ?>
                            <div class="main-title">
                                <div class="container">
                                    <h2><?php echo $sections[$post->ID]; ?></h2>
                                </div>
                            </div><!-- Main title Ends -->
                        <?php endif; ?>
                        
						<div class="content-main">                        
							<?php if(get_post_meta($post->ID, '_wp_page_template', true) == "default"): ?>
                            
                                <div class="container"><?php 
									the_content();
									wp_link_pages(array('before' => '<div class="page-link"><strong>'.__('Pages:', 'appmojo').'</strong> ', 'after' => '</div>', 'next_or_number' => 'number')); ?></div>
                            
                            <?php elseif(get_post_meta($post->ID, '_wp_page_template', true) == "tpl-portfolio.php"): ?>
                                <div class="container">
	                                <?php
                                    the_content();
									wp_link_pages(array('before' => '<div class="page-link"><strong>'.__('Pages:', 'appmojo').'</strong> ', 'after' => '</div>', 'next_or_number' => 'number'));
									get_template_part('includes/onepage-portfolio-post-layout'); ?>
                                </div>
                                
                            <?php elseif(get_post_meta($post->ID, '_wp_page_template', true) == "tpl-blog.php"): ?>
                                <div class="container">
	                                <?php
                                    the_content();
									wp_link_pages(array('before' => '<div class="page-link"><strong>'.__('Pages:', 'appmojo').'</strong> ', 'after' => '</div>', 'next_or_number' => 'number'));
									get_template_part('includes/onepage-blog-post-layout'); ?>
                                </div>
                                
                            <?php endif; ?>
						</div><!-- Content main Ends -->
						
					</section><?php
					$i = $i + 1;
				endwhile;
				wp_reset_query($wp_query);
			endif;
			
		//DEFAULT BLOG LISTING...
		else:
			$page_layout = mytheme_option('specialty', 'archives-layout'); ?>
            <div class="banner"></div>
			<section id="post-<?php the_ID(); ?>" <?php post_class('content inner-page'); ?>>
                <div class="main-title">
	                <div class="container">
    	                <h1><?php bloginfo('title'); ?></h1>
        	        </div>
            	</div>
                <div class="content-main">                
                    <div class="container">
                    
                        <!-- Primary -->
                        <div id="primary" class="<?php echo esc_attr($page_layout); ?>"><?php
                            get_template_part('includes/archive-blog-post'); ?>
                        </div><!-- Primary -->
                        
                        <!-- Secondary -->
                        <?php if($page_layout != 'content-full-width' && $page_layout == 'with-left-sidebar'): ?>
                            <div id="secondary" class="left-sidebar"><?php get_sidebar(); ?></div>
                        <?php elseif($page_layout != 'content-full-width' && $page_layout == 'with-right-sidebar'): ?>    
                            <div id="secondary"><?php get_sidebar(); ?></div>
                        <?php endif; ?><!-- Secondary -->
                    
                    </div>                                
                </div>
	      </section><?php
		endif; ?>

<?php get_footer(); ?>