<?php
	//PERFORMING PORTFOLIO POST LAYOUT...
	$meta_set = get_post_meta($post->ID, '_tpl_default_settings', true);
	if($GLOBALS['force_enable'] == true)
	  $page_layout = $GLOBALS['page_layout'];
	else
	  $page_layout = !empty($meta_set['layout']) ? $meta_set['layout'] : $GLOBALS['page_layout'];
	$post_layout = !empty($meta_set['portfolio-post-layout']) ? $meta_set['portfolio-post-layout'] : 'one-column';

	$li_class = "";
	$feature_image = "";
	
	//POST LAYOUT CHECK...
	if($post_layout == "one-column") {
		$li_class = "portfolio dt-sc-one-column column";
		$feature_image = "portfolio-onecol";
	}
	elseif($post_layout == "one-half-column") {
		$li_class = "portfolio dt-sc-one-half column";
		$feature_image = "portfolio-twocol";
	}
	elseif($post_layout == "one-third-column") {
		$li_class = "portfolio dt-sc-one-third column";
		$feature_image = "portfolio-threecol";
	}
	elseif($post_layout == "one-fourth-column") {
		$li_class = "portfolio dt-sc-one-fourth column";
		$feature_image = "portfolio-fourcol";
	}
	
	//PAGE LAYOUT CHECK...
	if($page_layout != "content-full-width") {
		$li_class = $li_class." with-sidebar";
		$feature_image = $feature_image."-sidebar";
	}
	
	//POST VALUES....
	$limit = $meta_set['portfolio-post-per-page'];
	$cats  = $meta_set['portfolio-categories'];
	
	$cats = array_filter(array_unique($cats));
	
	if(empty($cats)) {
		$cats = get_categories('taxonomy=portfolio_entries&hide_empty=1');
		$cats = get_terms( array('portfolio_entries'), array('fields' => 'ids'));		
	}
	
	//PERFORMING QUERY...
	if ( get_query_var('paged') ) { $paged = get_query_var('paged'); }
	elseif ( get_query_var('page') ) { $paged = get_query_var('page'); }
	else { $paged = 1; }
	
	//PERFORMING QUERY...	
	$args = array('post_type' => 'dt_portfolios', 'paged' => $paged , 'posts_per_page' => $limit,
																				   'tax_query' => array( 
																						array( 
																								'taxonomy' => 'portfolio_entries', 
																								'field' => 'id', 
																								'terms' => $cats
																						)));
	$wp_query = new WP_Query($args);
	if($wp_query->have_posts()): 
	
	 if(isset($meta_set['filter']) != ""): ?>
         <div class="sorting-container">
            <a data-filter="*" href="#" class="active-sort"><?php _e('All', 'appmojo'); ?></a>
            <?php
				foreach($cats as $term) {
					$myterm = get_term_by('id', $term, 'portfolio_entries');
					?><a href="#" data-filter=".<?php echo strtolower($myterm->slug); ?>"><?php echo $myterm->name; ?></a><?php
				}?>
         </div>
		 <div class="margin25"></div><?php
	 endif; ?>
     
     <div class="portfolio-container"><?php
		while($wp_query->have_posts()): $wp_query->the_post(); 
			$terms = wp_get_post_terms($post->ID, 'portfolio_entries', array("fields" => "slugs")); array_walk($terms, "arr_strfun"); ?>
			<div class="<?php echo $li_class." ".strtolower(implode(" ", $terms)); ?>">
              <div class="portfolio-thumb"><?php
				$fullimg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full', false);
				$currenturl = $fullimg[0];
				$currenticon = "icon-search";
				$pmeta_set = get_post_meta($post->ID, '_portfolio_settings', true);
				if( array_key_exists('items_thumbnail', $pmeta_set) && ($pmeta_set ['items_name'] [0] == 'video' )) {
					$currenturl = $pmeta_set ['items'] [0];
					$currenticon = "icon-facetime-video";
				}
				//PORTFOLIO IMAGES...
				if(has_post_thumbnail()):
					$attr = array('title' => get_the_title(), 'alt' => get_the_title()); 
					the_post_thumbnail($feature_image, $attr); 
				else: ?>
					<img src="http<?php mytheme_ssl(true);?>://placehold.it/680X350.jpg&text=<?php the_title(); ?>" alt="<?php the_title(); ?>" title="<?php the_title(); ?>" /><?php
				endif; ?>
				<div class="image-overlay">
					<a class="link" href="<?php the_permalink(); ?>"> <span class="icon-link"> </span> </a>                
					<a class="zoom" title="<?php the_title(); ?>" data-gal="prettyPhoto[gallery]" href="<?php echo esc_url($currenturl); ?>"><span class="<?php echo esc_attr($currenticon); ?>"> </span></a>
				</div>                        
              </div>
              <div class="portfolio-detail">
                <div class="portfolio-title">
                    <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                    <p><?php echo get_the_term_list($post->ID, 'portfolio_entries', ' ', ', ', ' '); ?></p>
                </div>
                <?php if(mytheme_is_plugin_active('roses-like-this/likethis.php')): ?>
                    <div class="views">
                        <span><i class="icon-heart"></i><br><?php printLikes($post->ID); ?></span>
                    </div>
                <?php endif; ?>    
              </div>
	        </div><?php
		endwhile; ?>
     </div>
     <div class="margin40"></div><?php
	 //Pagination...
	 if($wp_query->max_num_pages > 1): ?>
		<div class="pagination">
			<ul><?php if(function_exists("my_pagination")) echo my_pagination("", $wp_query->max_num_pages, $wp_query); ?></ul>
		</div><?php
	 endif;
	 wp_reset_query($wp_query);
	 else: ?>
		<h2><?php _e('Nothing Found.', 'appmojo'); ?></h2>
		<p><?php _e('Apologies, but no results were found for the requested archive.', 'appmojo'); ?></p><?php
	endif; ?>