<?php
	//PERFORMING BLOG POST LAYOUT...
	$page_layout = "";
	$post_layout = "";
	
	if(is_archive() || is_home()) {
		$page_layout = mytheme_option('specialty', 'archives-layout');
		$page_layout = !empty($page_layout) ? $page_layout : 'with-left-sidebar';
		$post_layout = mytheme_option('specialty', 'archives-post-layout');
		$post_layout = !empty($post_layout) ? $post_layout : 'one-column';
	}
	elseif(is_search()) {
		$page_layout = mytheme_option('specialty', 'search-layout');
		$page_layout = !empty($page_layout) ? $page_layout : 'with-left-sidebar';
		$post_layout = mytheme_option('specialty', 'search-post-layout');
		$post_layout = !empty($post_layout) ? $post_layout : 'one-column';
	}
	
	$article_class = "";
	$feature_image = "";
	$column = "";
	
	//POST LAYOUT CHECK...
	if($post_layout == "one-column") {
		$article_class = "column dt-sc-one-column";
		$feature_image = "blog-onecol";
	}
	elseif($post_layout == "one-half-column") {
		$article_class = "column dt-sc-one-half";
		$feature_image = "blog-twocol";
		$column = 2;
	}
	elseif($post_layout == "one-third-column" || $post_layout == "one-fourth-column") {
		$article_class = "column dt-sc-one-third";
		$feature_image = "blog-threecol";
		$column = 3;
	}
	
	//PAGE LAYOUT CHECK...
	if($page_layout != "content-full-width") {
		$feature_image = $feature_image."-sidebar";
	}
	
	//PERFORMING QUERY...
	global $wp_query;
	
	if(have_posts()): $i = 1;
	  while(have_posts()): the_post();
  	 	$temp_class = "";
		
		if($i == 1) $temp_class = $article_class." first"; else $temp_class = $article_class;
		if($i == $column) $i = 1; else $i = $i + 1; ?>

        <div class="<?php echo esc_attr($temp_class); ?>">
            <article id="post-<?php the_ID(); ?>" <?php post_class('blog-post'); ?>>
                <header class="post-meta<?php if(is_sticky()) echo " sticky"; ?>">
                      <div class="date">
                          <span class="day"><?php echo get_the_date('d'); ?></span>
                          <span class="date-group"><?php echo get_the_date('M'); ?><br><?php echo get_the_date('Y'); ?></span>
                      </div><?php
                      comments_popup_link('<span class="icon-comment"><span>0</span></span><span class="icon-cmdtxt">comments</span>','<span class="icon-comment"><span>1</span></span><span class="icon-cmdtxt">comment</span>','<span class="icon-comment"><span>%</span></span><span class="icon-cmdtxt">comments</span>', 'comments', '<span class="icon-cmdtxt">comments off</span>');
					//POST FORMAT...
					$format = get_post_format();
					$pholder = mytheme_option('general', 'disable-placeholder-images'); ?>
                    <div class="post-format"><span class="post-icon-format"> </span></div>
                </header>
                
                <div class="post-thumb">
                    <!-- POST FORMAT STARTS -->
                    <?php if( $format === "image" || empty($format) ):
							if( has_post_thumbnail() ): ?>
								<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php
									$attr = array('title' => get_the_title()); the_post_thumbnail($feature_image, $attr); ?>
								</a><?php
							elseif($pholder != "true"): ?>
								<a href="<?php the_permalink();?>" title="<?php the_title(); ?>">
									<img src="http<?php mytheme_ssl(true);?>://placehold.it/940x425&text=<?php the_title(); ?>" alt="<?php the_title(); ?>" />
								</a><?php
							endif;
                    	  elseif( $format === "gallery" ):
                            $post_meta = get_post_meta(get_the_id() ,'_dt_post_settings', true);
							$post_meta = is_array($post_meta) ? $post_meta : array();
                            if( array_key_exists("items", $post_meta) ):
                                echo "<ul class='entry-gallery-post-slider'>";
                                foreach ( $post_meta['items'] as $item ) { echo "<li><img src='{$item}' alt='gal-img' /></li>";	}
                                echo "</ul>";
                            endif;
                          elseif( $format === "video" ):
                                $post_meta =  get_post_meta(get_the_id() ,'_dt_post_settings', true);
								$post_meta = is_array($post_meta) ? $post_meta : array();
                                if( array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta) ):
                                    if( array_key_exists('oembed-url', $post_meta) ):
                                        echo "<div class='dt-video-wrap'>".wp_oembed_get($post_meta['oembed-url']).'</div>';
                                    elseif( array_key_exists('self-hosted-url', $post_meta) ):
                                        echo "<div class='dt-video-wrap'>".wp_video_shortcode( array('src' => $post_meta['self-hosted-url']) ).'</div>';
                                    endif;
                                endif;
                          elseif( $format === "audio" ):
                                $post_meta =  get_post_meta(get_the_id() ,'_dt_post_settings', true);
								$post_meta = is_array($post_meta) ? $post_meta : array();
                                if( array_key_exists('oembed-url', $post_meta) || array_key_exists('self-hosted-url', $post_meta) ):
                                    if( array_key_exists('oembed-url', $post_meta) ):
                                        echo wp_oembed_get($post_meta['oembed-url']);
                                    elseif( array_key_exists('self-hosted-url', $post_meta) ):
                                        echo wp_audio_shortcode( array('src' => $post_meta['self-hosted-url']) );
                                    endif;
                                endif;
                          else:
							if( has_post_thumbnail() ): ?>
								<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php
									$attr = array('title' => get_the_title()); the_post_thumbnail($feature_image, $attr); ?>
								</a><?php
							elseif($pholder != "true"): ?>
								<a href="<?php the_permalink();?>" title="<?php the_title(); ?>">
									<img src="http<?php mytheme_ssl(true);?>://placeholsdsdd.it/940x425&text=<?php the_title(); ?>" alt="<?php the_title(); ?>" />
								</a><?php
							endif;
                    	 endif; ?>
                    <!-- POST FORMAT ENDS -->
				</div>
                                
                <div class="entry-details">
                    <h2><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
                    <div class="entry-meta"><?php							  
                      _e('Posted by', 'appmojo'); ?> : <a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><?php the_author_meta('display_name'); ?></a><?php
                      if(count(get_the_category())) { _e(' Categories', 'appmojo'); ?> : <?php the_category(', '); }
                      the_tags(__(' and Tags : ', 'appmojo'), ', ', ''); ?>                                  
                    </div>
                    <?php the_excerpt(); ?>
                </div>
            </article>
            <div class="margin40"></div>
		</div><?php
	  endwhile;
	  if($wp_query->max_num_pages > 1): ?>
		  <div class="pagination">
			  <ul><?php if(function_exists("my_pagination")) echo my_pagination("", $wp_query->max_num_pages, $wp_query); ?></ul>
		  </div><?php
	   endif;
	   wp_reset_query($wp_query);
	  else: ?>
		  <h2><?php _e('Nothing Found.', 'appmojo'); ?></h2>
		  <p><?php _e('Apologies, but no results were found for the requested archive.', 'appmojo'); ?></p><?php
	  endif; ?>