<?php
/**
 * mytheme_canonical()
 * Objective:
 * Generate the Canonical url
 * This function called at register_public.php via mytheme_seo_meta();
 */
if(! function_exists('mytheme_canonical')){
function mytheme_canonical() {
	$canonical = false;
	if (is_singular () || is_single ()) :
		$canonical = get_permalink ( get_queried_object () );
		
		// Fix paginated pages
		if (get_query_var ( 'paged' ) > 1) :
			global $wp_rewrite;
			if (! $wp_rewrite->using_permalinks ()) :
				$canonical = add_query_arg ( 'paged', get_query_var ( 'paged' ), $canonical );
			 else :
				$canonical = user_trailingslashit ( trailingslashit ( $canonical ) . 'page/' . get_query_var ( 'paged' ) );
			endif;
		
	endif;
	 else :
		if (is_front_page ()) :
			$canonical = home_url ( '/' );
		 elseif (is_home () && "page" == get_option ( 'show_on_front' )) :
			$canonical = get_permalink ( get_option ( 'page_for_posts' ) );
		 elseif (is_tax () || is_tag () || is_category ()) :
			$term = get_queried_object ();
			$canonical = get_term_link ( $term, $term->taxonomy );
		 elseif (function_exists ( 'get_post_type_archive_link' ) && is_post_type_archive ()) :
			$canonical = get_post_type_archive_link ( get_post_type () );
		 elseif (is_author ()) :
			$canonical = get_author_posts_url ( get_query_var ( 'author' ), get_query_var ( 'author_name' ) );
		 elseif (is_archive ()) :
			if (is_date ()) :
				if (is_day ()) :
					$canonical = get_day_link ( get_query_var ( 'year' ), get_query_var ( 'monthnum' ), get_query_var ( 'day' ) );
				 elseif (is_month ()) :
					$canonical = get_month_link ( get_query_var ( 'year' ), get_query_var ( 'monthnum' ) );
				 elseif (is_year ()) :
					$canonical = get_year_link ( get_query_var ( 'year' ) );
				endif;
			
			
					endif;
		endif;
		
		if ($canonical && get_query_var ( 'paged' ) > 1) :
			global $wp_rewrite;
			if (! $wp_rewrite->using_permalinks ())
				$canonical = add_query_arg ( 'paged', get_query_var ( 'paged' ), $canonical );
			else
				$canonical = user_trailingslashit ( trailingslashit ( $canonical ) . trailingslashit ( $wp_rewrite->pagination_base ) . get_query_var ( 'paged' ) );
		
		
		endif;
	endif;
	return $canonical;
}
}
// # --- **** mytheme_canonical() *** --- ###

/**
 * show_fblike()
 * Objective:
 * Outputs the facebook like button in post and page.
 */
if(! function_exists('show_fblike')){
function show_fblike($arg = 'post') {
	$fb = mytheme_option ( 'integration', "{$arg}-fb_like" );
	$output = "";
	if (! empty ( $fb )) :
		$layout = mytheme_option ( 'integration', "{$arg}-fb_like-layout" );
		$scheme = mytheme_option ( 'integration', "{$arg}-fb_like-color-scheme" );
		$output .= do_shortcode ( "[fblike layout='{$layout}' colorscheme='{$scheme}' /]" );
		echo $output;
	endif;
}
}
// # --- **** show_googleplus() *** --- ###
/**
 * show_googleplus()
 * Objective:
 * Outputs the facebook like button in post and page.
 */
if(! function_exists('show_googleplus')){
function show_googleplus($arg = 'post') {
	$googleplus = mytheme_option ( 'integration', "{$arg}-googleplus" );
	$output = "";
	if (! empty ( $googleplus )) :
		$layout = mytheme_option ( 'integration', "{$arg}-googleplus-layout" );
		$lang = mytheme_option ( 'integration', "{$arg}-googleplus-lang" );
		$output .= do_shortcode ( "[googleplusone size='{$layout}' lang='{$lang}' /]" );
		echo $output;
	endif;
}
}
// # --- **** show_googleplus() *** --- ###

// # --- **** show_twitter() *** --- ###
/**
 * show_twitter()
 * Objective:
 * Outputs the Twitter like button in post and page.
 */
if(! function_exists('show_twitter')){
function show_twitter($arg = 'post') {
	$twitter = mytheme_option ( 'integration', "{$arg}-twitter" );
	$output = "";
	if (! empty ( $twitter )) :
		$layout = mytheme_option ( 'integration', "{$arg}-twitter-layout" );
		$lang = mytheme_option ( 'integration', "{$arg}-twitter-lang" );
		$username = mytheme_option ( 'integration', "{$arg}-twitter-username" );
		$output .= do_shortcode ( "[twitter layout='{$layout}' lang='{$lang}' username='{$username}' /]" );
		echo $output;
	endif;
}
}
// # --- **** show_twitter() *** --- ###

// # --- **** show_stumbleupon() *** --- ###
/**
 * show_stumbleupon()
 * Objective:
 * Outputs the Stumbleupon like button in post and page.
 */
if(! function_exists('show_stumbleupon')){
function show_stumbleupon($arg = 'post') {
	$stumbleupon = mytheme_option ( 'integration', "{$arg}-stumbleupon" );
	$output = "";
	if (! empty ( $stumbleupon )) :
		$layout = mytheme_option ( 'integration', "{$arg}-stumbleupon-layout" );
		$output .= do_shortcode ( "[stumbleupon layout='{$layout}' /]" );
		echo $output;
	endif;
}
}
// # --- **** show_stumbleupon() *** --- ###

// # --- **** show_linkedin() *** --- ###
/**
 * show_linkedin()
 * Objective:
 * Outputs the LinkedIn like button in post and page.
 */
if(! function_exists('show_linkedin')){
function show_linkedin($arg = 'post') {
	$linkedin = mytheme_option ( 'integration', "{$arg}-linkedin" );
	$output = "";
	if (! empty ( $linkedin )) :
		$layout = mytheme_option ( 'integration', "{$arg}-linkedin-layout" );
		$output .= do_shortcode ( "[linkedin layout='{$layout}' /]" );
		echo $output;
	endif;
}
}
// # --- **** show_linkedin() *** --- ###

// # --- **** show_delicious() *** --- ###
/**
 * show_delicious()
 * Objective:
 * Outputs the Delicious like button in post and page.
 */
if(! function_exists('show_delicious')){
function show_delicious($arg = 'post') {
	$delicious = mytheme_option ( 'integration', "{$arg}-delicious" );
	$output = "";
	if (! empty ( $delicious )) :
		$text = mytheme_option ( 'integration', "{$arg}-delicious-text" );
		$output .= do_shortcode ( "[delicious text='{$text}' /]" );
		echo $output;
	endif;
}
}
// # --- **** show_delicious() *** --- ###

// # --- **** show_pintrest() *** --- ###
/**
 * show_pintrest()
 * Objective:
 * Outputs the Pintrest like button in post and page.
 */
if(! function_exists('show_pintrest')){
function show_pintrest($arg = 'post') {
	$delicious = mytheme_option ( 'integration', "{$arg}-pintrest" );
	$output = "";
	if (! empty ( $delicious )) :
		$layout = mytheme_option ( 'integration', "{$arg}-pintrest-layout" );
		$output .= do_shortcode ( "[pintrest layout='{$layout}' prompt='true' /]" );
		echo $output;
	endif;
}
}
// # --- **** show_pintrest() *** --- ###

// # --- **** show_digg() *** --- ###
/**
 * show_digg()
 * Objective:
 * Outputs the Digg like button in post and page.
 */
if(! function_exists('show_digg')){
function show_digg($arg = 'post') {
	$digg = mytheme_option ( 'integration', "{$arg}-digg" );
	$output = "";
	if (! empty ( $digg )) :
		$layout = mytheme_option ( 'integration', "{$arg}-digg-layout" );
		$output .= do_shortcode ( "[digg layout='{$layout}' /]" );
		echo $output;
	endif;
}
}
// # --- **** show_digg() *** --- ###

/**
 * my_tweetbox_filter()
 * Objective:
 * Returns filtered tweets.
 * @args:
 * 1.text :	Tweets text to filter
 */
if(! function_exists('my_tweetbox_filter')){
function my_tweetbox_filter($text) {
	// Props to Allen Shaw & webmancers.com & Michael Voigt
	$text = preg_replace ( '/\b([a-zA-Z]+:\/\/[\w_.\-]+\.[a-zA-Z]{2,6}[\/\w\-~.?=&%#+$*!]*)\b/i', "<a href=\"$1\" class=\"twitter-link\">$1</a>", $text );
	$text = preg_replace ( '/\b(?<!:\/\/)(www\.[\w_.\-]+\.[a-zA-Z]{2,6}[\/\w\-~.?=&%#+$*!]*)\b/i', "<a href=\"http".mytheme_ssl()."://$1\" class=\"twitter-link\">$1</a>", $text );
	$text = preg_replace ( "/\b([a-zA-Z][a-zA-Z0-9\_\.\-]*[a-zA-Z]*\@[a-zA-Z][a-zA-Z0-9\_\.\-]*[a-zA-Z]{2,6})\b/i", "<a href=\"mailto://$1\" class=\"twitter-link\">$1</a>", $text );
	$text = preg_replace ( "/#(\w+)/", "<a class=\"twitter-link\" href=\"http".mytheme_ssl()."://search.twitter.com/search?q=\\1\">#\\1</a>", $text );
	$text = preg_replace ( "/@(\w+)/", "<a class=\"twitter-link\" href=\"http".mytheme_ssl()."://twitter.com/\\1\">@\\1</a>", $text );
	return $text;
}
}
// # --- **** my_tweetbox_filter() *** --- ###

/**
 * mytheme_footer_widgetarea()
 * Objective:
 * 1.
 * To Generate Footer Widget Areas
 * Args: $count = No of widget areas
 */
if(! function_exists('mytheme_footer_widgetarea')){
function mytheme_footer_widgetarea($count) {
	$name = __ ( "Footer Column", 'appmojo' );
	if ($count <= 4) :
		for($i = 1; $i <= $count; $i ++) :
			register_sidebar ( array (
					'name' => $name . "-{$i}",
					'id' => "footer-sidebar-{$i}",
					'before_widget' => '<aside id="%1$s" class="widget %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<h3 class="widgettitle">',
					'after_title' => '</h3>' 
			) );
		endfor;
	 elseif ($count == 5 || $count == 6) :
		$a = array (
				"1-4",
				"1-4",
				"1-2" 
		);
		$a = ($count == 5) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			register_sidebar ( array (
					'name' => $name . "-{$v}",
					'id' => "footer-sidebar-{$k}-{$v}",
					'before_widget' => '<aside id="%1$s" class="widget %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<h3 class="widgettitle">',
					'after_title' => '</h3>' 
			) );
		endforeach;
	 elseif ($count == 7 || $count == 8) :
		$a = array (
				"1-4",
				"3-4" 
		);
		$a = ($count == 7) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			register_sidebar ( array (
					'name' => $name . "-{$v}",
					'id' => "footer-sidebar-{$k}-{$v}",
					'before_widget' => '<aside id="%1$s" class="widget %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<h3 class="widgettitle">',
					'after_title' => '</h3>' 
			) );
		endforeach;
	 elseif ($count == 9 || $count == 10) :
		$a = array (
				"1-3",
				"2-3" 
		);
		$a = ($count == 9) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			register_sidebar ( array (
					'name' => $name . "-{$v}",
					'id' => "footer-sidebar-{$k}-{$v}",
					'before_widget' => '<aside id="%1$s" class="widget %2$s">',
					'after_widget' => '</aside>',
					'before_title' => '<h3 class="widgettitle">',
					'after_title' => '</h3>' 
			) );
		endforeach;
	endif;
}
}
// # --- **** mytheme_footer_widgetarea() *** --- ###

// # --- **** show_footer_widgetarea() *** --- ###
/**
 * show_footer_widgetarea()
 * Objective:
 * Outputs the Footer section widget area.
 */
if(! function_exists('show_footer_widgetarea')){
function show_footer_widgetarea($count) {
	$classes = array (
			"1" => "dt-sc-one-column",
			"dt-sc-one-half",
			"dt-sc-one-third",
			"dt-sc-one-fourth",
			"1-2" => "dt-sc-one-half",
			"1-3" => "dt-sc-one-third",
			"1-4" => "dt-sc-one-fourth",
			"3-4" => "dt-sc-three-fourth",
			"2-3" => "dt-sc-two-third" 
	);
	
	if ($count <= 4) :
		for($i = 1; $i <= $count; $i ++) :
			$class = $classes [$count];
			$first = ($i == 1) ? "first" : "";
			echo "<div class='column {$class} {$first}'>";
			if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$i}" )) : endif;
			echo "</div>";
		endfor;
	 elseif ($count == 5 || $count == 6) :
		$a = array (
				"1-4",
				"1-4",
				"1-2" 
		);
		$a = ($count == 5) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$first = ($k == 0) ? "first" : "";
			echo "<div class='column {$class} {$first}'>";
			if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) : endif;
			echo "</div>";
		endforeach;
	 

	elseif ($count == 7 || $count == 8) :
		$a = array (
				"1-4",
				"3-4" 
		);
		
		$a = ($count == 7) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$first = ($k == 0) ? "first" : "";
			echo "<div class='column {$class} {$first}'>";
			if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) :endif;
			echo "</div>";
		endforeach;
		
	 elseif ($count == 9 || $count == 10) :
		$a = array (
				"1-3",
				"2-3" 
		);
		$a = ($count == 9) ? $a : array_reverse ( $a );
		foreach ( $a as $k => $v ) :
			$class = $classes [$v];
			$first = ($k == 0) ? "first" : "";
			echo "<div class='column {$class} {$first}'>";
			if (function_exists ( 'dynamic_sidebar' ) && dynamic_sidebar ( "footer-sidebar-{$k}-{$v}" )) :endif;
			echo "</div>";
		endforeach;
	endif;
}
}
// # --- **** show_footer_widgetarea() *** --- ###

// # --- **** mytheme_is_plugin_active() *** --- ###
/**
 * mytheme_is_plugin_active()
 * Objective:
 * Check the plugin is activated
 */
if(! function_exists('mytheme_is_plugin_active')){
function mytheme_is_plugin_active($plugin) {
	if (is_multisite ()) :
		$plugins = array ();
		$c_plugins = is_array ( get_site_option ( 'active_sitewide_plugins' ) ) ? get_site_option ( 'active_sitewide_plugins' ) : array ();
		foreach ( array_keys ( $c_plugins ) as $c_plugin ) :
			$plugins [] = $c_plugin;
		endforeach;
		return in_array ( $plugin, $plugins ) || in_array ( $plugin, ( array ) get_option ( 'active_plugins', array () ) );
	 else :
		return in_array ( $plugin, ( array ) get_option ( 'active_plugins', array () ) );
	endif;
}
}
// # --- **** mytheme_is_plugin_active() *** --- ###

// # --- **** check_slider_revolution_responsive_wordpress_plugin() *** --- ###
/**
 * check_slider_revolution_responsive_wordpress_plugin()
 * Objective:
 * Check the "Revolution Responsive WordPress Plugin" is activated
 */
if(! function_exists('check_slider_revolution_responsive_wordpress_plugin')){
function check_slider_revolution_responsive_wordpress_plugin() {
	$sliders = false;
	if (mytheme_is_plugin_active ( 'revslider/revslider.php' )) :
		global $wpdb;
		// table_prefix = WP_ALLOW_MULTISITE ? $wpdb->base_prefix : $wpdb->prefix;
		$table_prefix = $wpdb->prefix;
		$table_name = $table_prefix . "revslider_sliders";
		
		if ($wpdb->get_var ( "SHOW TABLES LIKE '$table_name'" ) == $table_name) :
			$resultset = $wpdb->get_results ( "SELECT title,alias FROM $table_name" );
			foreach ( $resultset as $rs ) :
				$sliders [$rs->alias] = $rs->title;
			endforeach;
			return $sliders;
		 else :
			return $sliders;
		endif;
	 else :
		return $sliders;
	endif;
}
}
// # --- **** mytheme_is_plugin_active() *** --- ###

// # --- **** mytheme_social_bookmarks() *** --- ###
/**
 * mytheme_social_bookmarks()
 * Objective:
 * To show social shares
 */
if(! function_exists('mytheme_social_bookmarks')){
function mytheme_social_bookmarks($arg = 'sb-post') {
	global $post;
	
	$title = $post->post_title;
	$url = get_permalink ( $post->ID );
	$excerpt = $post->post_excerpt;
	$data = "";
	
	$path = IAMD_BASE_URL . "images/sociable/";
	
	$fb = mytheme_option ( 'integration', "{$arg}-fb_like" );
	$data .= ! empty ( $fb ) ? "<li><a href='http".mytheme_ssl()."://www.facebook.com/sharer.php?u=$url&amp;t=" . urlencode ( $title ) . "'>
	<img src='{$path}bookmarks/hover/facebook.png' /><img src='{$path}bookmarks/facebook.png' /></a></li>" : "";
	
	$delicious = mytheme_option ( 'integration', "{$arg}-delicious" );
	$data .= ! empty ( $delicious ) ? "<li><a href='http".mytheme_ssl()."://del.icio.us/post?url=$url&amp;title=" . urlencode ( $title ) . "'>
	<img src='{$path}bookmarks/hover/delicious.png' /><img src='{$path}bookmarks/delicious.png' /></a></li>" : "";
	
	$digg = mytheme_option ( 'integration', "{$arg}-digg" );
	$data .= ! empty ( $digg ) ? "<li><a href='http".mytheme_ssl()."://digg.com/submit?phase=2&amp;url=$url&amp;title=" . urlencode ( $title ) . "'>
	<img src='{$path}bookmarks/hover/digg.png' /><img src='{$path}bookmarks/digg.png' /></a></li>" : "";
	
	$stumbleupon = mytheme_option ( 'integration', "{$arg}-stumbleupon" );
	$data .= ! empty ( $stumbleupon ) ? "<li><a href='http".mytheme_ssl()."://www.stumbleupon.com/submit?url=$url&amp;title=" . urlencode ( $title ) . "'>
	<img src='{$path}bookmarks/hover/stumbleupon.png' /><img src='{$path}bookmarks/stumbleupon.png' /></a></li>" : "";
	
	$twitter = mytheme_option ( 'integration', "{$arg}-twitter" );
	$t_url = ! empty ( $twitter ) ? $url : '';
	$data .= ! empty ( $twitter ) ? "<li><a href='http".mytheme_ssl()."://twitter.com/home/?status=" . urlencode ( $title ) . ":$t_url'>
	<img src='{$path}bookmarks/hover/twitter.png' /><img src='{$path}bookmarks/twitter.png' /></a></li>" : "";
	
	$googleplus = mytheme_option ( 'integration', "{$arg}-googleplus" );
	$data .= ! empty ( $googleplus ) ? "<li><a class=\"google\" href=\"https://plus.google.com/share?url=$url\"  onclick=\"javascript:window.open(this.href,'','menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;\" >
	<img src='{$path}bookmarks/hover/google.png' /><img src='{$path}bookmarks/google.png' /></a></li>" : '';
	
	$linkedin = mytheme_option ( 'integration', "{$arg}-linkedin" );
	$data .= ! empty ( $linkedin ) ? "<li><a href='http".mytheme_ssl()."://www.linkedin.com/shareArticle?mini=true&amp;title=" . urlencode ( $title ) . "&amp;url=$url' title='Share on LinkedIn'>
	<img src='{$path}bookmarks/hover/linkedin.png' /><img src='{$path}bookmarks/linkedin.png' /></a></li>" : "";
	
	$pintrest = mytheme_option ( 'integration', "{$arg}-pintrest" );
	$media = wp_get_attachment_url ( get_post_thumbnail_id ( $post->ID ) );
	$data .= ! empty ( $pintrest ) ? "<li><a href='http".mytheme_ssl()."://pinterest.com/pin/create/button/?url=" . urlencode ( $url ) . "&amp;media=$media'>
	<img src='{$path}bookmarks/hover/pinterest.png' /><img src='{$path}bookmarks/pinterest.png' /></a></li>" : "";
	
	$data = ! empty ( $data ) ? "<ul class='dt-sc-social-icons'>{$data}</ul>" : "";
	echo $data;
}
}
// # --- **** mytheme_social_bookmarks() *** --- ###

// # --- **** is_mytheme_moible_view() *** --- ###
/**
 * dt_is_moible_view()
 * Objective:
 * If you eanble responsive mode in theme , this will add view port at the head
 */
if(! function_exists('is_mytheme_moible_view')){
function is_mytheme_moible_view(){
	$mytheme_options = get_option(IAMD_THEME_SETTINGS);
	$mytheme_mobile = !empty($mytheme_options['mobile']) ? $mytheme_options['mobile'] : "";
	if(isset($mytheme_mobile['is-theme-responsive']))
		echo "<meta name='viewport' content='width=device-width, initial-scale=1' />\r";
}
}
// # --- **** is_mytheme_moible_view() *** --- ###

// o load basic css : default,shortcode & skin css
add_action('wp_head', 'mytheme_front_css', 2);
if(! function_exists('mytheme_front_css')){
function mytheme_front_css() {

	$dt_theme_options = get_option(IAMD_THEME_SETTINGS);
	$dt_theme_general = $dt_theme_options ['general'];
	$template_uri = get_template_directory_uri();

	if (isset ( $dt_theme_general ['enable-favicon'] )) :
		$url = ! empty ( $dt_theme_general ['favicon-url'] ) ? $dt_theme_general ['favicon-url'] : $template_uri . "/images/favicon.png";
		echo "<link href='$url' rel='shortcut icon' type='image/x-icon' />\n";

		$phone_url = ! empty ( $dt_theme_general ['apple-favicon'] ) ? $dt_theme_general ['apple-favicon'] : $template_uri . "/images/apple-touch-icon.png";
		echo "<link href='$phone_url' rel='apple-touch-icon-precomposed'/>\n";

		$phone_retina_url = ! empty ( $dt_theme_general ['apple-retina-favicon'] ) ? $dt_theme_general ['apple-retina-favicon'] : $template_uri . "/images/apple-touch-icon-114x114.png";
		echo "<link href='$phone_retina_url' sizes='114x114' rel='apple-touch-icon-precomposed'/>\n";

		$ipad_url = ! empty ( $dt_theme_general ['apple-ipad-favicon'] ) ? $dt_theme_general ['apple-ipad-favicon'] : $template_uri . "/images/apple-touch-icon-72x72.png";
		echo "<link href='$ipad_url' sizes='72x72' rel='apple-touch-icon-precomposed'/>\n";

		$ipad_retina_url = ! empty ( $dt_theme_general ['apple-ipad-retina-favicon'] ) ? $dt_theme_general ['apple-ipad-retina-favicon'] : $template_uri . "/images/apple-touch-icon-144x144.png";
		echo "<link href='$ipad_retina_url' sizes='144x144' rel='apple-touch-icon-precomposed'/>\n";
	endif;

	wp_enqueue_style('default', get_stylesheet_uri());
	
	if(is_rtl())
		wp_enqueue_style('rtl-css', $template_uri.'/rtl.css');

	//SHORTCODES...
	wp_enqueue_style('shortcode', $template_uri.'/css/shortcode.css');
	
	wp_enqueue_style('meanmenu', $template_uri.'/css/meanmenu.css');
	
	//SKIN...
	if($theme = mytheme_option('appearance','skin'))
		wp_enqueue_style("skin", $template_uri."/skins/$theme/style.css", array(), false, 'all');
	else
		wp_enqueue_style("skin", $template_uri."/skins/skyblue/style.css", array(), false, 'all');

	$dt_theme_mobile = !empty($dt_theme_options['mobile']) ? $dt_theme_options['mobile'] : "";

	//SLIDER DISABLE...
    if(isset($dt_theme_mobile['is-slider-disabled'])):
		$out =	'<style type="text/css">';
		$out .=	'@media only screen and (max-width:320px), (max-width: 479px), (min-width: 480px) and (max-width: 767px), (min-width: 768px) and (max-width: 959px),
		 (max-width:1200px) { .banner #dtslider { display:none !important; } }';
		$out .=	'</style>';
		echo $out;
	endif;
	
	wp_enqueue_style('animations', $template_uri.'/css/animations.css');	
	wp_enqueue_style('isotope', $template_uri.'/css/isotope.css');
	wp_enqueue_style('prettyphoto', $template_uri.'/css/prettyPhoto.css');
	
	//FONT AWESOME...	
	wp_enqueue_style('style.fontawesome', $template_uri.'/css/font-awesome.min.css');
	
	wp_register_style('style.fontie7', $template_uri.'/css/font-awesome-ie7.min.css');
    $GLOBALS['wp_styles']->add_data('style.fontie7', 'conditional', 'IE 7');
    wp_enqueue_style('style.fontie7');

	//WOOCOMMERCE...
	if(mytheme_is_plugin_active('woocommerce/woocommerce.php'))
		wp_enqueue_style('stylewoo', $template_uri.'/framework/woocommerce/css/style.css');
		
	//RESPONSIVE STYLES...
	if(mytheme_option('mobile', 'is-theme-responsive'))
		wp_enqueue_style("responsive", $template_uri."/css/responsive.css");
		
	//WP JQUERY...
	wp_enqueue_script('jquery');
	wp_enqueue_script('modernizr-script', $template_uri.'/framework/js/public/modernizr-2.6.2.min.js');
}
}

if(! function_exists('hex2rgb')){
function hex2rgb($hex) {
	$hex = str_replace ( "#", "", $hex );
	
	if (strlen ( $hex ) == 3) :
		$r = hexdec ( substr ( $hex, 0, 1 ) . substr ( $hex, 0, 1 ) );
		$g = hexdec ( substr ( $hex, 1, 1 ) . substr ( $hex, 1, 1 ) );
		$b = hexdec ( substr ( $hex, 2, 1 ) . substr ( $hex, 2, 1 ) );
	 else :
		$r = hexdec ( substr ( $hex, 0, 2 ) );
		$g = hexdec ( substr ( $hex, 2, 2 ) );
		$b = hexdec ( substr ( $hex, 4, 2 ) );
	endif;
	$rgb = array (
			$r,
			$g,
			$b 
	);
	return $rgb;
}
}
// ##########################################
// PAGINATION
// ##########################################
if(! function_exists('my_pagination')){
function my_pagination($class='',$pages = '', $wp_query){
	$out = NULL;
	$paged = $wp_query->query_vars['paged'];
	if(empty($paged))$paged = 1;
	$prev = $paged - 1;							
	$next = $paged + 1;	
	$range = 10; // only edit this if you want to show more page-links
	$showitems = ($range * 2)+1;
	if($pages == '') {	
		$pages = $wp_query->max_num_pages;
		if(!$pages)	{
			$pages = 1;
		}
	}
	if(1 != $pages){
        if($paged > 1) $out .= "<li><a href='".get_pagenum_link($paged - 1)."'>".__('Prev', 'appmojo')."</a></li>";
	
		for ($i=1; $i <= $pages; $i++){
			if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )){
				if( $class == "ajax-load"):
					$c =  ($paged == $i) ? "active-page" : "";
					$out .= "<li><a href='".get_pagenum_link($i)."' class='".$c."'>".$i."</a></li>";
				else: 
					$out .=  ($paged == $i)? "<li class='active-page'>".$i."</li>":"<li><a href='".get_pagenum_link($i)."' class='inactive'>".$i."</a></li>"; 
				endif;
			}
		}
		
        if ($paged < $pages) $out .= "<li><a href='".get_pagenum_link($paged + 1)."'>".__('Next', 'appmojo')."</a></li>";
	}
	return $out;
}
}
//GETTING MENU OBJECT BY THEME LOCATION...
if(! function_exists('dt_get_theme_menu')){
function dt_get_theme_menu( $theme_location ) {
	if( ! $theme_location ) return false;
 
	$theme_locations = get_nav_menu_locations();
	if( ! isset( $theme_locations[$theme_location] ) ) return false;
 
	$menu_obj = get_term( $theme_locations[$theme_location], 'nav_menu' );
	if( ! $menu_obj ) $menu_obj = false;
 
	return $menu_obj;
}
}
//MY MENU WALKER...
class dt_menu_walker extends Walker_Nav_Menu
{
      function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0)
      {
           global $wp_query;
           $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

           $class_names = $value = '';

           $classes = empty( $item->classes ) ? array() : (array) $item->classes;

           $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
           $class_names = ' class="'. esc_attr( $class_names ) . '"';

           $output .= $indent . '<li id="menu-item-'. $item->ID . '"' . $value . $class_names .'>';

           $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
           $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
           $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
		   
		   if(in_array('external', $item->classes) || $item->object != 'page' || $item->menu_item_parent != 0)
	           $attributes .= ! empty( $item->url )    ? ' href="'   . esc_attr( $item->url    ) .'"' : '';
			else {
			   $pslug = basename( get_permalink($item->object_id) );
			   $attributes .= ! empty( $item->url )    ? ' href="'   . esc_attr( home_url() . '/#' . $pslug ) .'"' : '';
			}

           $item_output = $args->before;
		   
		   if(in_array('external', $item->classes) || $item->object != 'page' || !is_home() || $item->menu_item_parent != 0)
	           $item_output .= '<a'. $attributes .' class = "external">';
		   else
	           $item_output .= '<a'. $attributes .'>';
			   
           $item_output .= $args->link_before .apply_filters( 'the_title', $item->title, $item->ID );
           $item_output .= $args->link_after;
           $item_output .= '</a>';
           $item_output .= $args->after;

           $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
      }
}

if(! function_exists('arr_strfun')){
function arr_strfun(&$item, $key) {
	$item = str_replace(" ", "-", strtolower($item));
}
}
//FOOTER SOCIAL SHOW...
if(! function_exists('dt_social_icons')){
function dt_social_icons() {
	$mytheme_options = get_option(IAMD_THEME_SETTINGS);
	if(!empty($mytheme_options['social'])):
	
		$out = "<ul class='social-media'>";
		foreach($mytheme_options['social'] as $social):
			$link = $social['link'];
			$icon = $social['icon'];
			$out .= "<li>";
				$out .= "<a href='{$link}'>";
				$out .= "<img src='".IAMD_BASE_URL."images/sociable/{$icon}' alt='{$icon}' />";
				$out .="</a>";
			$out .= "</li>"; 
		endforeach;
		$out .= "</ul>";
		
	  return $out;
	endif;
}
}
//LIKE PLUGIN ACTION...
add_action('activated_plugin', 'dt_like_plugin_hook', 1);
if(! function_exists('dt_like_plugin_hook')){
function dt_like_plugin_hook() {
	if(mytheme_is_plugin_active('roses-like-this/likethis.php')) {
		update_option("no_likes", "0");
		update_option("one_like", "%");
		update_option("some_likes", "%");
	}
}
}
if(! function_exists('theme_chk_pp')){
function theme_chk_pp() {
	previous_posts_link("Prev");
	next_posts_link("Next");
}
}
//Filter for oembed_result...
if(! function_exists('slt_wmode_opaque')){
function slt_wmode_opaque( $html, $url, $args ) {	
if( strrpos($url,"youtube") !== false || strrpos($url,"youtu.") !== false ) {
        $patterns[] = '/src="(.*?)"/';
        $replacements[] = 'src="${1}&wmode=opaque"';
        $html =  preg_replace($patterns, $replacements, $html);
        $html = str_replace('</iframe>)', '</iframe>', $html);
        
 }elseif( strrpos($url, "soundcloud.com") !== false ) {
         $patterns[] = '/height="(.*?)"/';
         $replacements[] = 'height="162"';
         $html =  preg_replace($patterns, $replacements, $html);
         
         $patterns[] = '/width="(.*?)"/';
         $replacements[] = 'width="100%"';
         $html =  preg_replace($patterns, $replacements, $html);
         
         $patterns[] = '/visual=true&/';
         $replacements[] = '';
         $html =  preg_replace($patterns, $replacements, $html);
 }
return $html;
}
}
add_filter( 'oembed_result', 'slt_wmode_opaque', 10, 3 );

//Update for page builder latest version...
add_action( 'wp_ajax_dttheme_update_pagebuilder_contents', 'dttheme_update_pagebuilder_contents' );
add_action( 'wp_ajax_nopriv_dttheme_update_pagebuilder_contents', 'dttheme_update_pagebuilder_contents' );
if(! function_exists('dttheme_update_pagebuilder_contents')){
function dttheme_update_pagebuilder_contents() {
	
	// Script to update pages
	$page_args = array('post_type' => 'page' ,'post_status' => 'publish' , 'posts_per_page' =>'-1');
	
	$page_datas = new WP_Query( $page_args );
	if( $page_datas->have_posts() ):
		while( $page_datas->have_posts() ):
			$page_datas->the_post();
				
				$current_page_id = get_the_ID();
				
				$builder_layout = get_post_meta( $current_page_id, '_dt_builder_settings', true );
				$builder_layout = is_array( $builder_layout ) ? $builder_layout  : array();
				$layout_html = array_key_exists('layout_html',$builder_layout ) ? $builder_layout['layout_html'] : '';
				$layout_shortcode = array_key_exists('layout_shortcode',$builder_layout ) ? $builder_layout['layout_shortcode'] : '';
				$layout_parsed = array_key_exists('layout_parsed',$builder_layout ) ? $builder_layout['layout_parsed'] : 'false';
				
				if($layout_parsed != 'true') {
				
					$layout_html_new = str_replace('<span class="dt_add_module_column" title="Add Module" style="display:none;">A</span>', '', $layout_html);
					$layout_html_new = str_replace('<div data-option_name="content" class="content', '<div data-option_name="title_content" class="title_content', $layout_html_new);
					$layout_html_new = str_replace('dt_fullwidth_section_container', 'dt_modules_holder dt_fullwidth_section_container', $layout_html_new);
					$layout_html_new = str_replace('dt_modules_container', 'dt_modules_holder dt_modules_container', $layout_html_new);
					$layout_html_new = mb_convert_encoding($layout_html_new, 'HTML-ENTITIES', "UTF-8");
					
					$doc = new DomDocument();
					$file = @$doc->loadHTML($layout_html_new);
					
					$divtag = $doc->getElementsByTagName('div');
					foreach($divtag AS $item)
					{
					
						$item_class = $item->getAttribute('class');
						$item_class_arr = explode(' ', $item_class);
						
						if(in_array('dt_m_column', $item_class_arr)) {
						
							$add_module_div = $doc->createElement('div', '');
							$add_module_div_class = $doc->createAttribute('class');
							$add_module_div_class->value = 'dt_show_modules_in_popup dt_popup_from_column';
							$add_module_div_title = $doc->createAttribute('title');
							$add_module_div_title->value = 'Add Module';
							
							$add_module_div->appendChild($add_module_div_class);
							$add_module_div->appendChild($add_module_div_title);
							
							$item->appendChild($add_module_div);
							
						}
					
						if(in_array('dt_fullwidth_section', $item_class_arr)) {
						
							$add_module_div = $doc->createElement('div', '');
							$add_module_div_class = $doc->createAttribute('class');
							$add_module_div_class->value = 'dt_show_modules_in_popup dt_popup_from_section';
							$add_module_div_title = $doc->createAttribute('title');
							$add_module_div_title->value = 'Add Module';
							
							$add_module_div->appendChild($add_module_div_class);
							$add_module_div->appendChild($add_module_div_title);
							
							$item->appendChild($add_module_div);
							
						}
					
					}
					
					$layout_html_new = @$doc->saveHTML();
					
					$layout_html_new = str_replace('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">', '', $layout_html_new);
					$layout_html_new = str_replace('<html><body>', '', $layout_html_new);
					$layout_html_new = str_replace('</body></html>', '', $layout_html_new);
					
					$output = array();
					$output['layout_html'] = $layout_html_new;
					$output['layout_shortcode'] = $layout_shortcode;
					$output['layout_parsed'] = 'true';
					
					update_post_meta($current_page_id, '_dt_builder_settings', $output);
				
				}
				
		endwhile;
	endif;
	
	// Script to update posts
	$post_args = array('post_type' => 'post', 'post_status' => 'publish', 'posts_per_page' =>'-1');
	
	$post_datas = new WP_Query( $post_args );
	if( $post_datas->have_posts() ):
		while( $post_datas->have_posts() ):
			$post_datas->the_post();
				
				$current_page_id = get_the_ID();
				
				$builder_layout = get_post_meta( $current_page_id, '_dt_builder_settings', true );
				$builder_layout = is_array( $builder_layout ) ? $builder_layout  : array();
				$layout_html = array_key_exists('layout_html',$builder_layout ) ? $builder_layout['layout_html'] : '';
				$layout_shortcode = array_key_exists('layout_shortcode',$builder_layout ) ? $builder_layout['layout_shortcode'] : '';
				$layout_parsed = array_key_exists('layout_parsed',$builder_layout ) ? $builder_layout['layout_parsed'] : 'false';
				
				if($layout_parsed != 'true') {
				
					$layout_html_new = str_replace('<span class="dt_add_module_column" title="Add Module" style="display:none;">A</span>', '', $layout_html);
					$layout_html_new = str_replace('<div data-option_name="content" class="content', '<div data-option_name="title_content" class="title_content', $layout_html_new);
					$layout_html_new = str_replace('dt_fullwidth_section_container', 'dt_modules_holder dt_fullwidth_section_container', $layout_html_new);
					$layout_html_new = str_replace('dt_modules_container', 'dt_modules_holder dt_modules_container', $layout_html_new);
					$layout_html_new = mb_convert_encoding($layout_html_new, 'HTML-ENTITIES', "UTF-8");
					
					$doc = new DomDocument();
					$file = @$doc->loadHTML($layout_html_new);
					
					$divtag = $doc->getElementsByTagName('div');
					foreach($divtag AS $item)
					{
					
						$item_class = $item->getAttribute('class');
						$item_class_arr = explode(' ', $item_class);
						
						if(in_array('dt_m_column', $item_class_arr)) {
						
							$add_module_div = $doc->createElement('div', '');
							$add_module_div_class = $doc->createAttribute('class');
							$add_module_div_class->value = 'dt_show_modules_in_popup dt_popup_from_column';
							$add_module_div_title = $doc->createAttribute('title');
							$add_module_div_title->value = 'Add Module';
							
							$add_module_div->appendChild($add_module_div_class);
							$add_module_div->appendChild($add_module_div_title);
							
							$item->appendChild($add_module_div);
							
						}
					
						if(in_array('dt_fullwidth_section', $item_class_arr)) {
						
							$add_module_div = $doc->createElement('div', '');
							$add_module_div_class = $doc->createAttribute('class');
							$add_module_div_class->value = 'dt_show_modules_in_popup dt_popup_from_section';
							$add_module_div_title = $doc->createAttribute('title');
							$add_module_div_title->value = 'Add Module';
							
							$add_module_div->appendChild($add_module_div_class);
							$add_module_div->appendChild($add_module_div_title);
							
							$item->appendChild($add_module_div);
							
						}
					
					}
					
					$layout_html_new = @$doc->saveHTML();
					
					$layout_html_new = str_replace('<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">', '', $layout_html_new);
					$layout_html_new = str_replace('<html><body>', '', $layout_html_new);
					$layout_html_new = str_replace('</body></html>', '', $layout_html_new);
					
					$output = array();
					$output['layout_html'] = $layout_html_new;
					$output['layout_shortcode'] = $layout_shortcode;
					$output['layout_parsed'] = 'true';
					
					update_post_meta($current_page_id, '_dt_builder_settings', $output);
				
				}
				
		endwhile;
	endif;
	
	$bp_data = get_option(IAMD_THEME_SETTINGS);
	$bp_data['pagebuilder_update'] = 'done';
	update_option(IAMD_THEME_SETTINGS, $bp_data);
	
	die('1');
	
}
}
// SSL | Attachments
if( ! function_exists( 'mytheme_ssl_attachments' ) )
{
	function mytheme_ssl_attachments( $url ){
		if( is_ssl() ){
			return str_replace('http://', 'https://', $url);
		}
		return $url;
	}
}
add_filter( 'wp_get_attachment_url', 'mytheme_ssl_attachments' );

// Site SSL Compatibility
if(!function_exists('mytheme_ssl')) 
{
	function mytheme_ssl( $echo = false ){
		$ssl = '';
		if( is_ssl() ) $ssl = 's';
		if( $echo ){
			echo esc_html($ssl);
		}
		return $ssl;
	}
} 

/* ---------------------------------------------------------------------------
* Whitelist Associate
* --------------------------------------------------------------------------- */
if ( ! function_exists( 'dt_theme_array_whitelist_assoc' ) ) {
	function dt_theme_array_whitelist_assoc( Array $array1, Array $array2 ) {
		if ( func_num_args() > 2 ) {
			$args = func_get_args();
			array_shift( $args );
			$array2 = call_user_func_array( 'array_merge', $args );
		}

		return array_intersect_key( $array1, array_flip( $array2 ) );
	}
}

/* ---------------------------------------------------------------------------
* Post Type Support
* --------------------------------------------------------------------------- */
add_filter( 'fw_ext_page_builder_supported_post_types', 'dt_theme_limit_post_types_support', 1 );

if (!function_exists('dt_theme_limit_post_types_support')) {
	function dt_theme_limit_post_types_support( $all_post_types ) {
		$white_listed_post_types = array( '' ); //allowed custom post type names
		$post_types              = dt_theme_array_whitelist_assoc( $all_post_types, $white_listed_post_types );
		return $post_types;
	} 

}
?>