<?php if (!function_exists('dt_theme_features')) {

	// Register Theme Features
	function dt_theme_features() {
		global $wp_version;

		// Add theme support for Custom Background
		$b_args = array(
			'default-color' => 'ffffff',
			'default-image' => '',
			'wp-head-callback' => '_custom_background_cb',
			'admin-head-callback' => '',
			'admin-preview-callback' => ''
		);
		add_theme_support('custom-background', $b_args);
		// END of Custom Background Feature

		// Add theme support for Custom Header
		$hargs = array( 'default-image'=>'',	'random-default'=>false,	'width'=>0,					'height'=>0,
				'flex-height'=> false,	'flex-width'=> false,		'default-text-color'=> '',	'header-text'=> false,
				'uploads'=> true,		'wp-head-callback'=> '',	'admin-head-callback'=> '',	'admin-preview-callback' => '');
				
		add_theme_support('custom-header', $hargs);
		// END of Custom Header Feature

		// Add theme support for Translation
		load_theme_textdomain('appmojo', get_template_directory().'/languages');

		// Add theme support for Post Formats
		$formats = array(
			'status',
			'quote',
			'gallery',
			'image',
			'video',
			'audio',
			'link',
			'aside',
			'chat'
		);
		add_theme_support('post-formats', $formats);
		// END of Post Formats

		// Add theme support for custom CSS in the TinyMCE visual editor
		add_editor_style('css/editor-style.css');
		
		// Add theme support for title tag, WP can Manage
		add_theme_support( 'title-tag' );

		// Add theme support for Automatic Feed Links
		add_theme_support('automatic-feed-links');
		// END of Automatic Feed Links

		// Add theme support for Featured Images
		add_theme_support('post-thumbnails');
		
		// END of Featured Images option
		add_image_size( 'blog-onecol', 1170, 529, true );
		add_image_size( 'blog-onecol-sidebar', 770, 349, true );
		add_image_size( 'blog-twocol', 575, 261, true );
		add_image_size( 'blog-twocol-sidebar', 420, 190, true );
		add_image_size( 'blog-threecol', 420, 190, true );
		add_image_size( 'blog-threecol-sidebar', 420, 190, true );
		
		//Portfolio Image Sizes
		add_image_size('portfolio-onecol', 1170, 585, true);
		add_image_size('portfolio-onecol-sidebar', 760, 380, true);
		add_image_size('portfolio-twocol', 460, 345, true);
		add_image_size('portfolio-twocol-sidebar', 420, 315, true);
		add_image_size('portfolio-threecol', 420, 315, true);
		add_image_size('portfolio-threecol-sidebar', 420, 315, true);
		add_image_size('portfolio-fourcol', 420, 315, true);
		add_image_size('portfolio-fourcol-sidebar', 420, 315, true);
		
		add_image_size('sidebar-thumb', 60, 60, true);

		add_image_size('portfolio-single', 760, 380, true);
		add_image_size('portfolio-single-full', 1170, 585, true);
	}
	// Hook into the 'after_setup_theme' action
	add_action('after_setup_theme', 'dt_theme_features');

}

if (!function_exists('dt_theme_navigation_menus')) {

	// Register Navigation Menus
	function dt_theme_navigation_menus() {
		$locations = array(
			'header_menu' => __('Custom Header Menu', 'appmojo')		
		);
		register_nav_menus($locations);
	}

	// Hook into the 'init' action
	add_action('init', 'dt_theme_navigation_menus');
}