<?php
add_action('admin_init', 'mytheme_admin_options_init', 1);
add_action('admin_print_styles', 'my_admin_panel_styles');
add_action('admin_enqueue_scripts', 'my_admin_panel_scripts');

##Admin panel media uploader hooks( to alter the media uploder used to upload logo , favicon ... )
if (isset($_GET['mytheme_upload_button']) || isset($_POST['mytheme_upload_button']) && (isset($_GET['page']) && $_GET['page'] == 'parent')) :
	add_action('admin_init', 'mytheme_image_upload_option');
endif;
## End hook
if(! function_exists('my_admin_panel_styles')){
function my_admin_panel_styles() {
	global $wp_version;

	wp_enqueue_style('thickbox');

	if (version_compare($wp_version, '3.5', '>=')) :
		wp_enqueue_script('wp-color-picker'); #New Color Picker
	else :
		wp_enqueue_script('farbtastic'); #Color picker
	endif;

	wp_enqueue_style('my-adminpanel', IAMD_FW_URL.'theme_options/style.css');
}
}

if(! function_exists('my_admin_panel_scripts')){
function my_admin_panel_scripts() {
	global $wp_version;

	echo "<script type=\"text/javascript\">
	//<![CDATA[
	var mysiteWpVersion = '$wp_version';
	//]]>\r</script>\r";

	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	wp_enqueue_script('jquery-ui-tabs');
	wp_enqueue_script('jquery-ui-sortable');
	wp_enqueue_script('jquery-ui-slider');

	if (version_compare($wp_version, '3.5', '>=')) :
		wp_enqueue_style('wp-color-picker'); #New Color Picker
	else :
		wp_enqueue_style('farbtastic'); #Color Picker
	endif;

	wp_enqueue_script('mytheme-tooltip', IAMD_FW_URL.'js/admin/jquery.tools.min.js');
	wp_enqueue_script('mytheme', IAMD_FW_URL.'js/admin/mytheme.admin.js');
	wp_enqueue_media();

	wp_localize_script('mytheme', 'objectL10n', array(
		'saveall' => __('Save All','appmojo'),
		'saving' => __('Saving ...','appmojo'),
		'resetConfirm' => __('This will restore all of your options to default. Are you sure?', 'appmojo'),
		'importConfirm' => __('You are going to import the dummy data provided with the theme, kindly confirm?', 'appmojo'),
		'disableImportMsg' => __('Importing is disabled.. :), Please check your importer option is correct.', 'appmojo'),
		'backupMsg' => __('Click OK to backup your current saved options.', 'appmojo'),
		'backupSuccess' => __('Your options are backuped successfully', 'appmojo'),
		'backupFailure' => __('Backup Process not working', 'appmojo'),
		'restoreMsg' => __('Warning: All of your current options will be replaced with the data from your last backup! Proceed?', 'appmojo'),
		'restoreSuccess' => __('Your options are restored from previous backup successfully', 'appmojo'),
		'restoreFailure' => __('Restore Process not working', 'appmojo'),
		'importMsg' => __('Click ok import options from the above textarea', 'appmojo'),
		'importSuccess' => __('Your options are imported successfully', 'appmojo'),
		'pageBuilderUpdate' => __('You page and post contents are updated successfully for page builder latest version!', 'appmojo'),
		'pageBuilderUpdateAlready' => __('Page builder updates are implemented already to your page and post contents!', 'appmojo'),
		'importFailure' => __('Import Process not working', 'appmojo')));
}
}

if(! function_exists('mytheme_admin_options_init')){
function mytheme_admin_options_init() {
	register_setting(IAMD_THEME_SETTINGS, IAMD_THEME_SETTINGS);
	add_option(IAMD_THEME_SETTINGS, mytheme_default_option());
	if (isset($_POST['mytheme-option-save'])) :
		mysite_ajax_option_save();
	endif;
	
	if (isset($_POST['mytheme']['reset'])) :
		delete_option(IAMD_THEME_SETTINGS);
		update_option(IAMD_THEME_SETTINGS, mytheme_default_option()); # To set Default options
		wp_redirect(admin_url('admin.php?page=parent&reset=true'));
		exit;
	endif;
}
}

if(! function_exists('mysite_ajax_option_save')){
function mysite_ajax_option_save() {
	check_ajax_referer(IAMD_THEME_SETTINGS.'_wpnonce', 'mytheme_admin_wpnonce');
	$data = $_POST;
	unset($data['_wp_http_referer'], $data['_wpnonce'], $data['action']);
	unset($data['mytheme_admin_wpnonce'], $data['mytheme-option-save'], $data['option_page']);

	$msg = array('success' => false, 'message' => __('Error: Options not saved, please try again.', 'appmojo'));

	$data = array_filter($data[IAMD_THEME_SETTINGS]);

	if (get_option(IAMD_THEME_SETTINGS) != $data) {
		if (update_option(IAMD_THEME_SETTINGS, $data))
			$msg = array('success' => 'options_saved', 'message' => __('Options Saved.', 'appmojo'));
	} else {
		$msg = array('success' => true, 'message' => __('Options Saved.', 'appmojo'));
	}

	$echo = json_encode($msg);
	@header('Content-Type: application/json; charset='.get_option('blog_charset'));
	echo $echo;
	exit;
}
}

add_action('admin_head-toplevel_page_parent', 'mytheme_admin_print_scripts');
if(! function_exists('mytheme_admin_print_scripts')){
function mytheme_admin_print_scripts() {
	echo "<script type=\"text/javascript\">
	//<![CDATA[
	jQuery(document).ready(function(){
		mythemeAdmin.menuSort();
	});
	//]]>\r</script>\r";
}
}

if(! function_exists('custom_login_logo')){
function custom_login_logo() {
	$logo = mytheme_option('advance', 'admin-login-logo-url');

	if ("true" == mytheme_option('advance', 'enable-admin-login-logo-url')) :
		if (!empty($logo))
			echo '<style type="text/css">  div#login h1 a { background-image:url('.$logo.')} </style>';
	endif;
}
}
add_action('login_head', 'custom_login_logo');


if(! function_exists('custom_logo')){
function custom_logo() {
	$logo = mytheme_option('advance', 'admin-logo-url');

	if ("true" == mytheme_option('advance', 'enable-admin-logo-url')) :
		if (!empty($logo))
			echo '<style type="text/css"> #wp-admin-bar-wp-logo .ab-icon { background-image: url('.$logo.') !important;  background-position:0px !important;}</style>';
	endif;

}
}
add_action('admin_head', 'custom_logo');

#Ajax Import functionality
add_action('wp_ajax_mytheme_ajax_importer', 'mytheme_ajax_importer');
if(! function_exists('mytheme_ajax_importer')){
function mytheme_ajax_importer() {
	require_once IAMD_CORE_PLUGIN . '/importer/import.php';
}
}
#Ajax Import functionality end

######### SAMPLE FONT PREVIEW ##########
add_action('wp_ajax_mytheme_font_url', 'mytheme_font_url');
if(! function_exists('mytheme_font_url')){
function mytheme_font_url() {
	$recieve_font = $_POST['font'];
	$font_url = array('url' => 'http'.mytheme_ssl().'://fonts.googleapis.com/css?family='.str_replace(' ', '+', $recieve_font));
	die(json_encode($font_url));
}
}

#### BACKUP OPTION #####
add_action('wp_ajax_mytheme_backup_and_restore_action', 'mytheme_backup_and_restore_action');
if(! function_exists('mytheme_backup_and_restore_action')){
function mytheme_backup_and_restore_action() {

	$save_type = $_POST['type'];

	if ($save_type == 'backup_options') :
		$data = array('general' => mytheme_option('general'),
			'appearance' => mytheme_option('appearance'),
			'integration' => mytheme_option('integration'),
			'seo' => mytheme_option('seo'),
			'specialty' => mytheme_option('specialty'),
			'widgetarea' => mytheme_option("widgetarea"),
			'mobile' => mytheme_option('mobile'),
			'advance' => mytheme_option('advance'),
			'bbar' => mytheme_option('bbar'),
			'backup' => date('r'));
		update_option("mytheme_backup", $data);
		die('1');
	elseif ($save_type == 'restore_options') :
		$data = get_option("mytheme_backup");
		update_option(IAMD_THEME_SETTINGS, $data);
		die('1');
	elseif ($save_type == "import_options") :
		$data = $_POST['data'];
		$data = unserialize($data); //100% safe - ignore theme check nag
		update_option(IAMD_THEME_SETTINGS, $data);
		die('1');
	elseif( $save_type == "reset_options") :
		delete_option(IAMD_THEME_SETTINGS);
		update_option(IAMD_THEME_SETTINGS, mytheme_default_option()); # To set Default options
		die('1');
	endif;
}
}
?>