jQuery(document).ready(function ($) {

    "use strict";
    //CUSTOM SCROLL...
    if (typeof mytheme_urls !== 'undefined') {
        if (mytheme_urls.scroll == "enable" && $(window).width() > 767 && ! navigator.userAgent.match(/(Android|iPod|iPhone|iPad|IEMobile|Opera Mini)/) && ! navigator.platform.match(/(Mac|iPhone|iPod|iPad)/i)) {
            $("html").niceScroll({
                zindex: 999999,
				cursorborder: "1px solid #424242"
            });
        }
    }

    //ONE PAGE NAV...
    $('#main-menu').onePageNav({
        currentClass: 'current-menu-item',
        filter: ':not(.external)',
        scrollSpeed: 750,
		scrollOffset: 90,
        scrollChange: fixMagicline
    });

    //MINI MOBILE MENU...
    $('nav#main-menu').meanmenu({
        meanMenuContainer: $('header #menu-container'),
        meanRevealPosition: 'left',
        meanScreenWidth: 797,
        meanMenuClose: "<span /><span /><span />"
    });

	//SUB MENU...
	$("#main-menu ul li:has(ul)").each(function(){
		$(this).addClass("hasSubmenu");
	});
	
	//MAIN MENU ANIMATION...	
	$("#main-menu ul:first li").hover(function(){
		$(this).find('ul:first').stop().fadeIn('slow');
	  },function(){
		$(this).find('ul:first').stop().fadeOut('fast');
	});		
	
	//SELECT...
	$("select").each(function(){
		if($(this).css('display') != 'none') {
			$(this).wrap( '<div class="selection-box"></div>' );
		}
	});
	
    //TESTIMONIAL QUOTE...
    $('.quotes_wrapper').quovolver({
        children: 'li',
        transitionSpeed: 600,
        autoPlay: true,
        equalHeight: true,
        navPosition: 'below',
        navPrev: false,
        navNext: false,
        navNum: true
    });

    //ISOTOPE CATEGORY...
    var $container = $('.portfolio-container');
    var $gw;

	$(window).load(function(){
		//GALLERY ISOTOPE...
		if ($('.portfolio-container .portfolio').hasClass('with-sidebar')) {
			if ($(".container").width() == 710 && ($('.portfolio-container .portfolio').hasClass('dt-sc-one-half') || $('.portfolio-container .portfolio').hasClass('dt-sc-one-fourth'))) {
				$gw = 10;
			} else {
				$gw = 14.5;
			}
		} else {
			if (($(".container").width() == 710 || $(".container").width() == 900) && ($('.portfolio-container .portfolio').hasClass('dt-sc-one-half') || $('.portfolio-container .portfolio').hasClass('dt-sc-one-fourth'))) {
				$gw = 15;
			} else {
				$gw = 20;
			}
		}
	
		$('.sorting-container a').click(function () {
			$('.sorting-container').find('a').removeClass('active-sort');
			$(this).addClass('active-sort');
	
			var selector = $(this).attr('data-filter');
			$container.isotope({
				filter: selector,
				animationOptions: {
					duration: 750,
					easing: 'linear',
					queue: false
				},
				masonry: {
					columnWidth: $('.portfolio-container .portfolio').width(),
					gutterWidth: $gw
				}
			});
			return false;
		});
	});
	
	$(window).load(function(){
		//ISOTOPE...
		if ($container.length) {
			$container.isotope({
				filter: '*',
				animationOptions: {
					duration: 750,
					easing: 'linear',
					queue: false
				},
				masonry: {
					columnWidth: $('.portfolio-container .portfolio').width(),
					gutterWidth: $gw
				}
			});
		}
	});			

    //UITOTOP...
    $().UItoTop({
        easingType: 'easeOutQuart'
    });

    //PrettyPhoto...	
    var $pphoto = $('a[data-gal^="prettyPhoto[gallery]"]');
    if ($pphoto.length) {
        //PRETTYPHOTO...
        $("a[data-gal^='prettyPhoto[gallery]']").prettyPhoto({
			hook:'data-gal',
            show_title: false,
            social_tools: false,
            deeplinking: false
        });
    }

    //MODERNIZER PLACE HOLDER...
    if (typeof Modernizr !== 'undefined') {
        if (!Modernizr.input.placeholder) {

            $('[placeholder]').focus(function () {
                var input = $(this);
                if (input.val() == input.attr('placeholder')) {
                    input.val('');
                    input.removeClass('placeholder');
                }
            }).blur(function () {
                var input = $(this);
                if (input.val() === '' || input.val() === input.attr('placeholder')) {
                    input.addClass('placeholder');
                    input.val(input.attr('placeholder'));
                }
            }).blur();

            $('[placeholder]').parents('form').submit(function () {
                $(this).find('[placeholder]').each(function () {
                    var input = $(this);
                    if (input.val() == input.attr('placeholder')) {
                        input.val('');
                    }
                });
            });
        }
    }

    $('form[name="frmNewsletter"]').validate({
        rules: {
            mc_email: {
                required: true,
                email: true
            }
        },
        errorPlacement: function (error, element) {}
    });
	
	//NEWSLETTER AJAX SUBMIT...
	$('form[name="frmNewsletter"]').on('submit', function () {
		
		var $this = $(this); 
		var $mc_email = $this.find('#dt_mc_emailid').val(),
			$mc_apikey = $this.find('#dt_mc_apikey').val(),
			$mc_listid = $this.find('#dt_mc_listid').val();

		$.ajax({
			type: "POST",
			url: mytheme_urls.ajaxurl,
			data:
			{
				action: 'mytheme_mailchimp_subscribe',
				mc_email: $mc_email,
				mc_apikey: $mc_apikey,
				mc_listid: $mc_listid
			},
			success: function (response) {
				$this.parent().find('#ajax_newsletter_msg').html(response);
				$this.parent().find('#ajax_newsletter_msg').slideDown('slow');
				if (response.match('success') != null) $this.slideUp('slow');
			}
		});
		
		return false;
		
    });

    //CONTACT BOX VALIDATION & MAIL SENDING....
    $('form[name="frmcontact"]').submit(function () {

        var This = $(this);

        if ($(This).valid()) {
            var action = $(This).attr('action');

            var data_value = decodeURI($(This).serialize());
            $.ajax({
                type: "POST",
                url: action,
                data: data_value,
                error: function (xhr, status, error) {
                    confirm('The page save failed.');
                },
                success: function (response) {
                    $('#ajax_contact_msg').html(response);
                    $('#ajax_contact_msg').slideDown('slow');
                    if (response.match('success') !== null) $(This).slideUp('slow');
                }
            });
        }
        return false;
    });
    $('form[name="frmcontact"]').validate({
        rules: {
            txtname: {
                required: true
            },
            txtemail: {
                required: true,
                email: true
            },
			txtcap: { 
				required: true, 
				minlength: 4,
				equalTo: "#txthidcap"
			}
        },
        errorPlacement: function (error, element) {}
    });


$(window).load(function(){
    //PORTFOLIO CarouFredSel...
    if ($('.portfolio-slider').length) {
        $('.portfolio-slider').carouFredSel({
            responsive: true,
            width: '100%',
            scroll: {
                fx: "crossfade"
            },
            prev: '.portfolio-arrows .prev',
            next: '.portfolio-arrows .next',
            auto: false,
            items: 1
        });
    }
 });
 
    //GOOGLE MAP...
    if ($('.gmap').length) {
        $('.gmap').each(function () {
            var $addr = $(this).attr('data-add');
			var $zoom = $(this).attr('data-zoom');
            var $api = $(this).attr('data-api');
            $(this).gMap({
                address: $addr,
                zoom: parseInt($zoom),
                markers: [{
                    'address': $addr,
					'html': $addr,
					'popup': true
                }]

            });
           
        });
    }
	
    //Fitvids...
	$("div.dt-video-wrap").fitVids();
	
	//Gallery Blog Slider...
    if( ($("ul.entry-gallery-post-slider").length) && ( $("ul.entry-gallery-post-slider li").length > 1 ) ){
     $("ul.entry-gallery-post-slider").bxSlider({auto:false, video:true, useCSS:false, pager:'', autoHover:true, adaptiveHeight:true});
    }

	//Donut Char...
	$('.donutChart').each(function(){
		$(this).one('inview', function (event, visible) {
			if(visible === true) {
				var bgcolor, fgcolor = "";

				if($(this).attr('data-bgcolor') !== "") bgcolor = $(this).attr('data-bgcolor'); else bgcolor = '#f5f5f5';
				if($(this).attr('data-fgcolor') !== "") fgcolor = $(this).attr('data-fgcolor'); else fgcolor = '#E74D3C';

				$(this).donutchart({'size': 140, 'donutwidth': 10, 'fgColor': fgcolor, 'bgColor': bgcolor, 'textsize': 15 });
				$(this).donutchart('animate');
			}
		});
	});
});

//CUSTOM FIX...
function fixMagicline() {
    "use strict";
    var $magicLine = jQuery("#magic-line");

    var leftPos, newWidth;

    leftPos = jQuery(".current-menu-item a").position().left;
    newWidth = jQuery(".current-menu-item").width();

    $magicLine.stop().animate({
        left: leftPos,
        width: newWidth
    });
}

// animate css + jquery inview configuration
(function ($) {
    "use strict";
    $(".animate").each(function () {
        $(this).bind('inview', function (event, visible) {
            var $delay = "";
            var $this = $(this),
                $animation = ($this.data("animation") !== undefined) ? $this.data("animation") : "slideUp";
            $delay = ($this.data("delay") !== undefined) ? $this.data("delay") : 300;

            if (visible === true) {
                setTimeout(function () {
                    $this.addClass($animation);
                }, $delay);
            } else {
                setTimeout(function () {
                    $this.removeClass($animation);
                }, $delay);
            }
        });
    });

})(jQuery);

function funtoScroll(x, e) {
    "use strict";
	var et = String(e.target);
	var pos = et.indexOf('#');
    var t = et.substr(pos);
	
	if(jQuery('#main-menu .group li.current-menu-item a').hasClass('external')) {
		window.location.href = et;
	}
	else {
	    jQuery.scrollTo(t, 750);
		
		jQuery(x).parent('.mean-bar').next('.mean-push').remove();
		jQuery(x).parent('.mean-bar').remove();
	
		jQuery('nav#main-menu').meanmenu({
			meanMenuContainer: jQuery('header #menu-container'),
			meanRevealPosition: 'left',
			meanScreenWidth: 767,
			meanMenuClose: "<span /><span /><span />"
		});		
	}

    e.preventDefault();
}