<?php

function meta()
{
    return app(App\Services\MetaDataService::class);
}

function carbon($time = null, $tz = null)
{
    return new \Carbon\Carbon($time, $tz);
}

function flash($message, $type = 'info')
{
    if ($type == 'error') {
        $type = 'danger';
    }

    if (!in_array($type, ['success', 'info', 'warning', 'danger'])) {
        $type = 'info';
    }

    app('session')->flash('flash_message', [
        'type'    => $type,
        'message' => $message,
    ]);
}

/**
 * Get IP Address, checks for cloudflare headers.
 *
 * @return string
 */
function get_ip()
{
    if (getenv('HTTP_CF_CONNECTING_IP') && is_valid_ip(getenv('HTTP_CF_CONNECTING_IP'))) {
        return getenv('HTTP_CF_CONNECTING_IP');
    }

    return request()->getClientIp();
}

/**
 * Validate IP Address.
 *
 * @param string $ip IP address
 * @param string $which IP protocol: 'ipv4' or 'ipv6'
 *
 * @return bool
 */
function is_valid_ip($ip, $which = 'ipv4')
{
    if ($ip == '0.0.0.0' || $ip == '127.0.0.1') {
        return false;
    }
    switch (strtolower($which)) {
        case 'ipv4':
            $which = FILTER_FLAG_IPV4;
            break;
        case 'ipv6':
            $which = FILTER_FLAG_IPV6;
            break;
        default:
            $which = null;
            break;
    }

    return (bool)filter_var($ip, FILTER_VALIDATE_IP, $which);
}

/**
 * Validate IPv4 Address (Check if it is a public IP).
 *
 * @param string $ip IP address
 *
 * @return bool
 */
function is_public_ip($ip)
{
    if (!is_valid_ip($ip)) {
        return false;
    }

    return (bool)filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE);
}

function is_valid_url($url)
{
    if (empty($url)) {
        return false;
    }

    $url = urldecode($url);

    // Weird Bug, Laravel fails to validate Decoded URL with space in it.
    $url = str_replace(' ', '%20', $url);

    $valid = app('validator')->make(['url' => $url], [
        'url' => 'url'
    ]);

    return $valid->passes();
}

function excluded_words()
{
    return [
        'abroad',
        'accept',
        'access',
        'across',
        'acting',
        'action',
        'active',
        'actual',
        'advice',
        'advise',
        'affect',
        'afford',
        'afraid',
        'agency',
        'agenda',
        'almost',
        'always',
        'amount',
        'animal',
        'annual',
        'answer',
        'anyone',
        'anyway',
        'appeal',
        'appear',
        'around',
        'arrive',
        'artist',
        'aspect',
        'assess',
        'assist',
        'assume',
        'attack',
        'attend',
        'august',
        'author',
        'avenue',
        'backed',
        'barely',
        'battle',
        'beauty',
        'became',
        'become',
        'before',
        'behalf',
        'behind',
        'belief',
        'belong',
        'berlin',
        'better',
        'beyond',
        'bishop',
        'border',
        'bottle',
        'bottom',
        'bought',
        'branch',
        'breath',
        'bridge',
        'bright',
        'broken',
        'budget',
        'burden',
        'bureau',
        'button',
        'camera',
        'cancer',
        'cannot',
        'carbon',
        'career',
        'castle',
        'casual',
        'caught',
        'center',
        'centre',
        'chance',
        'change',
        'charge',
        'choice',
        'choose',
        'chosen',
        'church',
        'circle',
        'client',
        'closed',
        'closer',
        'coffee',
        'column',
        'combat',
        'coming',
        'common',
        'comply',
        'copper',
        'corner',
        'costly',
        'county',
        'couple',
        'course',
        'covers',
        'create',
        'credit',
        'crisis',
        'custom',
        'damage',
        'danger',
        'dealer',
        'debate',
        'decade',
        'decide',
        'defeat',
        'defend',
        'define',
        'degree',
        'demand',
        'depend',
        'deputy',
        'desert',
        'design',
        'desire',
        'detail',
        'detect',
        'device',
        'differ',
        'dinner',
        'direct',
        'doctor',
        'dollar',
        'domain',
        'double',
        'driven',
        'driver',
        'during',
        'easily',
        'eating',
        'editor',
        'effect',
        'effort',
        'eighth',
        'either',
        'eleven',
        'emerge',
        'empire',
        'employ',
        'enable',
        'ending',
        'energy',
        'engage',
        'engine',
        'enough',
        'ensure',
        'entire',
        'entity',
        'equity',
        'escape',
        'estate',
        'ethnic',
        'exceed',
        'except',
        'excess',
        'expand',
        'expect',
        'expert',
        'export',
        'extend',
        'extent',
        'fabric',
        'facing',
        'factor',
        'failed',
        'fairly',
        'fallen',
        'family',
        'famous',
        'father',
        'fellow',
        'female',
        'figure',
        'filing',
        'finger',
        'finish',
        'fiscal',
        'flight',
        'flying',
        'follow',
        'forced',
        'forest',
        'forget',
        'formal',
        'format',
        'former',
        'foster',
        'fought',
        'fourth',
        'French',
        'friend',
        'future',
        'garden',
        'gather',
        'gender',
        'german',
        'global',
        'golden',
        'ground',
        'growth',
        'guilty',
        'handed',
        'handle',
        'happen',
        'hardly',
        'headed',
        'health',
        'height',
        'hidden',
        'holder',
        'honest',
        'impact',
        'import',
        'income',
        'indeed',
        'injury',
        'inside',
        'intend',
        'intent',
        'invest',
        'island',
        'itself',
        'jersey',
        'joseph',
        'junior',
        'killed',
        'labour',
        'latest',
        'latter',
        'launch',
        'lawyer',
        'leader',
        'league',
        'leaves',
        'legacy',
        'length',
        'lesson',
        'letter',
        'lights',
        'likely',
        'linked',
        'liquid',
        'listen',
        'little',
        'living',
        'losing',
        'lucent',
        'luxury',
        'mainly',
        'making',
        'manage',
        'manner',
        'manual',
        'margin',
        'marine',
        'marked',
        'market',
        'martin',
        'master',
        'matter',
        'mature',
        'medium',
        'member',
        'memory',
        'mental',
        'merely',
        'merger',
        'method',
        'middle',
        'miller',
        'mining',
        'minute',
        'mirror',
        'mobile',
        'modern',
        'modest',
        'module',
        'moment',
        'morris',
        'mostly',
        'mother',
        'motion',
        'moving',
        'murder',
        'museum',
        'mutual',
        'myself',
        'narrow',
        'nation',
        'native',
        'nature',
        'nearby',
        'nearly',
        'nights',
        'nobody',
        'normal',
        'notice',
        'notion',
        'number',
        'object',
        'obtain',
        'office',
        'offset',
        'online',
        'option',
        'orange',
        'origin',
        'output',
        'oxford',
        'packed',
        'palace',
        'parent',
        'partly',
        'patent',
        'people',
        'period',
        'permit',
        'person',
        'phrase',
        'picked',
        'planet',
        'player',
        'please',
        'plenty',
        'pocket',
        'police',
        'policy',
        'prefer',
        'pretty',
        'prince',
        'prison',
        'profit',
        'proper',
        'proven',
        'public',
        'pursue',
        'raised',
        'random',
        'rarely',
        'rather',
        'rating',
        'reader',
        'really',
        'reason',
        'recall',
        'recent',
        'record',
        'reduce',
        'reform',
        'regard',
        'regime',
        'region',
        'relate',
        'relief',
        'remain',
        'remote',
        'remove',
        'repair',
        'repeat',
        'replay',
        'report',
        'rescue',
        'resort',
        'result',
        'retail',
        'retain',
        'return',
        'reveal',
        'review',
        'reward',
        'riding',
        'rising',
        'robust',
        'ruling',
        'safety',
        'salary',
        'sample',
        'saving',
        'saying',
        'scheme',
        'school',
        'screen',
        'search',
        'season',
        'second',
        'secret',
        'sector',
        'secure',
        'seeing',
        'select',
        'seller',
        'senior',
        'series',
        'server',
        'settle',
        'severe',
        'sexual',
        'should',
        'signal',
        'signed',
        'silent',
        'silver',
        'simple',
        'simply',
        'single',
        'sister',
        'slight',
        'smooth',
        'social',
        'solely',
        'sought',
        'source',
        'soviet',
        'speech',
        'spirit',
        'spoken',
        'spread',
        'spring',
        'square',
        'stable',
        'status',
        'steady',
        'stolen',
        'strain',
        'stream',
        'street',
        'stress',
        'strict',
        'strike',
        'string',
        'strong',
        'struck',
        'studio',
        'submit',
        'sudden',
        'suffer',
        'summer',
        'summit',
        'supply',
        'surely',
        'survey',
        'switch',
        'symbol',
        'system',
        'taking',
        'talent',
        'target',
        'taught',
        'tenant',
        'tender',
        'tennis',
        'thanks',
        'theory',
        'thirty',
        'though',
        'threat',
        'thrown',
        'ticket',
        'timely',
        'timing',
        'tissue',
        'toward',
        'travel',
        'treaty',
        'trying',
        'twelve',
        'twenty',
        'unable',
        'unique',
        'united',
        'unless',
        'unlike',
        'update',
        'useful',
        'valley',
        'varied',
        'vendor',
        'versus',
        'victim',
        'vision',
        'visual',
        'volume',
        'walker',
        'wealth',
        'weekly',
        'weight',
        'wholly',
        'window',
        'winner',
        'winter',
        'within',
        'wonder',
        'worker',
        'wright',
        'writer',
        'yellow',
    ];
}
