jQuery( document ).ready( function( $ ) {
	$( 'body' ).on( 'click', '.agc_select', function() {
		var wrap = $( this ).closest( '.agc_select_wrap' );
		if( !wrap.find( '.agc_options' ).hasClass( 'agc_active' ) ) {
			$( '.agc_options' ).removeClass( 'agc_active' );
			wrap.find( '.agc_options' ).addClass( 'agc_active' );
			wrap.find( '.agc_options' ).find( 'li:contains("' + wrap.find( '.agc_select_val' ).html() + '")' ).addClass( 'agc_active' );
		}
		else {
			wrap.find( '.agc_options' ).removeClass( 'agc_active' );
		}
	});
	
	$( 'body' ).on( 'click', '.agc_options ul li', function() {
		var wrap = $( this ).closest( '.agc_select_wrap' );
		wrap.find( '.agc_select_val' ).html( $( this ).html() );
		wrap.find( 'select' ).val( $( this ).attr( 'data-val' ) );
		wrap.find( '.agc_options' ).removeClass( 'agc_active' );
	});
	
	$( 'body' ).on( 'mouseover', '.agc_options ul li', function() {
		if ( $( '.agc_options ul li' ).hasClass( 'agc_active' ) ) {
			$( '.agc_options ul li' ).removeClass( 'agc_active' );
		}
	});
	
	$( document ).click( function(e) {
		if( $( e.target ).attr( 'class' ) != 'agc_select' && !$( '.agc_select' ).find( $( e.target ) ).length ) {
			if( $( '.agc_options.agc_active' ).length ) {
				$( '.agc_options' ).removeClass( 'agc_active' );
			}
		}
	});

	$( 'body' ).on( 'submit', '#agc_verify_form', function(event) {
		event.preventDefault();
		var form = $( this );
		form.find( '.agc_result' ).remove();
		$.ajax({
			type: "POST",
			url: form.attr( 'data-url' ),
			data: form.serialize(),
			cache: false,
			success: function (result) {
				try {
					result = jQuery.parseJSON( result );
					if ( result['result'] == 'success' ) {
						$( 'html, body' ).removeClass( 'agc_no_scroll' );
						$( '.agc_screen' ).remove();
					}
					else if ( result['result'] == 'validate' ) {
						$( '#agc_verify_submit' ).append( '<div class="agc_result"><span class="agc_icon_exclamation_circle"></span> ' + result['output'] + '</div>' );
					}
					else {
						throw 0;
					}
				}
				catch(err) {
					$( '#agc_verify_submit' ).append( '<div class="agc_result"><span class="agc_icon_exclamation_circle"></span> Failed, please try again.</div>' );
				}
			}
		});
	});
	
});