jQuery( document ).ready( function( $ ) {
	// Chosen plugin
	$( '.agc_multi_select' ).chosen({width: "100%"});

	// Load in the preview screen
	if( $( '#agc_preview' ).length ) {
		$.ajax({
			url: agc.url + 'inc/verify_template.php?agc_preview_dashboard',
			dataType: 'html',
			cache: false,
			success: function (result) {
				$( '#agc_preview' ).html( result );
			}
		});	
	}
	// Jquery UI
	$( '.agc_slider' ).each(function() {
		var handle = $( this ).find( '.agc_slider_handle' );
		var input = $( this ).find( '.agc_slider_input' );

		$( this ).slider({
			step: 0.05,
			min: 0,
			max: 1,
			value: input.val(),
		      	create: function() {
		      		handle.text( input.val() );
		      	},
		      	slide: function( event, ui ) {
		        	handle.text( ui.value );
				input.val( ui.value );
		      	}
		});
	});

	$( '[data-agc-fields-toggle]' ).change(function() {
		var attr = 'data-' + $( this ).attr( 'name' ).replace( '_', '-' );
		$( '[' + attr + ']' ).addClass( 'agc_hidden' );
		$( '[' + attr + '="' + $( this ).val() + '"]' ).removeClass( 'agc_hidden' );
	});

	$( '.agc_palette' ).click(function() {
		$( '.agc_palette' ).removeClass( 'agc_active' );
		$( this ).addClass( 'agc_active' ).find( '[name="agc_background_color"]' ).prop( 'checked', true );
	});
	
	$( '.agc_palette_custom' ).spectrum( { preferredFormat: 'hex', showInput: true, color: $( '.agc_palette_custom' ).find( '[name="agc_background_color"]' ).val(), hide: function( color ) { var hex = color.toHexString(); $( '.agc_palette_custom' ).find( '.agc_color' ).css( 'background-color', hex ); $( '.agc_palette_custom' ).find( '[name="agc_background_color"]' ).val( hex ); } } );

	$( '.agc_accordion_toggle' ).click(function() {

	      // Expand or collapse this panel
	      $( this ).toggleClass( 'agc_active' ).next().slideToggle( 'fast' );

	      // Remove other active toggles
	      $( '.agc_accordion_toggle' ).not( $( this ) ).removeClass( 'agc_active' );

	      // Hide other content
	      $( '.agc_accordion_content' ).not( $( this ).next() ).slideUp( 'fast' );

	});

	$( '.agc_tab_radio input[type=radio]' ).change(function() {
		var target = $( this ).attr( 'data-target' );
		$( target ).closest( '.agc_tab_content' ).find( '.agc_tab_pane' ).removeClass( 'agc_active' );
		$( target ).addClass( 'agc_active' );
	});

	$( '#agc_editor_toggle' ).click(function() {
		$( '#agc_editor' ).toggleClass( 'agc_active' );
		if( $( this ).hasClass( 'agc_active' ) ) {
			$( this ).removeClass( 'agc_active' );
			$( this ).html( "<span class='agc_icon_bars'></span>" );
		}
		else {
			$( this ).addClass( 'agc_active' );
			$( this ).html( "<span class='agc_icon_close'></span>" );
		}
	});

	/*
	 * Wordpress upload/remove file
	 */

	$( '.agc_file_add, .agc_file_remove' ).on( 'click', function(e){
		e.preventDefault();

		var agc_frame;
		var agc_setting = $( this ).closest( '.agc_setting' );
		var agc_file_none = agc_setting.find( '.agc_file_none' );
		var agc_file_preview = agc_setting.find( '.agc_file_preview' );
		var agc_file_thumb = agc_setting.find( '.agc_file_thumb' );
		var agc_file_name = agc_setting.find( '.agc_file_name' );
		var agc_file_id = agc_setting.find( '.agc_file_id' );

		if( $( this ).hasClass( 'agc_file_add' ) ) {
			// If the media frame already exists, reopen it.
			if( agc_frame ) {
				agc_frame.open();
				return;
			}

			var agc_type = $( this ).attr( 'data-type' );

			agc_frame = wp.media({
				title: 'Insert ' + agc_type,
				library : {
					// next line for attaching image to the current post
					// uploadedTo : wp.media.view.settings.post.id,
					type : agc_type
				},
				button: {
					text: 'Use this ' + agc_type // button label text
				},
				multiple: false // for multiple image selection set to true
			})

			// When an image is selected in the media frame
			agc_frame.on( 'select', function() {

				// Get media attachment details from the frame state
				var attachment = agc_frame.state().get( 'selection' ).first().toJSON();

				// Send the attachment URL to thumbnail
				if( agc_type == 'image' ) {
					agc_file_thumb.html( '<img src="' + attachment.url + '"/>' ); 
				}

				// Send the attachment filename
				agc_file_name.html( attachment.filename );

				// Send the attachment id to hidden input
				agc_file_id.val( attachment.id );

				// Hide the no file section
				agc_file_none.addClass( 'hidden' );

				// Un-hide the preview section
				agc_file_preview.removeClass( 'hidden' );


				/* if set multiple to true, code for getting the image IDs
				var attachments = frame.state().get('selection'),
				    attachment_ids = new Array(),
				    i = 0;
				attachments.each(function(attachment) {
					attachment_ids[i] = attachment['id'];
					console.log( attachment );
					i++;
				});
				*/
			});
			agc_frame.open();
		}
		else {
			// Clear the thumbnail
			agc_file_thumb.html( '' );

			// Clear the attachment filename
			agc_file_name.html( '' );

			// Delete the attachment id
			agc_file_id.val( '' );

			// Hide the preview section
			agc_file_preview.addClass( 'hidden' );

			// Un-hide the no file section
			agc_file_none.removeClass( 'hidden' );

		}
	});

	var agc_timeout;

	$( '#agc_editor_form' ).submit( function(event) {
		event.preventDefault();
		var form = $( this );
		form.find( 'button[type="submit"]' ).attr( 'disabled', 'disabled' );
		form.find( '.agc_spinner' ).addClass( 'agc_active' );
		form.find( '.agc_result' ).remove();
		clearTimeout( agc_timeout );
		$.ajax({
			type: "POST",
			url: form.attr( 'data-url' ),
			data: form.serialize(),
			cache: false,
			success: function (result) {
				$( 'p.agc_validate' ).remove();
				$( '.agc_validate' ).removeClass( 'agc_validate' );
				form.find( 'button[type="submit"]' ).removeAttr( 'disabled' );
				form.find( '.agc_spinner' ).removeClass( 'agc_active' );
				try {
					result = jQuery.parseJSON( result );
					if ( result['result'] == 'success' ) {
						$( '#agc_editor_submit' ).append( '<div class="agc_result agc_result_success"><span class="agc_icon_checkmark"></span> Updated successfully.</div>' );
						$.ajax({
							url: agc.url + 'inc/verify_template.php?agc_preview_dashboard',
							dataType: 'html',
							cache: false,
							success: function (result) {
								$( '#agc_preview' ).html( result );
							}
						});
						agc_timeout = setTimeout( function(){ form.find( '.agc_result_success' ).remove(); }, 3000 );
					}
					else if ( result['result'] == 'validate' ) {
						var validate = JSON.parse( result['output'] );
						var x = 0;
						$.each( validate, function( section, items ) {
							$( '.agc_accordion_toggle:contains("' + section + '")').addClass( 'agc_validate' );
							$.each( items, function( name, text ) {
								$( '[name="' + name + '"]' ).closest( '.agc_setting' ).prepend( '<p class="agc_validate">' + text + '</p>' );
								x++;
							});
						});
						var field = ( x > 1 ) ? 'fields' : 'field';
						$( '#agc_editor_submit' ).append( '<div class="agc_result agc_result_failed"><span class="agc_icon_exclamation_circle"></span> Please correct ' + x + ' ' + field + '.</div>' );
					}
					else {
						throw 0;
					}
				}
				catch(err) {
					$( '#agc_editor_submit' ).append( '<div class="agc_result agc_result_failed"><span class="agc_icon_exclamation_circle"></span> Failed, please try again.</div>' );
				}
			}
		});
	});
});