<?php

// Security
if(!defined("WRAPPER")){ echo "You cannot load a page directly!"; exit; }

$File->SetPath($Server->GetBackupPath());
$files = $File->Listing(array("sql", "small"), array(".htaccess", ".DS_Store"), array("__MACOSX"), false);

// Filter files that not are for this profile
Helper::profileSpecificFilter($files);

$files = array_sort($files, 'filename', SORT_DESC);

// Sort function for the images
function array_sort($array, $on, $order=SORT_ASC)
{
    $new_array = array();
    $sortable_array = array();

    if (count($array) > 0) {
        foreach ($array as $k => $v) {
            if (is_array($v)) {
                foreach ($v as $k2 => $v2) {
                    if ($k2 == $on) {
						$start = strpos($v2, ".");
                        $sortable_array[$k] = substr($v2, $start);
                    }
                }
            } else {
                $sortable_array[$k] = $v;
            }
        }

        switch ($order) {
            case SORT_ASC:
                asort($sortable_array);
            break;
            case SORT_DESC:
                arsort($sortable_array);
            break;
        }

        foreach ($sortable_array as $k => $v) {
            $new_array[$k] = $array[$k];
        }
    }

    return $new_array;
}

?>
<div class="toolblock big">
	<img src="images/archive.png" alt="Archive" />
    <span>create file backups</span>
    <h3>Start creating backup of all the files</h3>
    <a href="#" onclick="doFileBackup();return false;" class="button" id="runButton">Start</a>
    <img src="images/ajaxbig.gif" class="loader" alt="Loading" id="loadImage" style="display:none" />
</div>
<div class="spacer"><!--SPACER--></div>
<div class="successbox" id="success" style="display:none">New backup is created</div>
<div class="warningbox" id="warning" style="display:none">New backup is created</div>
<table width="100%" border="0" cellspacing="0" cellpadding="0" class="base" id="resultTable">
<thead>
  <tr>
  	<th width="5%"><img src="images/package.png" width="16" height="16" alt="database" /></th>
    <th width="25%">Date</th>
    <th width="25%">Time</th>
    <th width="15%">Size</th>
    <th width="10%">Download</th>
    <th width="10%">Delete</th>
    <th width="10%">Rollback</th>
  </tr>
  </thead>
  <tbody>
  <?php foreach($files as $file){  if($file['type'] == "dir") continue;?>
  <tr class="row_<?php echo md5($file['filename']) ?>">
  	<td><img src="images/package.png" width="16" height="16" alt="database" /></td>
    <td><?php echo $Server->GetDatePart($file['filename']) ?></td>
    <td><?php echo $Server->GetTimePart($file['filename']) ?></td>
    <td><?php echo $Server->GetByteFormat($file['size']) ?></td>
    <td align="right">
    	<a href="download.php?file=<?php echo $file['filename']; ?>" class="button">Download</a>
    </td>
  	<td align="right">
    	<a href="#" id="<?php echo md5($file['filename']); ?>_delete_link" onclick="doDelete('<?php echo $file['filename']; ?>', '<?php echo md5($file['filename']); ?>');return false;" class="button">Delete</a>
        <img id="<?php echo md5($file['filename']); ?>_delete_load" class="loader" width="16" height="16" style="display: none;" alt="loader" src="images/ajax.gif"/>
    </td>
    <td align="right">
    	<a href="#" id="<?php echo md5($file['filename']); ?>_rollback_link" onclick="doRollback('<?php echo $file['filename']; ?>', '<?php echo md5($file['filename']); ?>');return false;" class="button">Rollback</a>
    	 <img id="<?php echo md5($file['filename']); ?>_rollback_load" class="loader" width="16" height="16" style="display: none;" alt="loader" src="images/ajax.gif"/>
    </td>
  </td>
  </tr>
  <?php } ?>
  <tr class="norows" <?php if(count($files) != 0) echo 'style="display:none"'; ?>><td colspan="7" class="warningbox">There are no file backups found on the server.</td></tr>
  </tbody>
</table>
