<?php
/*
 * @todo finish ftp
 */

// Security
if(!defined("WRAPPER")){ echo "You cannot load a page directly!"; exit; }

// Construct default locations
$basepath		= str_replace("\\", "/", dirname(__FILE__));
$basepathparts = explode("/", $basepath);
array_pop($basepathparts);
$default_backup_path = implode("/", $basepathparts) . '/backup/';
array_pop($basepathparts);
$default_web_path = implode("/", $basepathparts) . '/';


$charsets = array("armscii8", "ascii", "big5", "binary", "cp1250", "cp1251", "cp1256", "cp1257", "cp850", "cp852", "cp866", "cp932", "dec8", "eucjpms", "euckr", "gb2312", "gbk", "geostd8", "greek", "hebrew", "hp8", "keybcs2", "koi8u", "latin1", "latin2", "latin5", "latin7", "macce", "macroman", "sjis", "swe7", "tis620", "ucs2", "ujis", "utf8");
$saved = false;
if(isset($_POST['btnsave'])){

	$backuppath 	= htmlspecialchars($_POST['txtbackuppath']);
	$webpath 		= htmlspecialchars($_POST['txtwebpath']);
	$host 			= htmlspecialchars($_POST['txthost']);
	$username 		= htmlspecialchars($_POST['txtusername']);
	$password 		= htmlspecialchars($_POST['txtpassword']);
	$name 			= htmlspecialchars($_POST['txtname']);
	$port 			= htmlspecialchars($_POST['txtport']);
	$charset 		= htmlspecialchars($_POST['sltcharset']);
	$dirs 			= htmlspecialchars($_POST['txtdirs']);
	$files 			= htmlspecialchars($_POST['txtfiles']);
	$timezone 		= htmlspecialchars($_POST['txttimezone']);
	$memory 		= htmlspecialchars($_POST['txtmemory']);
	$maxbackups		= htmlspecialchars($_POST['txtmaxbackups']);
	$cleanrollback	= isset($_POST['cleanrollback']) && $_POST['cleanrollback'] == "true" ? true : false;
	$saveftp		= isset($_POST['chkftp']) && $_POST['chkftp'] == "true" ? true : false;
	$savelocal		= isset($_POST['chklocalcopy']) && $_POST['chklocalcopy'] == "true" ? true : false;
	$ftphost		= htmlspecialchars($_POST['txtftphost']);
	$ftpport		= htmlspecialchars($_POST['txtftpport']);
	$ftpusername	= htmlspecialchars($_POST['txtftpusername']);
	$ftppassword	= htmlspecialchars($_POST['txtftppassword']);
	$ftppath		= htmlspecialchars($_POST['txtftppath']);

	// Add trailslash if needed
	Helper::addTrailSlash($backuppath);
	Helper::addTrailSlash($webpath);
	Helper::addTrailSlash($ftppath);
	
$config_content = '<?php 
$config[\'webpath\'] = "' . $webpath . '";
$config[\'backuppath\'] = "' . $backuppath . '";
$config[\'db.host\'] = "' . $host . '";
$config[\'db.username\'] = "' . $username . '";
$config[\'db.password\'] = "' . $password . '";
$config[\'db.name\'] = "' . $name . '";
$config[\'db.port\'] = "' . $port . '";
$config[\'db.charset\'] = "' . $charset . '";
$config[\'exclude.dir\'] = "' . $dirs . '";
$config[\'exclude.file\'] = "' . $files . '";
$config[\'autoarchive\'] = true;
$config[\'timezone\'] = "' . $timezone . '";
$config[\'username\'] = "' . $config['username'] . '";
$config[\'password\'] = "' . $config['password'] . '";
$config[\'memory\'] = "' . $memory . '";
$config[\'maxbackups\'] = "' . $maxbackups . '";
$config[\'cleanrollback\'] = "' . $cleanrollback . '";
$config[\'save.local\'] = "' . $savelocal . '";
$config[\'save.ftp\'] = "' . $saveftp . '";
$config[\'ftp.host\'] = "' . $ftphost . '";
$config[\'ftp.port\'] = "' . $ftpport . '";
$config[\'ftp.username\'] = "' . $ftpusername . '";
$config[\'ftp.password\'] = "' . $ftppassword . '";
$config[\'ftp.path\'] = "' . $ftppath . '";';

	file_put_contents($Server->GetPath() . $_SESSION['config_file'], $config_content);
	$saved = true;
	
}else{
	
	$backuppath		= isset($config['backuppath']) && $config['backuppath'] != '' ? $config['backuppath'] : '';
	$webpath		= isset($config['webpath']) && $config['webpath'] != '' ? $config['webpath'] : '';
	$host 			= isset($config['db.host']) ? $config['db.host'] : "";
	$username 		= isset($config['db.username']) ? $config['db.username'] : "";
	$password 		= isset($config['db.password']) ? $config['db.password'] : "";
	$name 			= isset($config['db.name']) ? $config['db.name'] : "";
	$port 			= isset($config['db.port']) ? $config['db.port'] : "";
	$charset 		= isset($config['db.charset']) ? $config['db.charset'] : "";
	$dirs 			= isset($config['exclude.dir']) ? $config['exclude.dir'] : "";
	$files 			= isset($config['exclude.file']) ? $config['exclude.file'] : "";
	$timezone 		= isset($config['timezone']) ? $config['timezone'] : "";
	$memory 		= isset($config['memory']) ? $config['memory'] : "";
	$maxbackups		= isset($config['maxbackups']) ? $config['maxbackups'] : "";
	$cleanrollback	= isset($config['cleanrollback']) ? $config['cleanrollback'] : "";
	$savelocal		= isset($config['save.local']) ? $config['save.local'] : "";
	$saveftp		= isset($config['save.ftp']) ? $config['save.ftp'] : "";
	$ftphost		= isset($config['ftp.host']) ? $config['ftp.host'] : "";
	$ftpport		= isset($config['ftp.port']) ? $config['ftp.port'] : "";
	$ftpusername	= isset($config['ftp.username']) ? $config['ftp.username'] : "";
	$ftppassword	= isset($config['ftp.password']) ? $config['ftp.password'] : "";
	$ftppath		= isset($config['ftp.path']) ? $config['ftp.path'] : "";
}

// Do ftp test?
if(isset($_GET['action']) && $_GET['action'] == 'ftptest'){
	include("lib/class.ftp.php");
	$ftp = new FtpEasy;
	$ftp->Connect($ftphost, $ftpport);
	if(!$ftp->Log_in($ftpusername, $ftppassword)){
		trigger_error("Cannot connect to ftp host: " . $ftphost . " on port " . $ftpport, E_USER_WARNING);
		return false;		
	}
	if(!$ftp->PutFile($ftppath . 'test.txt' , 'test.txt')){
		trigger_error("Cannot upload the file test.txt to FTP.", E_USER_NOTICE);
		return false;
	}
}

// Get a list of config files
$config_files = Helper::getConfigList();

?>
<form id="frmconfig" name="frmconfig" method="post" action="">
<?php if($saved){ ?>
<div class="successbox">Configuration is saved succesfully.</div>
<?php } ?>
<h2>Select config to edit</h2>
<p>Select the profile you want to edit.</p>
<p>
  <select name="sltconfig" id="sltconfig" onchange="window.location.href='index.php?page=config&profile=' + this.value">
  		<?php foreach($config_files as $file){ ?>
        	<option value="<?php echo $file ?>" <?php if($_SESSION['config_name'] == $file) echo 'selected' ?>><?php echo $file ?></option>
		<?php } ?>
  </select>
</p>
<h2>Website location</h2>
<p>Fill in the location of the root directory of the website or project you want to backup.</p>
<p><input name="txtwebpath" type="text" id="txtwebpath" value="<?php echo $webpath ?>" size="60" />&nbsp;<a href="javascript:setElementValue('#txtwebpath', '<?php echo $default_web_path ?>');">set default</a>
</p>
<h2>Backup location</h2>
<p>Fill in the location of where you want to save your backups. If you don't know what this is or if you are not sure then don't change the default location.</p>
<p><input name="txtbackuppath" type="text" id="txtbackuppath" value="<?php echo $backuppath ?>" size="60" />&nbsp;<a href="javascript:setElementValue('#txtbackuppath', '<?php echo $default_backup_path ?>');">set default</a>
</p>
<h2>Database configuration</h2>

<table width="100%" border="0" cellspacing="2" cellpadding="0">
  <tr>
    <td width="47%"><label for="txthost">Host</label></td>
    <td width="53%"><input name="txthost" type="text" id="txthost" value="<?php echo $host ?>" size="40" /></td>
  </tr>
  <tr>
    <td><label for="txtusername">Username</label></td>
    <td><input name="txtusername" type="text" id="txtusername" value="<?php echo $username ?>" size="20" /></td>
  </tr>
  <tr>
    <td><label for="txtpassword">Password</label></td>
    <td><input name="txtpassword" type="text" id="txtpassword" value="<?php echo $password ?>" size="20" /></td>
  </tr>
  <tr>
    <td><label for="txtname">Default database</label></td>
    <td><input name="txtname" type="text" id="txtname" value="<?php echo $name ?>" size="20" /></td>
  </tr>
  <tr>
    <td><label for="txtport">Port</label></td>
    <td><input name="txtport" type="text" id="txtport" size="6" value="<?php echo $port ?>" /></td>
  </tr>
  <tr>
    <td><label for="sltcharset">Charset</label></td>
    <td>
      <select name="sltcharset" id="sltcharset">
      <?php foreach($charsets as $charset_text){ ?>
        <option value="<?php echo $charset_text ?>" <?php if($charset_text == $charset) echo 'selected="selected"' ?>><?php echo $charset_text ?></option>
        <?php } ?>
     </select>    
    </td>
  </tr>
</table>

<h2>Exclude dirs from backup</h2>
<p>Fill in a list of comma separated directory names that you don't want to include in your backup. An example could be: images,myfiles. In this case the directories images, myfiles and their contents would not be included in the backup.</p>

<p>
  <textarea name="txtdirs" id="txtdirs" cols="50" rows="5"><?php echo $dirs ?></textarea>
</p>
<h2>Exclude files from backup</h2>
<p>Fill in a list of comma separated directory names that you don't want to include in your backup. An example could be: Thumb.db,spaceship.jpg. In this case files with names Thumb.db, spaceship.jpg would not be included in the backup. You can also use * as a wildcard. So for example you can use *.log to exclude all files that have a .log extension.</p>
<p>
  <textarea name="txtfiles" id="txtfiles" cols="50" rows="5"><?php echo $files ?></textarea>
</p>
<h2>Timezone</h2>
<p>Fill in the correct timezone you want to use. This is important because we are working with dates an times as names for the backups. To choose the right timezone you can take a look at <a href="http://php.net/manual/en/timezones.php" target="_blank">this website</a>.</p>
<p><input name="txttimezone" type="text" id="txttimezone" value="<?php echo $timezone ?>" size="60" />
</p>
<h2>Memory limit</h2>
<p>With this option you can configure how many memory the script can use. For regular website 32 is enough but if you have a bigger website you can increase this value. If you have corrupt backup zips you must increase this value.</p>
<p><input name="txtmemory" type="text" id="txtmemory" value="<?php echo $memory ?>" size="10" />
</p>

<h2>Maximum backups files</h2>
<p>With this setting you can define a maximum number of backup files. If there are more files in the backup folder, than the older backups would be deleted until there are maximum x files in the folder.</p>
<p><input name="txtmaxbackups" type="text" id="txtmaxbackups" value="<?php echo $maxbackups ?>" size="10" />
</p>

<h2>Clean deploy/rollback</h2>
<p>Remove all files and directories before executing deploy or rollback.</p> 
<p class="warningbox"><strong>Important</strong>: Keep in mind that if you have excluded files from a backup and you do a clean rollback you will lose this excluded files!</p>
<p>
<label for="cleanrollback">Enable clean rollback/deploy</label>&nbsp;&nbsp;&nbsp; <input type="checkbox" value="true" id="cleanrollback" name="cleanrollback" <?php if($cleanrollback) echo 'checked="checked"' ?> />
</p>

<h2>FTP Backups<a name="ftpbackup"></a></h2>
<p>With this option you can copy your backups to another server using FTP. If you enable <strong>Keep local copy</strong>, there always will be kept a second backup on the local server. <strong>FTP storage path</strong> can be used to define the path where to save the backups on the remote server. Make sure you always use a trailing slash for this option. For example <strong>/backups/</strong>.
<table width="100%" border="0" cellspacing="2" cellpadding="0">
	<tr>
    <td width="47%"><label for="chkftp">Enable FTP backup</label></td>
    <td width="53%"><input type="checkbox" value="true" id="chkftp" name="chkftp" <?php if($saveftp) echo 'checked="checked"' ?> /></td>
  </tr>
  <tr>
    <td width="47%"><label for="chklocalcopy">Keep local copy</label></td>
    <td width="53%"><input type="checkbox" value="true" id="chklocalcopy" name="chklocalcopy" <?php if($savelocal) echo 'checked="checked"' ?>/></td>
  </tr>
  <tr>
    <td width="47%"><label for="txtftphost">Host</label></td>
    <td width="53%"><input name="txtftphost" type="text" id="txtftphost" value="<?php echo $ftphost ?>" size="40" /></td>
  </tr>
  <tr>
    <td width="47%"><label for="txtftpport">Port</label></td>
    <td width="53%"><input name="txtftpport" type="text" id="txtftpport" value="<?php echo $ftpport ?>" size="5" /></td>
  </tr>
  <tr>
    <td><label for="txtftpusername">Username</label></td>
    <td><input name="txtftpusername" type="text" id="txtftpusername" value="<?php echo $ftpusername ?>" size="20" /></td>
  </tr>
  <tr>
    <td><label for="txtftppassword">Password</label></td>
    <td><input name="txtftppassword" type="text" id="txtftppassword" value="<?php echo $ftppassword ?>" size="20" /></td>
  </tr>
  <tr>
    <td><label for="txtftppath">FTP storage path</label></td>
    <td><input name="txtftppath" type="text" id="txtftppath" value="<?php echo $ftppath ?>" size="40" /></td>
  </tr>
</table>

<br />
<p class="warningbox">To test if the FTP is configured correct you must first click on the <strong>Safe configuration</strong> button. After saving <a href="index.php?page=config&action=ftptest#ftpbackup">click this link</a> to create a test.txt file on the FTP. This way you can see or the FTP is configured correct.<p>
  <input type="submit" class="button" name="btnsave" id="btnsave" value="Save configuration" />
</p>
<p>&nbsp; </p>
<p>&nbsp;</p>
</form>
