<?php
class FtpEasy
{
    protected $streams = array ();
    
    public function Connect ($host, $port = '21', $timeout = 90, $StreamName = 'base')
    {
        $chk    = ftp_connect ($host, $port, $timeout);
        if ($chk)
        {
            $this->streams[$StreamName]    = $chk;
            return $chk;
        }
        return false;
    }

    public function Log_in ($username, $password, $StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
            return ftp_login ($this->streams[$StreamName], $username, $password);
        
        return false;
    }

    public function Close ($StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
        {
            unset ($this->streams[$StreamName]);
            return ftp_quit ($this->streams[$StreamName]);
        }
        
        return false;
    }

    public function DoPASV ($StreamName = 'base', $on = true)
    {
        $on = ($on == true) ? true : false;
        return ftp_pasv ($StreamName, $on);
    }

    public function PutFile ($rfile, $lfile, $type = FTP_ASCII, $StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
        {
            $chk     = ftp_put ($this->streams[$StreamName], $rfile, $lfile, $type);
            return (file_exists ($lfile) && ($type == FTP_ASCII || $type == FTP_BINARY) && $chk) ? $chk : false;
        }
        return false;
    }

    public function GetFile ($rfile, $lfile, $type = FTP_ASCII, $StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
        {
            $chk     = ftp_get ($this->streams[$StreamName], $lfile, $rfile, $type);
            return (file_exists ($lfile) && ($type == FTP_ASCII || $type == FTP_BINARY) && $chk) ? $chk : false;
        }
        return false;
    }

    public function DelFile ($file, $StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
        {
            $chk     = ftp_delete ($this->streams[$StreamName], $file);
            return $chk;
        }
        return false;
    }

    public function GetFileSize ($file, $StreamName = 'base')
    {
        return ftp_size ($StreamName, $file);
    }

    public function Rename ($old, $new, $StreamName = 'base')
    {
        return ftp_rename ($StreamName, $old, $new);
    }

    public function DelDir ($dir, $StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
        {
            $chk     = ftp_rmdir ($this->streams[$StreamName], $dir);
            return $chk;
        }
        return false;
    }

    public function MakeDir ($dir, $StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
        {
            $chk     = ftp_mkdir ($this->streams[$StreamName], $dir);
            return $chk;
        }
        return false;
    }

    private function GetStreamStatus ($StreamName = 'base')
    {
        if (isset ($this->streams[$StreamName]))
            return true;
        
        return false;
    }

    public function ListDirFiles ($directory, $raw = false, $StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
        {
            $func    = ($raw == false) ? 'ftp_nlist' : 'ftp_rawlist'; 
            $chk    = $func ($this->streams[$StreamName], $directory);
            if (is_array ($chk))
            {
                $arr    = array ();
                foreach ($chk as $key => $file)
                    $arr[] = ($raw == false) ? str_replace ($directory . '/', '', $file) : $file;

                return $arr;
            }
            return false;
        }
        return false;
    }

    public function SendRaw ($raw, $StreamName = 'base')
    {
        if ($this->GetStreamStatus ($StreamName) == true)
        {
            $chk    = ftp_exec ($this->streams[$StreamName], $raw);
            return $chk;
        }
        return false;
    }

    public function GetCurrentDir ($StreamName = 'base')
    {
        return ftp_pwd ($StreamName);
    }

    public function SwitchDir ($dir, $StreamName = 'base')
    {
        return ftp_chdir ($StreamName, $dir);
    }

    public function DoCHMOD ($path, $chmod, $StreamName = 'base')
    {
        $chk    = (ftp_chmod ($StreamName, $chmod, $path) == false) ? false : true;
        return $chk;
    }
}
?> 