<?php

/**
 * This class holds some functions that are used in
 * the application
 */
class Helper{

	public static function getConfigList(){
		
		// Get root Abs
		$root = str_replace("/lib", "", str_replace("\\", "/", dirname(__FILE__)));
		
		$File = new Explorer();
		$File->SetPath($root);
		$list = $File->Listing(array(), array(), array(), false);

		// Make list of config files
		$config_files = array();
		foreach($list as $file){
			if(isset($file['filename']) && $file['filename'] != 'config.new.php'){
				$file['filename'] = str_replace('.php', '', $file['filename']);	
				if(strstr($file['filename'], 'config') && $file['filename'] != 'config_build'){
					if($file['filename'] == 'config'){
						 $file['filename'] = 'default';
					}else{
						$file['filename'] = str_replace('config.', '', $file['filename']);	
					}
					$config_files[] = $file['filename'];
				}
			}
		}
		
		return $config_files;
	}
	
	public static function isValidProfile($profile){
		
		// Get profile filename
		$filename = self::profileToFilename($profile);
		
		// Check if file exists
		$root = str_replace("/lib", "", str_replace("\\", "/", dirname(__FILE__)));
		return file_exists($root . '/' . $filename);
		
	}
	
	public static function profileToFilename($profile){
		if($profile == "default"){
			return 'config.php';	
		}else{
			return 'config.' . $profile . '.php';	
		}
	}
	
	public static function profileSpecificFilter(&$array){
		$clean = array();
		foreach($array as $file){
			if(isset($file['filename']) && strstr($file['filename'], $_SESSION['config_name'] . '.')){
				$clean[] = $file;	
			}
		}
		$array = $clean;
	}
	
	public static function addTrailSlash(&$dir){
		self::correctSlash($dir);
		if(substr($dir,-1) != "/"){
			$dir .= "/";
		}
	}
	
	public static function correctSlash(&$dir){
		$dir = str_replace("\\", "/", $dir);	
	}
	
}