<?php 

error_reporting(E_ALL);
register_shutdown_function('handleShutdown');

function ErrorHandler($errno, $errstr, $errfile, $errline)
{

	if($errno < 3) return true;

	// Create content var
	$content = "";
	
	// Log path
	$logpath = str_replace("/lib", "", str_replace("\\", "/", dirname(__FILE__)));
	
	// Get current log file content
	if(file_exists($logpath . "/error.log")){
		$content = file_get_contents($logpath . "/error.log");
	}else{
		$fileHandle = fopen($logpath . "/error.log", 'w') or trigger_error("Can't create log file", E_USER_WARNING);
		fclose($fileHandle);
	}
	
	// Write new log line
	$content .= "[" . date("Y/m/d - h:i:s") . "] " . $errno . " - " . $errstr . " (" . $errfile . ":" . $errline . ")\n";
	
	// Write log to file
	try{
		file_put_contents( $logpath . "/error.log", $content);
	}catch(Exception $e){
		
	}
	
	return true;
}

function logger($value){
	
	if(is_array($value) || is_object($value)){
		$value = print_r($value, true);
	}
	
	$logpath = str_replace("/lib", "", str_replace("\\", "/", dirname(__FILE__)));
	$content = "[" . date("Y/m/d - h:i:s") . "] LOG - " . $value . "\n";
	$fh = fopen($logpath . "/error.log", "a");
	fwrite($fh, $content);
	fclose($fh);
}

function handleShutdown(){
	$error = error_get_last();
	if($error !== NULL){
		$logpath = str_replace("/lib", "", str_replace("\\", "/", dirname(__FILE__)));
		$content = "[" . date("Y/m/d - h:i:s") . "] FATAL - " . $error['message'] . " (" . $error['file'] . ":" . $error['line'] . ")\n";
		$fh = fopen($logpath . "/error.log", "a");
		fwrite($fh, $content);
		fclose($fh);
	}
}

set_error_handler("ErrorHandler");

?>