<?php
/**
 * Site Info widget.
 */
if (!class_exists('Adforest_Site_Info_Widget')) {

    class Adforest_Site_Info_Widget extends WP_Widget {

        /**
         * Register widget with WordPress.
         */
        public function __construct() {
            parent::__construct(
                    'adforest_site_info', // Base ID.
                    __('SB : Site Info', 'adforest'), // Name.
                    array('classname' => 'widget_site_info', 'description' => __('Site Info widget for site information.', 'adforest'))
            );
        }

        public function form($instance) {

            $siteinfo_title = isset($instance['siteinfo_title']) ? esc_attr($instance['siteinfo_title']) : '';
            $siteinfo_desc = isset($instance['siteinfo_desc']) ? esc_attr($instance['siteinfo_desc']) : '';
            $siteinfo_google_app_url = isset($instance['siteinfo_google_app_url']) ? esc_attr($instance['siteinfo_google_app_url']) : '';
            $siteinfo_apple_app_url = isset($instance['siteinfo_apple_app_url']) ? esc_attr($instance['siteinfo_apple_app_url']) : '';
            $image_uri = isset($instance['image_uri']) ? ($instance['image_uri']) : '';
            
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('siteinfo_title')); ?>"><?php echo esc_html_e('Title', 'adforest'); ?></label> 
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('siteinfo_title')); ?>" name="<?php echo esc_attr($this->get_field_name('siteinfo_title')); ?>" type="text" value="<?php echo esc_attr($siteinfo_title); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('image_uri')); ?>">Image</label>
                <img class="<?php echo esc_attr($this->id); ?>_img" src="<?php echo esc_url($image_uri); ?>" style="margin:0;padding:0;max-width:100%;display:block"/>
                <input type="text" class="widefat <?php echo esc_attr($this->id); ?>_url" name="<?php echo esc_attr($this->get_field_name('image_uri')); ?>" value="<?php echo esc_url($image_uri); ?>" style="margin-top:5px;" />
                <input type="button" id="<?php echo esc_attr($this->id); ?>" class="button button-primary js_custom_upload_media" value="Upload Image" style="margin-top:5px;" />
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('siteinfo_desc')); ?>" >
                    <?php echo esc_html__('Description', 'adforest'); ?>
                </label> 
                <textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('siteinfo_desc')); ?>" name="<?php echo esc_attr($this->get_field_name('siteinfo_desc')); ?>"><?php echo esc_attr($siteinfo_desc); ?></textarea>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('siteinfo_google_app_url')); ?>"><?php echo esc_html_e('Google App Url', 'adforest'); ?></label> 
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('siteinfo_google_app_url')); ?>" name="<?php echo esc_attr($this->get_field_name('siteinfo_google_app_url')); ?>" type="text" value="<?php echo esc_attr($siteinfo_google_app_url); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('siteinfo_apple_app_url')); ?>"><?php echo esc_html_e('Apple App Url', 'adforest'); ?></label> 
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('siteinfo_apple_app_url')); ?>" name="<?php echo esc_attr($this->get_field_name('siteinfo_apple_app_url')); ?>" type="text" value="<?php echo esc_attr($siteinfo_apple_app_url); ?>">
            </p>
            <?php
        }

        public function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['siteinfo_title'] = $new_instance['siteinfo_title'];
            $instance['siteinfo_desc'] = $new_instance['siteinfo_desc'];
            $instance['siteinfo_google_app_url'] = $new_instance['siteinfo_google_app_url'];
            $instance['siteinfo_apple_app_url'] = $new_instance['siteinfo_apple_app_url'];
            $instance['image_uri'] = strip_tags($new_instance['image_uri']);
            return $instance;
        }

        public function widget($args, $instance) {

            $title = empty($instance['siteinfo_title']) ? '' : apply_filters('widget_title', $instance['siteinfo_title']);
            $before_widget = isset($args['before_widget']) ? $args['before_widget'] : '';
            $after_widget = isset($args['after_widget']) ? $args['after_widget'] : '';
            $before_title = isset($args['before_title']) ? $args['before_title'] : '';
            $after_title = isset($args['after_title']) ? $args['after_title'] : '';

            $siteinfo_desc = isset($instance['siteinfo_desc']) ? $instance['siteinfo_desc'] : '';
            $google_app_url = isset($instance['siteinfo_google_app_url']) ? $instance['siteinfo_google_app_url'] : '';
            $apple_app_url = isset($instance['siteinfo_apple_app_url']) ? $instance['siteinfo_apple_app_url'] : '';
            $image_uri = isset($instance['image_uri']) ? $instance['image_uri'] : '';
            
            
            
            echo adforest_returnEcho( $before_widget );
            if ('' !== $title) {
                echo adforest_returnEcho( $before_title ) . esc_html($title) . ( $after_title );
            }
            ?>
            <!-- Info Widget -->
            <div class="widget">
                <?php if (isset($image_uri) && !empty($image_uri)) { ?>
                    <div class="logo">
                        <a href="<?php echo esc_url(site_url());?>"> 
                            <img src="<?php echo esc_url($image_uri);?>" class="img-responsive" alt="<?php echo esc_html__('Site Logo','adforest')?>">
                        </a>
                    </div>
                <?php } if (isset($siteinfo_desc) && !empty($siteinfo_desc)) { ?>
                    <p><?php echo esc_html($siteinfo_desc); ?></p>
                <?php } ?>
                <?php if (isset($google_app_url) && !empty($google_app_url) || isset($apple_app_url) && !empty($apple_app_url)) { ?>
                    <ul>
                        <?php if (isset($google_app_url) && !empty($google_app_url)) { ?>
                            <li><a href="<?php echo esc_url($google_app_url); ?>"><img src="<?php echo trailingslashit(get_template_directory_uri()) . 'images/googleplay.png'; ?>" alt="Android App"></a></li>
                        <?php }if (isset($apple_app_url) && !empty($apple_app_url)) { ?>
                            <li><a href="<?php echo esc_url($apple_app_url); ?>"><img src="<?php echo trailingslashit(get_template_directory_uri()) . 'images/appstore.png'; ?>" alt="IOS App"></a></li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>
            <!-- Info Widget Exit --> 

            <?php
            echo adforest_returnEcho( $after_widget );
        }

    }

}
add_action('widgets_init', function() {
    register_widget('Adforest_Site_Info_Widget');
});

/**
 * Site Info widget End.
 */
/**
 * Social Links widget.
 */
if (!class_exists('Adforest_Social_links')) {

    class Adforest_Social_links extends WP_Widget {

        /**
         * Register widget with WordPress.
         */
        public function __construct() {
            parent::__construct(
                    'adforest_social_links', // Base ID.
                    __('SB : Social Links', 'adforest'), // Name.
                    array('classname' => 'socail-icons', 'description' => __('Social Links widget for social information.', 'adforest'))
            );
        }

        public function form($instance) {

            $title = isset($instance['title']) ? esc_attr($instance['title']) : '';
            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php echo esc_html_e('Title', 'adforest'); ?></label> 
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($title); ?>">
            </p>

            <?php
        }

        public function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['title'] = $new_instance['title'];


            return $instance;
        }

        public function widget($args, $instance) {
            global $adforest_theme;
            $title = empty($instance['title']) ? '' : apply_filters('widget_title', $instance['title']);
            $before_widget = isset($args['before_widget']) ? $args['before_widget'] : '';
            $after_widget = isset($args['after_widget']) ? $args['after_widget'] : '';
            $before_title = isset($args['before_title']) ? $args['before_title'] : '';
            $after_title = isset($args['after_title']) ? $args['after_title'] : '';

            echo adforest_returnEcho( $before_widget );
            if ('' !== $title) {
                echo adforest_returnEcho( $before_title ) . esc_html($title) . ( $after_title );
            }
            ?>
            <!-- Follow Us -->

            <ul>
                <?php
//                echo '<pre>';
//                print_r($adforest_theme['social_media']);
//                echo '</pre>';


                foreach ($adforest_theme['social_media'] as $index => $val) {
                    ?>
                    <?php
                    if ($val != "") {
                        ?>
                        <li>
                            <a class="<?php echo esc_attr($index); ?>" href="<?php echo esc_url($val); ?>">
                                <i class="<?php echo adforest_social_icons($index); ?>"></i>
                            </a>
                            <span><?php echo esc_html($index); ?></span>
                        </li>
                        <?php
                    }
                }
                ?>
            </ul>

            <!-- Follow Us End --> 

            <?php
            echo adforest_returnEcho( $after_widget );
        }

    }

}
add_action('widgets_init', function() {
    register_widget('Adforest_Social_links');
});

/**
 * Social Links widget End.
 */