<?php
add_filter('adforest_footer_sidebar_options', 'adforest_footer_sidebar_options_callback', 10, 1);
add_filter('adforest_footer_widget_col_class', 'adforest_footer_widget_col_class_callback', 10, 1);

function adforest_footer_widget_col_class_callback($col = '') {
    // 0-5 = 2 column
    // 6-9 = 3 column
    // 10-12 = 4 column
    // 13-14 = 5 column
    // 15-16 = 6 column
    // 17 = 7 column
    // 18 = 8 colimn
    // 19 = 9 column
    // 20 = 10 column
    // 21 = 12 column
    $col_class = 'col-md-12 col-sm-6 col-xs-12 col-lg-12';
    if ($col >= 0 && $col <= 5) {
        $col_class = 'col-md-2 col-sm-6 col-xs-12 col-lg-2';
    } elseif ($col >= 6 && $col <= 9) {
        $col_class = 'col-md-3 col-sm-6 col-xs-12 col-lg-3';
    } elseif ($col >= 10 && $col <= 12) {
        $col_class = 'col-md-4 col-sm-6 col-xs-12 col-lg-4';
    } elseif ($col >= 13 && $col <= 14) {
        $col_class = 'col-md-5 col-sm-6 col-xs-12 col-lg-5';
    } elseif ($col >= 15 && $col <= 16) {
        $col_class = 'col-md-6 col-sm-6 col-xs-12 col-lg-6';
    } elseif ($col == 17) {
        $col_class = 'col-md-7 col-sm-6 col-xs-12 col-lg-7';
    } elseif ($col == 18) {
        $col_class = 'col-md-8 col-sm-6 col-xs-12 col-lg-8';
    } elseif ($col == 19) {
        $col_class = 'col-md-9 col-sm-6 col-xs-12 col-lg-9';
    } elseif ($col == 20) {
        $col_class = 'col-md-10 col-sm-6 col-xs-12 col-lg-10';
    } elseif ($col == 21) {
        $col_class = 'col-md-12 col-sm-6 col-xs-12 col-lg-12';
    }
    return $col_class;
}

function adforest_footer_sidebar_options_callback($options = array()) {
    $footer_cols_arr = array(
        'column 2',
        'column 2',
        'column 2',
        'column 2',
        'column 2',
        'column 2',
        'column 3',
        'column 3',
        'column 3',
        'column 3',
        'column 4',
        'column 4',
        'column 4',
        'column 5',
        'column 5',
        'column 6',
        'column 6',
        'column 7',
        'column 8',
        'column 9',
        'column 10',
        'column 12',
    );



    $options = array(
        'title' => __('Footer Widgets', 'adforest'),
        'id' => 'sb-footer-sidebar',
        'desc' => __('Enable(on) the footer widgets and add custom footer sidebar columns of your choice.After that you can add widgets in these custom footer sidebar <b>(dashboard > Apperance > widgets)</b> these widgets displays at the top of the footer.', 'adforest'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'sb_footer_widget_switch',
                'type' => 'switch',
                'title' => __('Footer Widgets', 'adforest'),
                'default' => false,
                'desc' => __('<b>Note</b> : This widgetize area will only work for footer-8', 'adforest'),
            ),
            array(
                'id' => 'sb_footer_cols',
                'type' => 'select',
                'multi' => true,
                'sortable' => true,
                'title' => __('Register Sidebar', 'adforest'),
                'desc' => __('Set custom footer sidebar columns for the footer widgetize area.', 'adforest'),
                'options' => $footer_cols_arr,
                'required' => array('sb_footer_widget_switch', 'equals', true)
            ),
        )
    );

    return $options;
}

if (!function_exists('adforest_dynamic_sidebars')) {

    /**
     * Adforest Dynamic Sidebars.
     * @generate sidebars
     */
    function adforest_dynamic_sidebars() {

        $adforest_sidebars = array();
        if (class_exists('Redux')) {
            $adforest_sidebars = Redux::getOption('adforest_theme', 'sb_footer_cols');
        }

        $adforest_sidebars = isset($adforest_sidebars) && !empty($adforest_sidebars) ? $adforest_sidebars : array();
        if (is_array($adforest_sidebars) && sizeof($adforest_sidebars) > 0) {
            $counter = 1;
            foreach ($adforest_sidebars as $sidebar) {
                if ($sidebar != '') {
                    $sidebar_name = sprintf(esc_html__('Footer Sidebar - %d', 'adforest'), $counter);
                    $sidebar_id = 'footer-' . $counter;
                    register_sidebar(array(
                        'name' => $sidebar_name,
                        'id' => $sidebar_id,
                        'description' => esc_html__('Add widgets here.', 'adforest'),
                        'before_widget' => '<div id="%1$s" class="widget %2$s">',
                        'after_widget' => '</div>',
                        'before_title' => '<div class="footer-widget-title"><h2>',
                        'after_title' => '</h2></div>',
                    ));
                }
                $counter++;
            }
        }
    }

    add_action('widgets_init', 'adforest_dynamic_sidebars');
}


if (!function_exists('adforest_footer_sidebar_widgets')) {

    /**
     * Footer Sidebar Widgets section.
     * @return markup
     */
    function adforest_footer_sidebar_widgets() {

        $adforest_sidebars_col = array();
        $adforest_sidebars_switch = false;
        if (class_exists('Redux')) {
            $adforest_sidebars_col = Redux::getOption('adforest_theme', 'sb_footer_cols');
            $adforest_sidebars_switch = Redux::getOption('adforest_theme', 'sb_footer_widget_switch');
        }

        if (isset($adforest_sidebars_switch) && isset($adforest_sidebars_col) && is_array($adforest_sidebars_col) && sizeof($adforest_sidebars_col) > 0) {
            $counter = 1;
            foreach ($adforest_sidebars_col as $sidebar) {
                $sidebar_id = 'footer-' . $counter;
                if (is_active_sidebar($sidebar_id)) {
                    $sidebar_col_class = apply_filters('adforest_footer_widget_col_class', $sidebar);
                    ?>
                    <div class="<?php echo esc_attr($sidebar_col_class) ?>">
                        <?php dynamic_sidebar($sidebar_id) ?>
                    </div>
                    <?php
                }
                $counter++;
            }
        }
    }

    add_action('adforest_footer_sidebar_widgets', 'adforest_footer_sidebar_widgets', 10);
}

if (!function_exists('adforest_header_fav_ads_callback')) {

    function adforest_header_fav_ads_callback() {
        $profile_type = isset($_GET['type']) && !empty($_GET['type']) ? $_GET['type'] : '';
        if ($profile_type == 'fav_ads') {
            ?>
            <script>
                jQuery(document).ready(function () {
                    jQuery('#adforest-fav-ads').click();
                    var uri = window.location.toString();
                    if (uri.indexOf("?") > 0) {
                        var clean_uri = uri.substring(0, uri.indexOf("?"));
                        window.history.replaceState({}, document.title, clean_uri);
                    }
                });
            </script>
            <?php
        }
        if (class_exists('Redux')) {
            $hide_captcha_badge = Redux::getOption('adforest_theme', 'hide_captcha_badge');
        }
        $hide_captcha_badge = isset($hide_captcha_badge) ? $hide_captcha_badge : false;


        if (isset($hide_captcha_badge) && $hide_captcha_badge) {
            ?>
            <style>
                .grecaptcha-badge {
                    display: none;
                }
            </style>
            <?php
        }
    }

    add_action('wp_footer', 'adforest_header_fav_ads_callback');
}
?>