<?php



if ( ! defined( 'ABSPATH' ) ) {

	exit;

}







$show_purchase_note    = $order->has_status( apply_filters( 'woocommerce_purchase_note_order_statuses', array( 'completed', 'processing' ) ) );

$show_customer_details = is_user_logged_in() && $order->get_user_id() === get_current_user_id();

?>

<h2 class="woocommerce-order-details__title"><?php _e( 'Order details', 'woocommerce' ); ?></h2>

<table class="woocommerce-table woocommerce-table--order-details shop_table order_details">



		<thead>

			<tr>

				<th class="woocommerce-table__product-name product-name"><?php _e( 'Product', 'woocommerce' ); ?></th>

				<th class="woocommerce-table__product-table product-total"><?php _e( 'Total', 'woocommerce' ); ?></th>

			</tr>

		</thead>



		<tbody>

			<?php

				foreach ( $order->get_items() as $item_id => $item ) {

					$product = apply_filters( 'woocommerce_order_item_product', $item->get_product(), $item );



					wc_get_template( 'order/order-details-item.php', array(

						'order'			     => $order,

						'item_id'		     => $item_id,

						'item'			     => $item,

						'show_purchase_note' => $show_purchase_note,

						'purchase_note'	     => $product ? $product->get_purchase_note() : '',

						'product'	         => $product,

					) );

				}

			?>

			<?php do_action( 'woocommerce_order_items_table', $order ); ?>

		</tbody>



		<tfoot>

			<?php

				foreach ( $order->get_order_item_totals() as $key => $total ) {

					?>

					<tr>

						<th scope="row"><?php echo $total['label']; ?></th>

						<td><?php echo $total['value']; ?></td>

					</tr>

					<?php

				}

			?>

		</tfoot>



</table>



<?php do_action( 'woocommerce_order_details_after_order_table', $order ); ?>



