<?php

/*

* Plugin Name: WooComposer - Page Builder for WooCommerce

* Plugin URI: https://ninjateam.org/woocomposer-page-builder-woocommerce/

* Description: WooCommerce Page Builder is a quicker way to create from your Product page to Check-out page and Everything in Between

* Version: 1.9

* Author: اسکریپت دات کام

* Author URI: http://www.اسکریپت.com

*/



if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



class WP_Woo_Composer_Builder_VC_Setup{ 



	public function __construct() {

			

			$this->_define_constants();

			add_action('init',array(&$this,'check_plugin_defaults'));

			register_activation_hook(__FILE__, array($this, 'add_template_page'));

			$this->_load_plugin();

	

     	 	if(!function_exists('is_plugin_active'))

			  include_once( ABSPATH . 'wp-admin/includes/plugin.php' );    

		}   





	private function _define_constants() {

           define('NINJA_WOO_PAGE','ninja-woocommerce-page');

           define('NINJA_WOO_PAGE_VERSION','1.8.2');

           define('NINJA_WOO_PAGE_FOLDER', basename(dirname(__FILE__)));

		   define('NINJA_WOO_PAGE_DIR', plugin_dir_path(__FILE__));

		   define('NINJA_WOO_PAGE_INC', NINJA_WOO_PAGE_DIR.'includes'.'/');

		   define('NINJA_WOO_PAGE_URL', plugin_dir_url(NINJA_WOO_PAGE_FOLDER).NINJA_WOO_PAGE_FOLDER.'/');

    

           load_plugin_textdomain('ninja-woocommerce-page', "", NINJA_WOO_PAGE_URL.'/languages');



           

        }





    public function check_plugin_defaults(){

            

            	//  Check woocommrce install & active,

		     	if(!defined('WOOCOMMERCE_VERSION')){

					add_action('admin_notices', array(&$this,'ninja_notice_woo'));

					return;

				}

				//  Check Visual install & active, 

				if(!defined('WPB_VC_VERSION')){

					add_action('admin_notices', array(&$this,'ninja_notice_vc'));

					return;

				}

				

                require_once NINJA_WOO_PAGE_INC.'visual-composer.php';



         }



   	// Function Check Woo Install

	public function ninja_notice_woo(){

			$plugin = get_plugin_data(__FILE__);

			echo '

				  <div class="updated"> <!-- calss default wordpress-->

				    <p>' . sprintf(__('<strong>%s</strong> requires <strong><a href="https://vi.wordpress.org/plugins/woocommerce/" target="_blank">WooCommerce</a></strong> plugin to be installed and activated on your site.', NINJA_WOO_PAGE), $plugin['Name']) . '</p>

				  </div>';

		} 	



	// Function Check VC Install

	public function ninja_notice_vc(){

		$plugin = get_plugin_data(__FILE__);

		echo '<div class="updated">

			    <p>' . sprintf(__('<strong>%s</strong> requires <strong><a href="https://codecanyon.net/item/visual-composer-page-builder-for-wordpress/242431" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site.', NINJA_WOO_PAGE), $plugin['Name']) . '</p>

			  </div>';

	    }



	// ADD TEMPLATE PAGE : PRODUCT , CART , CHECKOUT , MY ACCOUNT

	public function add_template_page(){

          

          // ADD OPTION WHEN CHECK TEMPLATE ACTIVE

		  if(!get_option('role_access_woocompsoer'))

		  {



		  	add_option('role_access_woocompsoer',array('administrator'));

		  	//add_option('role_access_woocompsoer',array('administrator','editor','author','contributor','shop_manager'));

		  }

		  

          global $wpdb; // use query table

          $charset_collate = $wpdb->get_charset_collate();  // format language

          $product_table = $wpdb->prefix.'product_tempate_page';

          $cart_table = $wpdb->prefix.'cart_tempate_page';

          $cart_empty_table=$wpdb->prefix.'cart_empty_tempate_page';

          $checkout_table = $wpdb->prefix.'checkout_tempate_page';

          $myaccount_table=$wpdb->prefix.'myaccount_tempate_page';

          $myaccount_notlogin_table=$wpdb->prefix.'myaccount_not_login_tempate_page';

          $order_received_table=$wpdb->prefix.'order_received_tempate_page';



          $category_table=$wpdb->prefix.'category_tempate_page';



          if ($wpdb->get_var("show tables like '$product_table'") != $product_table) {

	      	Create_Table_DB($product_table,$charset_collate);      

	      }

          load_template_table_DB('product',$product_table);

          if ($wpdb->get_var("show tables like '$cart_table'") != $cart_table) {

	      	Create_Table_DB($cart_table,$charset_collate);      

	      }

          load_template_table_DB('cart',$cart_table);

          if ($wpdb->get_var("show tables like '$cart_empty_table'") != $cart_empty_table) {

	      	Create_Table_DB($cart_empty_table,$charset_collate);      

	      }

          load_template_table_DB('cart-empty',$cart_empty_table);

          if ($wpdb->get_var("show tables like '$checkout_table'") != $checkout_table) {

	      	Create_Table_DB($checkout_table,$charset_collate);     

	      }

          load_template_table_DB('checkout',$checkout_table);

          if ($wpdb->get_var("show tables like '$myaccount_table'") != $myaccount_table) {

	      	Create_Table_DB($myaccount_table,$charset_collate);     

	      }

          load_template_table_DB('myaccount',$myaccount_table);



          if ($wpdb->get_var("show tables like '$myaccount_notlogin_table'") != $myaccount_notlogin_table) {

	      	Create_Table_DB($myaccount_notlogin_table,$charset_collate);     

	      }

          load_template_table_DB('notlogin',$myaccount_notlogin_table);



          if ($wpdb->get_var("show tables like '$order_received_table'") != $order_received_table) {

	      	Create_Table_DB($order_received_table,$charset_collate);     

	      }

          load_template_table_DB('orderreceived',$order_received_table);



          if ($wpdb->get_var("show tables like '$category_table'") != $category_table) {

	      	Create_Table_DB($category_table,$charset_collate);     

	      }



	      load_template_table_DB('category',$category_table);



        }



    //

    private function _load_plugin() {

        

           require_once NINJA_WOO_PAGE_INC.'plugins.php';// Plugin of Us

           

           require_once NINJA_WOO_PAGE_INC.'woocomposer-admin-settings.php';



           // USE WHEN ADD AND EDIT TEMPLATE

           require_once NINJA_WOO_PAGE_INC.'woocomposer-template.php';

           

           require_once NINJA_WOO_PAGE_INC.'tab-woocomposer-VC.php';

           

        }



}



function Create_Table_DB($table,$charset_collate){

    

    $sql = 'CREATE TABLE '.$table.' (

	              `id` int(11) NOT NULL AUTO_INCREMENT,

	              `title` varchar(255) NOT NULL,

	              `images` varchar(255) NOT NULL,

	              `content` TEXT NULL,

	              `active` int(11) NOT NULL default 0,

	              UNIQUE KEY id (id)

	              ) '.$charset_collate.';';

	require_once ABSPATH.'wp-admin/includes/upgrade.php';

	dbDelta($sql);

}





function load_template_table_DB($folder_name,$table){

		$dir = NINJA_WOO_PAGE_DIR. 'templates/'.$folder_name.'/';  // folder container template

	    $ts = scandir($dir); 

	    // remove little

	    foreach ($ts as $k => $v) {

	      if (in_array($v, array('.', '..', '.DS_Store'))) {

	                unset($ts[$k]);

	       }

	            if(is_file($dir.$v))  // remove file with folder only get folder

	            {

	            	unset($ts[$k]);

	            }

	    }

	   // and ts now only have folder

	   foreach ($ts as $k => $v) {

            $t_file =$dir.$v . '/index.php';  // get file index.php have into folder template

            if (!is_file($t_file)) {

                continue;

            }

             $t_preview = ((is_file($dir . $v . '/preview.png')) ? NINJA_WOO_PAGE_URL.'templates/'.$folder_name.'/' . $v . '/preview.png' :  NINJA_WOO_PAGE_URL. 'assets/images/no-image.jpg');

            

             $data_file = require $t_file;

             // ADD CSDL // CHECK TRÙNG

             if(check_title($table,$data_file['title']))

             {

             		add_row_table($table,$data_file['title'],$t_preview,$data_file['data'],0);

             }

        }    

}



function add_row_table($table,$title,$images,$content,$active){

	global $wpdb;

	$wpdb->insert( $table, array( 'title' =>$title,'images' =>$images,'content' =>$content,'active' =>$active), array( '%s', '%s','%s','%d') );

    }



function check_title($table,$name){

	global $wpdb;

	$check=$wpdb->get_row( "SELECT * FROM $table WHERE title ='".$name."' ");

	if(null == $check)

		return true;

  	return false;

}







new WP_Woo_Composer_Builder_VC_Setup();