<?php







namespace WOOCOMPOSER_VC;











require NINJA_WOO_PAGE_INC.'classes/base.php';



require NINJA_WOO_PAGE_INC.'classes/object.php';











class Main extends Base



{



    const post_type = 'epx_page_wooco';



    public function __construct()



    {



   



        $this->add_action('after_setup_theme');



        $this->add_action('init', 999);



    



    }







    public function after_setup_theme()  // show Visual Composer After Setup Theme



    {



        $this->enabled_vc_composer = defined('WPB_VC_VERSION') && function_exists('vc_disable_frontend');



    }







    public function init()



    {



        $args = array(



            'label' => 'Template Page WooCompsoer',



            'supports' => array('title', 'editor', 'revisions'),



            'public' => true,



            'show_ui' => false,



            'rewrite' => false,



            'show_in_nav_menus' => false,



            'exclude_from_search' => true,



            'labels' => array(



                'name' => 'Template Page WooCompsoer',



            ),



        );



        register_post_type(self::post_type, $args);







      



        $this->add_action('admin_menu');



        $this->add_action('current_screen');



       



    }







   







    private function get_template_id($template_id = null)



    {



        global $wp_registered_templates;







        if (!$template_id) {



            $template_id = $this->request_var('sidebar');



        }



        /*



        if (empty($wp_registered_templates[$template_id])) {



            $template_id = current(array_keys($wp_registered_templates));



        }*/







        return $template_id;



    }







    private function get_template_slug($template_id = null)



    {



        $template_slug = $this->get_template_id($template_id);







        $template_slug = apply_filters('vse_get_template_slug', $template_slug, $template_id);







        return $template_slug;



    }







    private function get_template_post($template_id = null, $create = true) // create custom post type



    {



        $template_id = $this->get_template_id($template_id);



        $template_slug = $this->get_template_slug($template_id);







        $args = array(



            'post_type' => self::post_type,



            'name' => $template_slug,



        );



        $query = new \WP_Query($args);







        $post = new WooObject();



        $settings = array();







        if ($query->have_posts()) {



            $post = $query->post;



            $settings = get_post_meta($post->ID, 'epx_page_wooco_settings', true);



        } elseif ($create) {



            $data = array(



                'post_title' => '',



                'post_content' => '',



                'post_type' => self::post_type,



                'post_name' => $template_slug,



                'post_status' => 'publish',



                'guid' => $template_slug,



            );







            // Save post data



            $post_id = wp_insert_post($data);



            $post = get_post($post_id);



        }







        $post->settings = new WooObject($settings);



        $post = apply_filters('vse_get_template_post', $post, $template_id);







        return $post;



    }







    private function setup_template_data($template_id = null)



    {



        global $post, $current_template, $wp_registered_templates;



        $template_id = $this->get_template_id($template_id);







        $post = $this->get_template_post($template_id);







        $current_template = $wp_registered_templates[ $template_id ];







        $revisions = wp_get_post_revisions($post->ID);



        $revisions = apply_filters('vse_get_sidebar_revisions', $revisions, $template_id);







        $current_template['revisions'] = $revisions;



        $current_template['revisions_count'] = count($revisions);



        $current_template['revision_id'] = key($revisions);



    }











    public function current_screen()



    {   



        global $vc_manager, $current_screen, $post, $hook_suffix;



        //echo $current_screen->id; die;



        if ($current_screen->id=='admin_page_add-cart-template' || $current_screen->id=='admin_page_add-checkout-template' || $current_screen->id=='admin_page_add-product-template' || $current_screen->id=='admin_page_add-myaccount-template' || $current_screen->id=='admin_page_add-order-received-template' || $current_screen->id=='admin_page_add-category-template') {



            // modify screen details



            $current_screen->base = 'post';



            $hook_suffix = 'post.php';



            $this->setup_template_data();     



            if ($this->enabled_vc_composer) {



                vc_disable_frontend();







                $post_types = vc_editor_post_types();



                if (!in_array(self::post_type, $post_types)) {



                    $post_types[] = self::post_type;



                    vc_editor_set_post_types($post_types);



                }







                $editor = $vc_manager->backendEditor();



                $editor->addHooksSettings();







                if ($this->enabled_vc_composer && version_compare(WPB_VC_VERSION, '4.9', '>=')) {



                    $editor->registerBackendJavascript();



                    $editor->registerBackendCss();



                    // B.C:



                    visual_composer()->registerAdminCss();



                    visual_composer()->registerAdminJavascript();



                }



            }







            $this->add_action('admin_print_styles');



            $this->add_action('admin_print_scripts');



        }



    }





    public function admin_print_styles() {

        // Support for MPC addons

        if( function_exists('mpc_backend_enqueue') ) {

            mpc_backend_enqueue();

            

        }

        

        

    }

   







    public function display_callback($args, $w_post)



    {



        global $post;







        if (!$w_post || !$w_post->settings) {



            return;



        }







        $post = $w_post;



        extract($args);







        if (empty($this->styles[$id])) {



            $custom_css = get_post_meta($post->ID, '_wpb_post_custom_css', true);



            $custom_css .= get_post_meta($post->ID, '_wpb_shortcodes_custom_css', true);



            $this->inline_css($custom_css, $id);



        }







        $output = '';



        $content = apply_filters('the_content', $post->post_content);



        if ($post->settings->container == 'default') {



            $output .= $before_widget;



            $title = apply_filters('widget_title', $post->post_title);



            if (!empty($title)) {



                $output .= $before_title.$title.$after_title;



            }



            $output .= $content;



            $output .= $after_widget;



        } else {



            $output .= $content;



        }



        echo $output;







        wp_reset_postdata();



    }







    public function render_editor_cart()



    {



        // CREATE WHEN CLICK ADD TEMPLATE (EDIT TEMPLATE)



        global $vc_manager, $post, $wp_registered_templates, $current_template;



     



        $available_sidebars = $wp_registered_templates;







        $post_title = $post->post_title;



        $post_content = $post->post_content;



        $post_status = $post->post_status;



        $post_name = $post->post_name;



        $settings = $post->settings;



        require NINJA_WOO_PAGE_INC.'add_cart_template.php';



    }



    public function render_editor_checkout()



    {



        // CREATE WHEN CLICK ADD TEMPLATE (EDIT TEMPLATE)



        global $vc_manager, $post, $wp_registered_templates, $current_template;



     



        $available_sidebars = $wp_registered_templates;







        $post_title = $post->post_title;



        $post_content = $post->post_content;



        $post_status = $post->post_status;



        $post_name = $post->post_name;



        $settings = $post->settings;



        require NINJA_WOO_PAGE_INC.'add_checkout_template.php';



    }



    public function render_editor_product()



    {



        // CREATE WHEN CLICK ADD TEMPLATE (EDIT TEMPLATE)



        global $vc_manager, $post, $wp_registered_templates, $current_template;



     



        $available_sidebars = $wp_registered_templates;







        $post_title = $post->post_title;



        $post_content = $post->post_content;



        $post_status = $post->post_status;



        $post_name = $post->post_name;



        $settings = $post->settings;



        require NINJA_WOO_PAGE_INC.'add_product_template.php';



    }



    public function render_editor_myaccount()

    {

        // CREATE WHEN CLICK ADD TEMPLATE (EDIT TEMPLATE)

        global $vc_manager, $post, $wp_registered_templates, $current_template;

     

        $available_sidebars = $wp_registered_templates;



        $post_title = $post->post_title;

        $post_content = $post->post_content;

        $post_status = $post->post_status;

        $post_name = $post->post_name;

        $settings = $post->settings;

        require NINJA_WOO_PAGE_INC.'add_myaccount_template.php';

    }

    public function render_editor_order_received()

    {

        // CREATE WHEN CLICK ADD TEMPLATE (EDIT TEMPLATE)

        global $vc_manager, $post, $wp_registered_templates, $current_template;

     

        $available_sidebars = $wp_registered_templates;



        $post_title = $post->post_title;

        $post_content = $post->post_content;

        $post_status = $post->post_status;

        $post_name = $post->post_name;

        $settings = $post->settings;

        require NINJA_WOO_PAGE_INC.'add_order_received_template.php';

    }



    public function render_editor_category()

    {

        // CREATE WHEN CLICK ADD TEMPLATE (EDIT TEMPLATE)

        global $vc_manager, $post, $wp_registered_templates, $current_template;

     

        $available_sidebars = $wp_registered_templates;



        $post_title = $post->post_title;

        $post_content = $post->post_content;

        $post_status = $post->post_status;

        $post_name = $post->post_name;

        $settings = $post->settings;

        require NINJA_WOO_PAGE_INC.'add_category_template.php';

    }



    public function admin_menu()



    {



        if(!isset($_GET["edit"]))

            $title = 'Add Template';

        else

           $title = 'Edit Template';



        $cap = 'edit_posts';



        $callback1 = $this->cb('render_editor_cart');



        $callback2 = $this->cb('render_editor_checkout');



        $callback3 = $this->cb('render_editor_product');



        $callback4 = $this->cb('render_editor_myaccount');



        $callback5 = $this->cb('render_editor_order_received');



        $callback6 = $this->cb('render_editor_category');

        



        add_submenu_page('cart-woo-settings', __($title ,NINJA_WOO_PAGE), __('Add' , NINJA_WOO_PAGE), $cap, 'add-cart-template',$callback1 );



        add_submenu_page('checkout-woo-settings', __($title ,NINJA_WOO_PAGE), __('Add' , NINJA_WOO_PAGE), $cap, 'add-checkout-template',$callback2);



        add_submenu_page('product-woo-settings', __($title ,NINJA_WOO_PAGE), __('Add' , NINJA_WOO_PAGE), $cap, 'add-product-template',$callback3);



        add_submenu_page('myaccount-woo-settings', __($title ,NINJA_WOO_PAGE), __('Add' , NINJA_WOO_PAGE), $cap, 'add-myaccount-template',$callback4);

        add_submenu_page('order-received-woo-settings', __($title ,NINJA_WOO_PAGE), __('Add' , NINJA_WOO_PAGE), $cap, 'add-order-received-template',$callback5);



        add_submenu_page('category-woo-settings', __($title ,NINJA_WOO_PAGE), __('Add' , NINJA_WOO_PAGE), $cap, 'add-category-template',$callback6);



    }   



}











$GLOBALS['VSE'] = new Main();



