<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
//set_name slug category
function get_cat_slug($category_id) {
$category=get_term_by('id', $category_id, 'product_cat', 'ARRAY_A');
    return $category['slug'];
}
//FUNCTION SINGLE PRODUCT TEMPLATE
add_action( 'vc_backend_editor_render', 'ninja_fix_conflict', 9999 );
function ninja_fix_conflict() {
  wp_dequeue_script( 'vc_vendor_yoast_js' );
  if ( wp_script_is( 'yoast-seo-post-scraper' ) ) {
    wp_enqueue_script( 'vc_vendor_yoast_js', vc_asset_url( 'js/vendors/yoast.js' ), array( 'yoast-seo-post-scraper' ), WPB_VC_VERSION, true );
  }
}
function apply_css_template_selected($content){
    // use css of Visual composer
    $css = apply_filters( 'vc_base_build_shortcodes_custom_css', visual_composer()->parseShortcodesCustomCss( $content) );
    if ($css!="") {
      echo '<style>';
      echo $css;
      echo '</style>';
    }
}
function content_product_when_use_template_name(){
  global $ninja_single_product_template;
    global $wpdb;
    $table_product=$wpdb->prefix.'product_tempate_page';
    $id = $ninja_single_product_template;   // only get content into editor (character)
    //========== get when have visual composer and shortcode==========
    if($id=='active')
    {
       $list_template=$wpdb->get_results( "SELECT * FROM $table_product" );
       foreach ($list_template as $key => $select_template) {
         if($select_template->active==1)
         {
            $content=$select_template->content;
            break;
         }
       }
    }
    else
    {
      $select_template = $wpdb->get_row( "SELECT * FROM $table_product WHERE id = $id" );
      $content=$select_template->content;
    }
    $content = apply_filters( 'the_content', $content );
    $content = str_replace( ']]>', ']]&gt;', $content );
    echo $content;
    // USER CSS WITH VISUAL COMPOSER
    apply_css_template_selected($select_template->content);
}
//FUNCTION CART TEMPLATE
add_action( 'template_redirect','register_cart_template');
function register_cart_template(){     
          global $post,$wpdb;   
          if(empty($post))
           return;
          if(defined('WOOCOMMERCE_VERSION')){ 
          if(is_cart()):
            if(WC()->cart->is_empty()){  // cart empty
                $table_cart_empty=$wpdb->prefix.'cart_empty_tempate_page';
                $template_actived = $wpdb->get_row( "SELECT * FROM $table_cart_empty WHERE active=1" );
                if(!empty($template_actived)){
                  add_filter( 'the_content','ninja_get_template_cart_belongs');
                }
            }else{  // cart
                $table_cart=$wpdb->prefix.'cart_tempate_page';
                $template_actived = $wpdb->get_row( "SELECT * FROM $table_cart WHERE active=1" );
                if(!empty($template_actived)){
                  add_filter( 'the_content','ninja_get_template_cart_belongs');
                }
            }
            
          endif;
          }
}
function ninja_get_template_cart_belongs(){
  global $post,$wpdb;
   if(WC()->cart->is_empty()):
    ob_start();
     $count=0;
     $table_cart_empty=$wpdb->prefix.'cart_empty_tempate_page';
      $result=$wpdb->get_results( "SELECT * FROM $table_cart_empty" );
      foreach ($result as $key => $value):
        if($value->active==1):
         $count++;
          echo do_shortcode($value->content);
          apply_css_template_selected($value->content);
          break;
        endif;
      endforeach;
      if($count==0)
        echo do_shortcode('[ninja_page_cart_empty text_empty="Your cart is currently empty"]');
     return ob_get_clean();
   else:
   $table_cart=$wpdb->prefix.'cart_tempate_page';
          if($ninja_woo_page_cart = get_post_meta($post->ID,'ninja_woo_page_cart',true));
              $cart_template_id = (int)$ninja_woo_page_cart;
          if($cart_template_id!=0):
              ob_start();
              $template_actived = $wpdb->get_row( "SELECT * FROM $table_cart WHERE ID =$cart_template_id" );
                 echo  do_shortcode($template_actived->content);
              // USER CSS WITH VISUAL COMPOSER
                apply_css_template_selected($template_actived->content);
              return ob_get_clean();
          else:
            return '[woocommerce_cart]';  // default
          endif;
  endif;
}
//FUNCTION CHECKOUT TEMPLATE
add_action('ninja_woocommerce_before_checkout_form', 'ninja_before_checkout_form', 1);
add_action('ninja_woocommerce_after_checkout_form', 'ninja_after_checkout_form', 99);
function ninja_before_checkout_form(){
     // Show non-cart errors
    wc_print_notices();
    // Check cart has contents
    if ( WC()->cart->is_empty() ) {
        return;
    }
    // Check cart contents for errors
    do_action( 'woocommerce_check_cart_items' );
    // Calc totals
    WC()->cart->calculate_totals();
    // Get checkout object
    $checkout = WC()->checkout();
    if ( empty( $_POST ) && wc_notice_count( 'error' ) > 0 ) {
        wc_get_template( 'checkout/cart-errors.php', array( 'checkout' => $checkout ) );
    }else{
        $non_js_checkout = ! empty( $_POST['woocommerce_checkout_update_totals'] ) ? true : false;
        if ( wc_notice_count( 'error' ) == 0 && $non_js_checkout )
            wc_add_notice( __( 'The order totals have been updated. Please confirm your order by pressing the Place Order button at the bottom of the page.', 'woocommerce' ) );
            wc_get_template( 'checkout/before-form-checkout.php', array( 'checkout' => $checkout, 'woo-composer-page-template' => 1 ), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );
    }
}
function ninja_after_checkout_form(){
    $checkout = WC()->checkout();
    wc_get_template( 'checkout/after-form-checkout.php', array( 'checkout' => $checkout, 'woo-composer-page-template' => 1 ), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );
}
add_action( 'template_redirect','register_checkout_template',1);
function register_checkout_template(){

  global $wp,$post,$wpdb;   
          if(empty($post))
           return;
        if(defined('WOOCOMMERCE_VERSION')){    
          if(is_checkout()):
            add_filter( 'the_content','ninja_get_template_checkout_belongs');
          endif;
        }
}
function ninja_get_template_checkout_belongs(){
  
  global $wp,$post,$wpdb;

  $checkout_table = $wpdb->prefix.'checkout_tempate_page';
  $order_received_table=$wpdb->prefix.'order_received_tempate_page';
          $template_actived = $wpdb->get_row( "SELECT * FROM $checkout_table WHERE active=1" );
          if($template_actived):
            if(!isset($wp->query_vars['order-pay']) && !isset( $wp->query_vars['order-received'] )):
              ob_start();
              ?>
              <div class="woocommerce">
              <?php
                  do_action('ninja_woocommerce_before_checkout_form');
                  
                  echo do_shortcode($template_actived->content);
                  do_action('ninja_woocommerce_after_checkout_form');
              ?>
              </div>
             <?php
                return ob_get_clean();
            else:  // PAGE CHECKOUT WHEN ORDER RECEIVED
              if(order_received_actived_template()!=0): // when actived template other default
                  $id=order_received_actived_template();
                  ob_start();                
                     $template_actived = $wpdb->get_row( "SELECT * FROM $order_received_table WHERE ID =$id" );
                      echo do_shortcode($template_actived->content); 
                      // USER CSS WITH VISUAL COMPOSER
                      apply_css_template_selected($template_actived->content);   
                  return ob_get_clean();
              else:
                  return do_shortcode('[woocommerce_checkout]');
              endif;  
            endif;
          else:
            if(!isset($wp->query_vars['order-pay']) && !isset( $wp->query_vars['order-received'] )):
                return do_shortcode('[woocommerce_checkout]');  // default
            else:
                if(order_received_actived_template()!=0): // when actived template other default
                  $id=order_received_actived_template();
                  ob_start();                
                     $template_actived = $wpdb->get_row( "SELECT * FROM $order_received_table WHERE ID =$id" );
                      echo do_shortcode($template_actived->content);
                      // USER CSS WITH VISUAL COMPOSER
                      apply_css_template_selected($template_actived->content);  
                  return ob_get_clean();
                else:
                  return do_shortcode('[woocommerce_checkout]');
              endif;
            endif;
          endif;
}
// FUNCTION TEMPLATE MYACCOUNT
add_action( 'template_redirect','register_myaccount_template');
function register_myaccount_template(){ 

          global $post,$wpdb;
          $myaccount_table=$wpdb->prefix.'myaccount_tempate_page';
          $myaccount_notlogin_table=$wpdb->prefix.'myaccount_not_login_tempate_page';   
          if(empty($post))
           return; 
        if(defined('WOOCOMMERCE_VERSION')){      
          if(is_account_page()):
           if (is_user_logged_in() ){
              $template_actived = $wpdb->get_row( "SELECT * FROM $myaccount_table WHERE active=1" );
              if(!empty($template_actived)){
                  add_filter( 'the_content','ninja_get_template_myaccount_belongs');
              }
            
           }else{
              $template_actived = $wpdb->get_row( "SELECT * FROM $myaccount_notlogin_table WHERE active=1" );
              if(!empty($template_actived)){
                  add_filter( 'the_content','ninja_get_template_myaccount_belongs');
              }

          }
          endif;
        }
}
function ninja_get_template_myaccount_belongs(){
        global $post,$wpdb;
        $myaccount_table=$wpdb->prefix.'myaccount_tempate_page';
        $myaccount_notlogin_table=$wpdb->prefix.'myaccount_not_login_tempate_page';
       
          if (is_user_logged_in() ):
            $template_selected = $wpdb->get_row( "SELECT * FROM $myaccount_table WHERE active=1" );
            $id_active = $template_selected->id;
            // Start output buffer since the html may need discarding for BW compatibility
            ob_start();
            ?>
            <div class="woocommerce">
            <?php
              // Collect notices before output
              $notices = wc_get_notices();
              wc_set_notices( $notices );
              wc_print_notices();
              $template_actived = $wpdb->get_row( "SELECT * FROM $myaccount_table WHERE ID =$id_active" );
                  echo do_shortcode($template_actived->content);
            ?>
            </div>
            <?php
            // USER CSS WITH VISUAL COMPOSER
            apply_css_template_selected($template_actived->content);
            return ob_get_clean();
          else:  // when not login
              if(notlogin_actived_template()!=0):
                global $wp;
                $template_selected = $wpdb->get_row( "SELECT * FROM $myaccount_notlogin_table WHERE active=1" );
                $id_active = $template_selected->id;
                if( !isset($wp->query_vars['lost-password']) ):
                  $id=notlogin_actived_template();
                  ob_start();?>
                  <div class="woocommerce">
                  <?php
                     $template_actived = $wpdb->get_row( "SELECT * FROM $myaccount_notlogin_table WHERE ID =$id" );
                      echo do_shortcode($template_actived->content);?>
                  </div><?php 
                  // USER CSS WITH VISUAL COMPOSER
                  apply_css_template_selected($template_actived->content);
                  return ob_get_clean();
                else:
                  ob_start();
                  $myaccount= new WC_Shortcode_My_Account();
                  $myaccount->lost_password();
                  return ob_get_clean();
                endif;
              else:
                  return do_shortcode('[woocommerce_my_account]');
              endif;
          endif;
        
}
function notlogin_actived_template(){
  global $wpdb;
  $myaccount_notlogin_table=$wpdb->prefix.'myaccount_not_login_tempate_page';
  $template_active = $wpdb->get_results( "SELECT * FROM $myaccount_notlogin_table" );
  foreach ($template_active as $key => $row) {
      if($row->active==1)
          return $row->id;
  }
  return 0;
}
//
add_action('ninja_woocomposer_account_orders_in_tab','ninja_woocomposer_account_orders_in_tab',10,1);
function ninja_woocomposer_account_orders_in_tab($tab_id){
    global $dtwbp_my_account_current_order_id;
    if(empty($dtwbp_my_account_current_order_id))
      $dtwbp_my_account_current_order_id = $tab_id;
  }
add_action('ninja_woocomposer_wc_get_endpoint_url','ninja_woocomposer_wc_get_endpoint_url', 10, 1);
function ninja_woocomposer_wc_get_endpoint_url($tab_id){
    global $woocomposer_wc_get_endpoint_url_tab_id;
    if( empty($woocomposer_wc_get_endpoint_url_tab_id) )
      $woocomposer_wc_get_endpoint_url_tab_id = $tab_id;
    add_filter('woocommerce_get_endpoint_url','ninja_woocomposer_woocommerce_get_endpoint_url', 10,4);
  }
function njt_my_account_edit_address( $load_address = 'cobranca' ) {
    $current_user = wp_get_current_user();
    $load_address = sanitize_key( $load_address );
    $address = WC()->countries->get_address_fields( get_user_meta( get_current_user_id(), $load_address . '_country', true ), $load_address . '_' );
    // Enqueue scripts
    wp_enqueue_script( 'wc-country-select' );
    wp_enqueue_script( 'wc-address-i18n' );
    // Prepare values
    foreach ( $address as $key => $field ) {
      $value = get_user_meta( get_current_user_id(), $key, true );
      if ( ! $value ) {
        switch ( $key ) {
          case 'billing_email' :
          case 'shipping_email' :
            $value = $current_user->user_email;
          break;
          case 'billing_country' :
          case 'shipping_country' :
            $value = WC()->countries->get_base_country();
          break;
          case 'billing_state' :
          case 'shipping_state' :
            $value = WC()->countries->get_base_state();
          break;
        }
      }
      $address[ $key ]['value'] = apply_filters( 'woocommerce_my_account_edit_address_field_value', $value, $key, $load_address );
    }
    if($load_address=="cobranca") $load_address="billing";
    wc_get_template( 'myaccount/form-edit-address.php', array(
      'load_address'  => $load_address,
      'address'   => apply_filters( 'woocommerce_address_to_edit', $address, $load_address ),
    ) );
 }
function ninja_woocomposer_woocommerce_get_endpoint_url($url, $endpoint, $value, $permalink){
    global $woocomposer_wc_get_endpoint_url_tab_id;
    $url = $url . '#'.$woocomposer_wc_get_endpoint_url_tab_id['tab_id'];
    return $url;
  }
add_action('ninja_woocomposer_woocommerce_account_view_order_backorder','ninja_woocomposer_woocommerce_account_view_order_backorder',10,1);
function ninja_woocomposer_woocommerce_account_view_order_backorder($myaccount_url){
    ?>
    <h2><a href="<?php echo esc_url($myaccount_url);?>" title="<?php echo apply_filters('woocommerce_account_view_order_backorder', esc_html__('Back to Order list', 'dt_woocommerce_page_builder'));?>"><?php echo apply_filters('woocommerce_account_view_order_backorder', esc_html__('Back to Order list', 'dt_woocommerce_page_builder'));?></a></h2>
    <?php
  }
// =============Order Received
add_action( 'ninja_woocomposer_thankyou_order', 'ninja_woocomposer_thankyou_order', 10 );
function ninja_woocomposer_thankyou_order( $order ) {
  wc_get_template( 'order-received/thank-you.php',array( 'order' => $order ), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );
}
add_action( 'ninja_woocomposer_order_detail', 'ninja_woocomposer_order_detail', 10 );
function ninja_woocomposer_order_detail( $order ) {
  wc_get_template( 'order-received/order-detail.php',array( 'order' => $order ), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );
}
add_action( 'ninja_woocomposer_customer_detail', 'ninja_woocomposer_customer_detail', 20 );
function ninja_woocomposer_customer_detail( $order ) {
 wc_get_template( 'order-received/customer-detail.php',array( 'order' => $order ), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );
}
add_action( 'ninja_woocomposer_billing_address', 'ninja_woocomposer_billing_address', 30 );
function ninja_woocomposer_billing_address( $order ) {
  wc_get_template( 'order-received/billing-address.php',array( 'order' => $order ), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );
}
function order_received_actived_template(){
  global $wpdb;
  $order_received_table=$wpdb->prefix.'order_received_tempate_page';
  $template_active = $wpdb->get_results( "SELECT * FROM $order_received_table" );
  foreach ($template_active as $key => $row) {
      if($row->active==1)
          return $row->id;
  }
  return 0;
}
// piority file in woocommerce in plugin
add_action( 'product_cat_edit_form_fields', 'edit_product_cat_field', 10, 2 );
function edit_product_cat_field( $term, $taxonomy ){
    global $product_cats,$wpdb;
    // get current group
    $product_cat = get_term_meta( $term->term_id, 'ninja_woo_page_categroy', true );           
    ?>
    <tr class="form-field">
      <th valign="top" scope="row"><label for=""><?php _e('Template', NINJA_WOO_PAGE); ?></label></th>
      <td>
        <select name="ninja_woo_page_categroy" data-placeholder="Select a page…" class="enhanced chosen_select_nostd" id="ninja_woo_page_categroy">
      <option value="">Default By WooCommrce</option>
      <option <?php if($product_cat=='active') echo ' selected="selected"'; ?> value="active">Template Active</option>
    <?php 
          $table_cate=$wpdb->prefix.'category_tempate_page';
        $list_template=$wpdb->get_results( "SELECT * FROM $table_cate" );
            foreach ($list_template as $key => $template):
            ?>
            <option <?php if($template->id==absint($product_cat)) echo ' selected="selected" '; ?> value="<?php echo $template->id; ?>"><?php echo $template->title; ?></option>
            <?php endforeach;?>
    </select>
    </td>
    </tr>
<?php
}
add_action( 'edited_product_cat', 'wcpr_update_meta', 10, 2 );
function wcpr_update_meta( $term_id, $tt_id ){
        $group = sanitize_title( $_POST['ninja_woo_page_categroy'] );
        update_term_meta( $term_id, 'ninja_woo_page_categroy', $group );
 // update_term_meta( $term_id, 'wcpr-page', '' );  //default woocommrce
}
//==================================category builder===========
add_action( 'template_redirect','register_product_category_template');
if( ! function_exists('register_product_category_template')):
function register_product_category_template(){     
          if(defined('WOOCOMMERCE_VERSION')){ 
          if(is_tax('product_cat') && is_product_category()):
            global $wp_query;
            $term_id= $wp_query->get_queried_object_id();  // id of category selected
            $id= get_term_meta (   $term_id,  'ninja_woo_page_categroy', true ); // get page redirect
            if($id!="")
            add_filter( 'template_include',  'redirect_product_category_template'  ,1000);
          endif;
        }
}
if(!function_exists('redirect_product_category_template')):
  function redirect_product_category_template($template){
      global $post;
          $file = 'archive-product.php';
          $find[] = 'WooComposer/' . $file;
          $template       = locate_template( $find );
          $status_options = get_option( 'woocommerce_status_options', array() );
          if ( ! $template || ( ! empty( $status_options['template_debug_mode'] ) && current_user_can( 'manage_options' ) ) )
            $template = NINJA_WOO_PAGE_DIR . '/woocommerce/' . $file;
          return $template;
  }
endif;
endif;