<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly



class NINJA_WooComposer_Page_Admin {



	public function __construct(){

		add_action('admin_enqueue_scripts',array(&$this,'admin_enqueue_styles'));

		add_action('add_meta_boxes', array(&$this,'ninja_add_meta_boxes'));

		add_action( 'save_post', array(&$this,'save_woocomposer_meta_data'),1,2 );

	}



	public function admin_enqueue_styles(){

		wp_enqueue_style('ninja-woo-page-admin', NINJA_WOO_PAGE_URL.'/assets/css/admin.css');

	}



	public function ninja_add_meta_boxes(){

	    

		add_meta_box('ninja-woo-page-builder-products-meta-box', __('Page Template',NINJA_WOO_PAGE), array(&$this,'add_product_meta_box'), 'product','side');

	  /*

	   if(is_cart())

	   		add_meta_box('ninja-woo-page-builder-cart-meta-box', __('Page Cart Template',NINJA_WOO_PAGE), array(&$this,'add_page_cart_meta_box'), 'page','side');

	   if(is_checkout())

	   		add_meta_box('ninja-woo-page-builder-checkout-meta-box', __('Page Checkout Template',NINJA_WOO_PAGE), array(&$this,'add_page_checkout_meta_box'), 'page','side');

	   	if(is_account_page())

	   		add_meta_box('ninja-woo-page-builder-myaccount-meta-box', __('Page MyAccount Template',NINJA_WOO_PAGE), array(&$this,'add_page_myaccount_meta_box'), 'page','side');

	    */

	}





	// ADD META BOX PAGE SINGLE PRODUCT

	public function add_product_meta_box(){

		

		$product_id = get_the_ID();

		$page_id = get_post_meta($product_id,'ninja_woo_page_product',true);  //(page into post)



		$product_is_template_active = get_post_meta($product_id,'is_template_active_woo',true);

		wp_nonce_field ('ninja_woocommerce_page_nonce', 'ninja_woocommerce_page_nonce',false);

		?>

		

        <?php 

		global $wpdb; 

		      $table_product=$wpdb->prefix.'product_tempate_page';

			  $list_template=$wpdb->get_results( "SELECT * FROM $table_product" );

			  $count=0;

			  foreach ($list_template as $key => $value) {

			  	 if($value->active==1)

			  	 		$count++;

			  }

	    ?>



	    <input type="hidden" name="is_active_templaetwoo" value="template active">

		<select name="ninja_woo_page_product" data-placeholder="Select a page…" class="enhanced chosen_select_nostd" id="ninja_woo_page_product">

	    	

		<option value="">Default By WooCommrce</option>

	    <option <?php if($page_id=='active') echo ' selected="selected"'; ?> value="<?php if($count==0) echo "default_woo"; else echo "active"; ?>">Template Active</option>

		<?php 

			foreach ($list_template as $key => $template):

						?>

						

						<option <?php if($template->id==absint($page_id)) echo ' selected="selected" '; ?> value="<?php echo $template->id; ?>"><?php echo $template->title; ?></option>

					

						<?php endforeach;?>

		</select><?php	





	}

  

	// SAVE POST

	public function save_woocomposer_meta_data($post_id,$post){

        global $wpdb;

		

		// $post_id and $post are required

		if ( empty( $post_id ) || empty( $post ) ) {

			return;

		}



		// Dont' save meta boxes for revisions or autosaves

		if ( defined( 'DOING_AUTOSAVE' ) || is_int( wp_is_post_revision( $post ) ) || is_int( wp_is_post_autosave( $post ) ) ) {

			return;

		}



		// Check the nonce

		if (empty ( $_POST ['ninja_woocommerce_page_nonce'] ) || ! wp_verify_nonce ( $_POST ['ninja_woocommerce_page_nonce'], 'ninja_woocommerce_page_nonce' )) {

			return;

		}

		

		// Check the post being saved == the $post_id to prevent triggering this call for other save_post events

		if ( empty( $_POST['post_ID'] ) || $_POST['post_ID'] != $post_id ) {

			return;

		}

		// Check user has permission to edit

		if ( ! current_user_can( 'edit_post', $post_id ) ) {

			return;

		}

       

	    	if(!empty($_POST['ninja_woo_page_product'])):

	    		if($_POST['ninja_woo_page_product']=='default_woo'):

	    			delete_post_meta( $post_id, 'ninja_woo_page_product');

	    		else:

	    		update_post_meta( $post_id, 'ninja_woo_page_product', $_POST['ninja_woo_page_product'] );

	    		endif;

	        else:

	        	delete_post_meta( $post_id, 'ninja_woo_page_product');

	        endif;

	   

	}

}



new NINJA_WooComposer_Page_Admin();