<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
	<meta name="description" content="">
	<meta name="author" content="">
	<link rel="icon" href="../../favicon.ico">

	<title>@yield('title', getConfig('name'))</title>

	<!-- Stylesheets -->
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css">
	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">
	<link rel="stylesheet" href="{{ asset('assets/themes/full/js/plugins/sidr/sidr.css') }}">

	<!-- Main Template -->
	<link rel="stylesheet" href="{{ asset('assets/themes/full/css/main.css') }}">

	<!-- Top JS -->
	<!--[if lt IE 9]><script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script><![endif]-->

	@yield('head')

</head>
<body>

	<div id="header">
		<div class="logo-area">
			<a href='' class='sidebar-show visible-xs-block'>
				<i class="fa fa-bars"></i>
			</a>
			<a href="index.html" class="brand sidebar-show">
				{{ getConfig('name') }}
			</a>
		</div>
		<div class="topbarcontent">
			<div class="container-fluid">
				<div class="row">
					<div class="col-sm-6 top_breadcrumbs">
						@yield('breadcrumbs')
					</div>
					<div class="col-sm-6 text-right">
						@yield('liveinfo')
					</div>
				</div>
			</div>
		</div>
	</div>

	<div id="sidebar">
		<div class="user-data">

			<div class="row">
				<div class="col-sm-4">
					<img src='{{ get_gravatar(Auth::user()->email) }}' width="100%" class="img-rounded"/>
				</div>
				<div class="col-sm-8">
					<div class="user-data-name">{{ Auth::user()->name }}</div>
					<div class="user-data-package">{{ Auth::user()->package->name }} Package</div>
				</div>
			</div>

		</div>

		@if (Auth::user()->package->adverts == 1)
		<!-- Advert slot -->
		<div class="ad-slot">
			<a href=''><img src='{{ asset('assets/ads/2.png') }}' /></a>
		</div>
		<!-- /Advert slot -->
		@endif

		<div class="browse-menu">
			<ul>
				<li class='clearfix browser-menu-header'>Your Sites</li>
				@foreach(Auth::user()->sites AS $site) 
				<li class='clearfix {{ crurl('user/site/' . $site->uuid . "/*") }}'><a href='{{ action('User\SiteController@siteDashboard', [$site->uuid]) }}'>{{ $site->name }}</a></li>
				@endforeach
				<li class='clearfix'><a href='{{ action('User\SiteController@createSite') }}'><i class="fa fa-plus"></i>Add a site</a></li>
				@if (isset($site_selected))
				<li class='clearfix browser-menu-header'>Site Navigation</li>
				<li class='clearfix {{ crurl('user/site/' . $site_selected->uuid . "/dashboard") }}'><a href='{{ action('User\SiteController@siteDashboard', $site_selected->uuid) }}'><i class="fa fa-globe"></i>Dashboard</a></li>
				<li class='clearfix {{ crurl('user/site/' . $site_selected->uuid . "/live") }}'><a href='{{ action('User\SiteController@siteLive', $site_selected->uuid) }}'><i class="fa fa-flash"></i>Live Feed</a></li>
				<li class='clearfix'>
					<a href=''><i class="fa fa-users"></i>Visitors<span class="arrow"></span></a>
					<ul class="sub-menu" >		
						<li class=''><a href="{{ action('User\SiteController@siteContent', $site_selected->uuid) }}"> Content </a></li>
						<li class=''><a href="{{ action('User\SiteController@siteTech', $site_selected->uuid) }}"> Technology </a></li>
						<li class=''><a href="{{ action('User\SiteController@siteLocation', $site_selected->uuid) }}"> Locale </a></li>
						<li class=''><a href="{{ action('User\SiteController@siteRefs', $site_selected->uuid) }}"> Referer </a></li>
					</ul>
				</li>
				<li class='clearfix'><a href='{{ action('User\SiteController@siteSettings', $site_selected->uuid) }}'><i class="fa fa-cogs"></i>Site Settings</a></li>
				@endif 
				<li class='clearfix browser-menu-header'>User Navigation</li>
				@if (getConfig('upgrade') == 'true')
				<li class='clearfix {{ crurl('user/upgrade*') }}'><a href='{{ action('User\UserController@showUserUpgrade') }}'><i class="fa fa-cloud-upload"></i>Upgrade</a></li>
				@endif
				@if (Auth::user()->admin == 1)
				<li class='clearfix'><a href='{{ action('Admin\AdminController@showDashboard') }}'><i class="fa fa-anchor"></i>Admin Panel</a></li>
				@endif
				<li class='clearfix'><a href='{{ action('Auth\UserAuthController@logoutSystem') }}'><i class="fa fa-sign-out"></i>Logout</a></li>
			</ul>
		</div>
	</div>

	<div id="content">
		<div class="container-fluid" style="padding: 0">
			@yield('content')
		</div>
	</div>

	<!-- Javascripts -->
	<script src="https://code.jquery.com/jquery-1.10.2.min.js"></script>
	<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>
	<script src="{{ asset('assets/themes/full/js/plugins/sidr/sidr.js') }}"></script>
	<script src="{{ asset('assets/themes/full/js/app.js') }}"></script>

	@yield('page-end')

</body>
</html>