@extends('themes.full.user_master')

@section('breadcrumbs')
<ol class="breadcrumb">
	<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
	<li><a href="{{ action('User\UserController@showUserUpgrade') }}">Upgrade Account</a></li>
	<li class="active">Payment</li>
</ol>
@endsection

@section('content')

<div class="smaller-hero">
	<h3>Upgrade your account - Payment</h3>
	<p class="message">You are currently on the {{ Auth::user()->package->name }} Package</p>
</div>

<div class="padding">
	<div class="row">

		<div class="col-sm-4">

			<!-- item -->
			<div class="">
				<div class="plan">
					<div class="head">
						<h2>{{ $package->name }}</h2>
					</div>  
					<ul class="item-list">
						<li>@if ($package->adverts == 1) <strong>Adverts</strong> Displayed @else <strong>No</strong> Adverts @endif</li>
						<li>@if ($package->daily_hits == 0) <strong>&infin;</strong> @else <strong>{{ $package->daily_hits }}</strong> @endif Daily Hits</li>
						<li>@if ($package->history == 0) <strong>&infin;</strong> @else <strong>{{ $package->history }}</strong> @endif Days History</li>
						<li>@if ($package->sites == 0) <strong>&infin;</strong> @else <strong>{{ $package->sites }}</strong> @endif Site/s</li>
					</ul>

					<div class="price">
						@if ($package->cost == "0")
						<h3>Free</h3>
						<h4>&nbsp;</h4>
						@else
						<h3><span class="symbol">$</span>{{ number_format($package->cost, 2) }}</h3>
						<h4>{{ $package->time_period }}</h4>
						@endif
					</div>

					@if (Auth::user()->package_id == $package->id)
					<a class="btn btn-default" href="#">This is your current Package</a>
					@else
					<a class="btn btn-success" href="{{ action('User\UserController@showUserUpgradePayment', $package->name_slug) }}">Select <strong>{{ $package->name }}</strong></a>
					@endif

				</div>
			</div>
			<!-- /item -->

		</div>
		<div class="col-md-8">

			@if (isset($error))
			<div class="alert alert-danger">
				{!! $error !!}
			</div>
			@endif

			@if (Auth::user()->current_package_subscription != "")
			<div class="alert alert-warning">
				<p><strong>You already have a subscription</strong></p>
				<p>By choosing a new package, we'll cancel your previous subscription ({{ Auth::user()->package->name }})</p>
			</div>
			@endif

			@if ($package->cost == "0")

			<div class="panel">
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Upgrade <strong>Account</strong></h3>
						</div>
					</div>
				</div>
				<div class="panel-body">

					<p>As there is no cost for this package, click the button below to process your account into this package instantly.</p>
					<p>&nbsp;</p>

					<form id="checkout" method="post">
						{{ csrf_field() }}
						<input type="submit" value="Move to {{ $package->name }} package" class="btn btn-info">
					</form>

				</div>
			</div>

			@else

			<div class="panel">
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Upgrade <strong>Account</strong></h3>
							<small>All upgrades are done instantly on payment</small>
						</div>
					</div>
				</div>
				<div class="panel-body">

					<form id="checkout" method="post">
						{{ csrf_field() }}
						<div id="payment-form"></div>

						@if ($package->time_period == "One-off Payment")
						<input type="submit" value="Pay ${{ number_format($package->cost, 2) }}" class="btn btn-info">
						@else 
						<input type="submit" value="Setup subscription and pay ${{ number_format($package->cost, 2) }} now" class="btn btn-info">
						@endif

					</form>

				</div>
			</div>

			@endif

		</div>

	</div>
</div>

@endsection

@section('page-end')
@parent

@if ($package->cost != "0")
<script src="https://js.braintreegateway.com/js/braintree-2.22.1.min.js"></script>
<script>
// We generated a client token for you so you can test out this code
// immediately. In a production-ready integration, you will need to
// generate a client token on your server (see section below).
var clientToken = "{{ $token }}";

braintree.setup(clientToken, "dropin", {
	container: "payment-form"
});
</script>
@endif

@endsection