@extends('themes.full.user_master')

@section('breadcrumbs')
<ol class="breadcrumb">
	<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
	<li class="active">Upgrade Account</li>
</ol>
@endsection

@section('content')

<div class="smaller-hero">
	<h3>Upgrade your account</h3>
	<p class="message">You are currently on the {{ Auth::user()->package->name }} Package</p>
</div>


<div class="padding">
	<div class="row">
		<div class="col-sm-12">

			@if (session()->get('success') != null)
			<div class="alert alert-success">
				{!! session()->get('success') !!}
			</div>
			@endif

			@if (Auth::user()->current_package_subscription != "")
			<div class="alert alert-warning">
				<p><strong>You already have a subscription</strong></p>
				<p>By choosing a new package, we'll cancel your previous subscription ({{ Auth::user()->package->name }})</p>
			</div>
			@endif

			<!-- Plans -->
			<section id="plans">
				<div class="row">

					<?php

                    $col_size = 4;
                    if (count($packages) % 4 == 0) {
                        $col_size = 3;
                    }

                    ?>

					@foreach($packages AS $package)
					<!-- item -->
					<div class="col-sm-{{ $col_size }}">
						<div class="plan">
							<div class="head">
								<h2>{{ $package->name }}</h2>
							</div>  
							<ul class="item-list">
								<li>@if ($package->adverts == 1) <strong>Adverts</strong> Displayed @else <strong>No</strong> Adverts @endif</li>
								<li>@if ($package->daily_hits == 0) <strong>&infin;</strong> @else <strong>{{ $package->daily_hits }}</strong> @endif Daily Hits</li>
								<li>@if ($package->history == 0) <strong>&infin;</strong> @else <strong>{{ $package->history }}</strong> @endif Days History</li>
								<li>@if ($package->sites == 0) <strong>&infin;</strong> @else <strong>{{ $package->sites }}</strong> @endif Site/s</li>
							</ul>

							<div class="price">
								@if ($package->cost == "0")
								<h3>Free</h3>
								<h4>&nbsp;</h4>
								@else
								<h3><span class="symbol">$</span>{{ number_format($package->cost, 2) }}</h3>
								<h4>{{ $package->time_period }}</h4>
								@endif
							</div>

							@if (Auth::user()->package_id == $package->id)
							<a class="btn btn-default" href="#">This is your current Package</a>
							@else
							<a class="btn btn-success" href="{{ action('User\UserController@showUserUpgradePayment', $package->name_slug) }}">Select <strong>{{ $package->name }}</strong></a>
							@endif

						</div>
					</div>
					<!-- /item -->
					@endforeach

				</div>
			</section>

		</div>
	</div>
</div>

@endsection