@extends('themes.full.user_master')

@section('breadcrumbs')
<ol class="breadcrumb">
	<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
	<li><a href="{{ action('User\SiteController@siteDashboard', $site->uuid) }}">{{ $site->name }}</a></li>
	<li class="active">Technology</li>
</ol>
@endsection

@section('content')

<div class="smaller-hero">
	<h3>{{ $site->name }}</h3>
	<p class="message"><i class="fa fa-link"></i>&nbsp;&nbsp;<a href='{{ $site->url }}' target="_blank">{{ $site->url }}</a></p>
</div>

<div class="padding">
	<div class="row">

		<div class="col-sm-4">
			<div class="panel">
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Change <strong>Date of Reports</strong></h3>
						</div>
					</div>
				</div>
				<div class="panel-body">
					@include("themes.full.user.site.live_data")
				</div>
			</div>
		</div>

		<div class="col-sm-8">

			<div class="panel">
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Top <strong>Technology - Browsers</strong></h3>
							<small>Browsers are the software your users use to visit your website</small>
						</div>
					</div>
				</div>
				<div class="panel-table">
					<table class="table">
						<thead>
							<tr>
								<th width="50%">Browser</th>
								<th class="text-right">Views</th>
								<th class="text-right">Visitors</th>
								<th class="text-right">Avg Time</th>
							</tr>
						</thead>
						<tbody>
							@foreach($site->getMetric($report['start_format'], $report['end_format'], 0, 'browser_name') AS $row)
							<?php $stats = $site->getContentStats($report['start_format'], $report['end_format'], 'browser_name', $row->browser_name); ?>
							<tr>
								<td>{{ $row->browser_name }}</td>
								<td class="text-right">{{ number_format($row->total_hits, 0) }}</td>
								<td class="text-right">{{ $stats['visitors'] }}</td>
								<td class="text-right">{{ secs_to_human($stats['avg']) }}</td> 
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>

			<div class="row">

				<div class="col-sm-6">
					<div class="panel">
						<div class="panel-header">
							<div class="row">
								<div class="col-sm-9">
									<h3>Top <strong>Technology - Resolutions</strong></h3>
									<small>The resolution is the size of the monitor your user has used to view your website</small>
								</div>
							</div>
						</div>
						<div class="panel-table">
							<table class="table">
								<thead>
									<tr>
										<th>Resolution</th>
										<th class="text-right">Actions</th>
									</tr>
								</thead>
								<tbody>
									@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'resolution') AS $r)
									<tr>
										<td>{{ $r->resolution }}</td>
										<td class="text-right">{{ number_format($r->total_hits, 0) }}</td>
									</tr>
									@endforeach
								</tbody>
							</table>
						</div>
					</div>
				</div>

				<div class="col-sm-6">
					<div class="panel">
						<div class="panel-header">
							<div class="row">
								<div class="col-sm-9">
									<h3>Top <strong>Devices</strong></h3>
									<small>This the type of computer the user has used to view your website</small>
								</div>
							</div>
						</div>
						<div class="panel-table">
							<table class="table">
								<thead>
									<tr>
										<th>Device</th>
										<th class="text-right">Actions</th>
									</tr>
								</thead>
								<tbody>
									@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'device') AS $r)
									<tr>
										<td>{{ $r->device }}</td>
										<td class="text-right">{{ number_format($r->total_hits, 0) }}</td>
									</tr>
									@endforeach
								</tbody>
							</table>
						</div>
					</div>
				</div>

			</div>
		</div>

	</div>
</div>

@endsection