@extends('themes.full.user_master')

@section('breadcrumbs')
<ol class="breadcrumb">
	<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
	<li><a href="#">Sites</a></li>
	<li class="active">Add a site</li>
</ol>
@endsection

@section('content')

<div class="smaller-hero">
	<h3>{{ $site->name }}</h3>
	<p class="message"><i class="fa fa-link"></i>&nbsp;&nbsp;<a href='{{ $site->url }}' target="_blank">{{ $site->url }}</a></p>
</div>

<div class="padding">
	<div class="row">
		<div class="col-sm-6">

			<div class="panel"> 
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Site <strong>Embed Code</strong></h3>
							<small>Make sure this is on all your websites pages</small>
						</div>
					</div>
				</div>
				<div class="panel-body">

					<textarea class="form-control" rows="12" readonly><!-- Tracking -->
<script type="text/javascript">
	var jTrack = jTrack || {};
	jTrack.key = "{{ $site->uuid }}";
	jTrack.collector = "{{ action('API\APIController@visitBeacon', str_random(5) . ".png") }}";
	(function() {
		var sf = document.createElement("script"), script = document.getElementsByTagName("script")[0];
		sf.type = "text/javascript"; sf.async = true; sf.src = "{{ action('API\APIController@sendJS', str_random(5) . ".js") }}";
		script.parentNode.insertBefore(sf, script);
	})();
</script>
					</textarea>

				</div>
			</div>

		</div>
		<div class="col-sm-6">

			<div class="panel"> 
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Change <strong>Site Information</strong></h3>
							<small>Edit your website</small>
						</div>
					</div>
				</div>
				<div class="panel-body">

					@if (count($errors) > 0)
					<div class="alert alert-danger">
						<p><strong>There was a problem editing your site.</strong></p>
						<ul style="margin-top: 10px">
							@foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
					@endif

					@if (isset($success))
					<div class="alert alert-success">
						{!! $success !!}
					</div>
					@endif

					<form method="POST">

						{{ csrf_field() }}

						<div class="form-group">
							<label for="exampleInputEmail1">Site Name</label>
							<input type="text" name="name" class="form-control" id="exampleInputEmail1" placeholder="" value="{{ $site->name }}">
						</div>

						<div class="form-group">
							<label for="exampleInputPassword1">Site URL</label>
							<input type="text" name="url" class="form-control" id="exampleInputPassword1" placeholder="Include http://" value="{{ $site->url }}">
						</div>

						<div class="form-group">
							<label for="exampleInputPassword1">Site Timezone</label>
							<select class="form-control select2" name="timezone">
								@foreach(tz_list() AS $t)
								<option value="{{ $t['zone'] }}" @if($site->timezone == $t['zone']) selected @endif>{{ $t['diff_from_GMT'] . ' - ' . $t['zone'] }}</option>
								@endforeach
							</select>
						</div>

						<hr />

						<div class="row">
							<div class="col-sm-6">
								<button type="submit" class="btn btn-info">Save this site</button>
							</div>
						</div>

					</form>

				</div>
			</div>

			<div class="panel"> 
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3><strong>Delete</strong> your website</h3>
						</div>
					</div>
				</div>
				<div class="panel-body">

					<p>By deleteing this site you will be deleting all the data contained for this site, and the site itself. This process is final, there is no way to get back deleted data.</p>
					<hr />
					<a href='{{ action('User\SiteController@siteDelete', $site->uuid) }}' class="btn btn-danger" onclick="return confirm('There is no system to bring back deleted data - please be sure before you click OK.')">I am sure, delete this site</a>
				</div>
			</div>


		</div>
	</div>

</div>
</div>
</div>
@stop

@section('head')
<link href='https://select2.github.io/dist/css/select2.min.css' rel="stylesheet">
<link href='https://select2.github.io/select2-bootstrap-theme/css/select2-bootstrap.css' rel="stylesheet">
@stop

@section('page-end')
<script src='https://select2.github.io/dist/js/select2.min.js'></script>
<script>
	$(document).ready(function() { 
		$(".select2").select2({
			theme: "bootstrap"
		}); 
	});
</script>
@stop