@extends('themes.full.user_master')

@section('breadcrumbs')
<ol class="breadcrumb">
	<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
	<li><a href="{{ action('User\SiteController@siteDashboard', $site->uuid) }}">{{ $site->name }}</a></li>
	<li class="active">Dashboard</li>
</ol>
@endsection

@section('content')

<div class="smaller-hero">
	<h3>{{ $site->name }}</h3>
	<p class="message"><i class="fa fa-link"></i>&nbsp;&nbsp;<a href='{{ $site->url }}' target="_blank">{{ $site->url }}</a></p>
</div>

<div class="padding">
	<div class="row">
		<div class="col-sm-6">

			<div class="panel">
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Change <strong>Date of Reports</strong></h3>
						</div>
					</div>
				</div>
				<div class="panel-body">
					@include("themes.full.user.site.live_data")
				</div>
			</div>

			<div class="panel">
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Basic <strong>Statistics</strong></h3>
							<small>Quick view of your most important statistics</small>
						</div>
					</div>
				</div>
				<div class="panel-body">

					<div class="col-md-6 col-lg-3">
						<div class="stat">
							<span>Visitors</span>
							{{ number_format($site->getVisitorDateRange($report['start_format'], $report['end_format']), 0) }}
						</div>
					</div>

					<div class="col-md-6 col-lg-3">
						<div class="stat">
							<span>Actions</span>
							{{ number_format($site->getHitsDateRange($report['start_format'], $report['end_format']), 0) }}
						</div>
					</div>

					<div class="col-md-6 col-lg-3">
						<div class="stat">
							<span>Actions / Visitor</span>
							{{ $site->getHitsPerVisit($report['start_format'], $report['end_format']) }}
						</div>
					</div>

					<div class="col-md-6 col-lg-3">
						<div class="stat">
							<span>Average time on site</span>
							{{ secs_to_human($site->getAvgTimeOnSite($report['start_format'], $report['end_format'])) }}
						</div>
					</div>

				</div>
			</div>

			<div class="row">
				<div class="col-sm-6">

					<div class="panel">
						<div class="panel-header">
							<div class="row">
								<div class="col-sm-9">
									<h3>Top <strong>Device Use</strong></h3>
								</div>
							</div>
						</div>
						<div class="panel-table">
							<table class="table">
								<thead>
									<tr>
										<th>Device</th>
										<th>Actions</th>
									</tr>
								</thead>
								<tbody>
									@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'device') AS $r)
									<tr>
										<td>{{ $r->device }}</td>
										<td>{{ number_format($r->total_hits, 0) }}</td>
									</tr>
									@endforeach
								</tbody>
							</table>
						</div>
					</div>

				</div>
				<div class="col-sm-6">

					<div class="panel">
						<div class="panel-header">
							<div class="row">
								<div class="col-sm-9">
									<h3>Top <strong>Locations</strong></h3>
								</div>
							</div>
						</div>
						<div class="panel-table">
							<table class="table">
								<thead>
									<tr>
										<th>Location</th>
										<th>Actions</th>
									</tr>
								</thead>
								<tbody>
									@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'country') AS $r)
									<tr>
										<td>{{ $r->country }}</td>
										<td>{{ number_format($r->total_hits, 0) }}</td>
									</tr>
									@endforeach
								</tbody>
							</table>
						</div>
					</div>

				</div>
			</div>

		</div>
		<div class="col-sm-6">

			<div class="panel">
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Page <strong>Actions</strong></h3>
							<small>Graph of page actions by date</small>
						</div>
					</div>
				</div>
				<div class="panel-body">
					<div id="myfirstchart" style="height: 250px;"></div>
				</div>
			</div>

			<div class="panel">
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Top <strong>Referers</strong></h3>
							<small>A referer is a website your visitors have come from</small>
						</div>
					</div>
				</div>
				<div class="panel-table">
					<table class="table">
						<thead>
							<tr>
								<th width="50%">Referer</th>
								<th class="text-right">Actions</th>
								<th class="text-right">Visitors</th>
								<th class="text-right">Avg Time</th>
							</tr>
						</thead>
						<tbody>
							@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'referer_url') AS $row)
							<?php $stats = $site->getContentStats($report['start_format'], $report['end_format'], 'referer_url', $row->referer_url); ?>
							<tr>
								<td>
								@if ($row->referer_url == '')
								Direct or no Referer
								@else
								{{ $row->referer_url }}
								@endif
								</td>
								<td class="text-right">{{ number_format($row->total_hits, 0) }}</td>
								<td class="text-right">{{ $stats['visitors'] }}</td>
								<td class="text-right">{{ secs_to_human($stats['avg']) }}</td>
							</tr>
							@endforeach
						</tbody>
					</table>
				</div>
			</div>

		</div>
	</div>
</div>

@endsection

@section('head')
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.css">
@endsection

@section('page-end')
@parent
<script src="//cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/morris.js/0.5.1/morris.min.js"></script>
<script>
	new Morris.Line({
		element: 'myfirstchart',
		data: [
		@foreach($site->arrayDatesMethod($report['start_format'], $report['end_format'], "1 day", "getHitsDateRange") AS $date => $v)
		{ year: '{{ $date }}', value: {{ $v }} },
		@endforeach
		],
		xkey: 'year',
		ykeys: ['value'],
		labels: ['Value']
	});
</script>
@endsection