@extends('themes.full.user_master')

@section('breadcrumbs')
<ol class="breadcrumb">
	<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
	<li><a href="#">Sites</a></li>
	<li class="active">Add a site</li>
</ol>
@endsection

@section('content')

<div class="padding">
	<div class="row">
		<div class="col-sm-7">

			<div class="panel"> 
				<div class="panel-header">
					<div class="row">
						<div class="col-sm-9">
							<h3>Create a <strong>Site</strong></h3>
							<small>You can create a new site to collect data from here</small>
						</div>
					</div>
				</div>
				<div class="panel-body">

					@if (count($errors) > 0)
					<div class="alert alert-danger">
						<p><strong>There was a problem creating your site.</strong></p>
						<ul style="margin-top: 10px">
							@foreach ($errors->all() as $error)
							<li>{{ $error }}</li>
							@endforeach
						</ul>
					</div>
					@endif

					@if (isset($success))
					<div class="alert alert-success">
						{!! $success !!}
					</div>
					@endif

					<form method="POST">

						{{ csrf_field() }}

						<div class="form-group">
							<label for="exampleInputEmail1">Site Name</label>
							<input type="text" name="name" class="form-control" id="exampleInputEmail1" placeholder="" value="{{ old('name') }}">
						</div>

						<div class="form-group">
							<label for="exampleInputPassword1">Site URL</label>
							<input type="text" name="url" class="form-control" id="exampleInputPassword1" placeholder="Include http://" value="{{ old('url') }}">
						</div>

						<div class="form-group">
							<label for="exampleInputPassword1">Site Timezone</label>
							<select class="form-control select2" name="timezone">
								@foreach(tz_list() AS $t)
								<option value="{{ $t['zone'] }}">{{ $t['diff_from_GMT'] . ' - ' . $t['zone'] }}</option>
								@endforeach
							</select>
						</div>

						<div class="row">
							<div class="col-sm-6">
								<button type="submit" class="btn btn-default">Create this site</button>
							</div>
						</div>

					</form>


				</div>
			</div>

		</div>
	</div>
</div>
@stop

@section('head')
<link href='https://select2.github.io/dist/css/select2.min.css' rel="stylesheet">
<link href='https://select2.github.io/select2-bootstrap-theme/css/select2-bootstrap.css' rel="stylesheet">
@stop

@section('page-end')
<script src='https://select2.github.io/dist/js/select2.min.js'></script>
<script>
$(document).ready(function() { 
	$(".select2").select2({
		theme: "bootstrap"
	}); 
});
</script>
@stop