@extends('themes.full.user_master')

@section('content')

<div class="welcome-hero">
	<h3>Welcome back, <strong>{{ Auth::user()->name }}</strong>.</h3>
	<p class="message">You have {{ count(Auth::user()->sites) }} active, running sites</p>
</div>

<div class="padding">
	@if (session()->get('warning') != null)
	<div class="alert alert-warning">
		{!! session()->get('warning') !!}
	</div>
	@endif

	<div class="panel">
		<div class="panel-header">
			<div class="row">
				<div class="col-sm-9">
					<h3>Your <strong>Sites</strong></h3>
					<small>A list of all your sites, and some basic informaiton</small>
				</div>
			</div>
		</div>
		<div class="panel-table">

			<table class="table">
				<thead>
					<tr>
						<th width="60%">Site Name</th>
						<th class="text-right">Live</th>
						<th class="text-right">Visitors</th>
						<th class="text-right">Actions</th>
					</tr>
				</thead>
				<tbody>

					@if (count(Auth::user()->sites) == 0)

					<tr>
						<td colspan="4">You have no sites. Click <a href='{{ action('User\SiteController@createSite') }}'>here</a> to create one.</td>
					</tr>

					@else

					@foreach(Auth::user()->sites AS $site)
					<?php 

                    $visitors = $site->arrayDatesMethod(date("Y-m-d", strtotime("-7 days")), date("Y-m-d"), '1 day', 'getVisitorDateRange');
                    $actions = $site->arrayDatesMethod(date("Y-m-d", strtotime("-7 days")), date("Y-m-d"), '1 day', 'getHitsDateRange');

                    ?>
					<tr>
						<td><a href='{{ action('User\SiteController@siteDashboard', $site->uuid) }}'>{{ $site->name }}</a></td>
						<td class="text-right">{{ $site->getLiveVisitors() }}</td>
						<td class="text-right">{{ $site->getVisitorDateRange() }} today <span class="inlinesparkline">{{ implode(",", $visitors) }}</span></td>
						<td class="text-right">{{ $site->getHitsDateRange() }} today <span class="inlinesparkline">{{ implode(",", $actions) }}</span></td>
					</tr>
					@endforeach

					@endif

				</tbody>
			</table>


		</div>
	</div>

</div>
@stop

@section('page-end')
<script src='{{ asset('assets/themes/basic/js/sparkline.min.js') }}'></script>
<script>
	$(function() {

		$('.inlinesparkline').sparkline('html', {
			defaultPixelsPerValue: 8
		}); 

	});
</script>
@stop