@extends('themes.full.front_master')

@section('content')
<div class="hero">
	<div class="container">
		<div class="row">
			<div class="col-sm-5 hero-padding">
				<h1>Mission Control for your website</h1>
				<h2>Take control of your website with beautifully simple, yet powerful analytics.</h2>
				<p><a class="btn btn-primary" href="{{ action('Auth\UserAuthController@loginSystem') }}" role="button">Get started</a></p>
			</div>

			<div class="col-sm-6 col-sm-offset-1">
				<img src='{{ asset('assets/themes/full/front/screen.png') }}' width="100%">
			</div>

		</div>
	</div>
</div>

<div class="info">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<h3>Features</h3>
			</div>
		</div>
		<div class="row">
			<div class="col-sm-4 front-info">
				<h4>Live Reporting</h4>
				<img src='{{ asset('assets/themes/full/front/screen.png') }}' width="60%" />
				<h5>Realtime</h5>
				<p>We give you live visitor information. No waiting for reports.</p>
			</div>
			<div class="col-sm-4 front-info">
				<h4>Responsive</h4>
				<img src='{{ asset('assets/themes/full/front/mobile.png') }}' width="60%" />
				<h5>Mobile First</h5>
				<p>Get your stats on the move with our responsive, mobile first design.</p>
			</div>
			<div class="col-sm-4 front-info">
				<h4>Data</h4>
				<img src='{{ asset('assets/themes/full/front/data.png') }}' width="60%" />
				<h5>Information</h5>
				<p>We put all your data such as browsers, pages, devices etc at your finger tips fast!</p>
			</div>
		</div>
	</div>
</div>

<div class="hero-smaller">
	<div class="container">
		<div class="row">
			<div class="col-sm-8 col-sm-offset-2">

				<h4>Take control of your analytics now.</h1>
				<p><a class="btn btn-primary" href="{{ action('Auth\UserAuthController@loginSystem') }}" role="button">Get started for free</a></p>
				<h5>It takes less than 60 seconds to setup your site with our easy to use embed code. Try us now!</h2>

			</div>
		</div>
	</div>
</div>

@if (getConfig('upgrade') == 'true')
<div class="info" id="pricing">
	<div class="container">
		<div class="row">
			<div class="col-sm-12">
				<h3>Pricing</h3>
			</div>
		</div>

		<!-- Plans -->
		<section id="plans">
			<div class="row">

				<?php

                $col_size = 4;
                if (count($packages) % 4 == 0) {
                    $col_size = 3;
                }

                ?>

				@foreach($packages AS $package)
				<!-- item -->
				<div class="col-sm-{{ $col_size }}">
					<div class="plan">
						<div class="head">
							<h2>{{ $package->name }}</h2>
						</div>  
						<ul class="item-list">
							<li>@if ($package->adverts == 1) <strong>Adverts</strong> Displayed @else <strong>No</strong> Adverts @endif</li>
							<li>@if ($package->daily_hits == 0) <strong>&infin;</strong> @else <strong>{{ $package->daily_hits }}</strong> @endif Daily Hits</li>
							<li>@if ($package->history == 0) <strong>&infin;</strong> @else <strong>{{ $package->history }}</strong> @endif Days History</li>
							<li>@if ($package->sites == 0) <strong>&infin;</strong> @else <strong>{{ $package->sites }}</strong> @endif Site/s</li>
						</ul>

						<div class="price">
							@if ($package->cost == "0")
							<h3>Free</h3>
							<h4>&nbsp;</h4>
							@else
							<h3><span class="symbol">$</span>{{ number_format($package->cost, 2) }}</h3>
							<h4>{{ $package->time_period }}</h4>
							@endif
						</div>

					</div>
				</div>
				<!-- /item -->
				@endforeach

			</div>
		</section>
		<!-- /Plans -->

	</div>
</div>
@endif
<div class="footer">
	<div class="container">
		<div class="col-sm-6">
			&copy; {{ getConfig('name') . " &middot; " . date("Y") }}
		</div>
		<div class="col-sm-6 text-right">
			<a href=''>WRanalytics by Wild Rocket</a>
		</div>
	</div>
</div>

@stop