<!DOCTYPE html>
<html lang="en">
<head>

	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
	<meta name="description" content="">
	<meta name="author" content="">
	<link rel="icon" href="../../favicon.ico">

	<title>@yield('title', getConfig('name'))</title>

	<!-- Stylesheets -->
	<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css">
	<link rel="stylesheet" href="//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css">
	<link rel="stylesheet" href="{{ asset('assets/themes/full/js/plugins/sidr/sidr.css') }}">

	<!-- Main Template -->
	<link rel="stylesheet" href="{{ asset('assets/themes/full/css/front.css') }}">

	<!-- Top JS -->
	<!--[if lt IE 9]><script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script><![endif]-->

	@yield('head')

</head>
<body>

	<div class="header">
		<div class="container">
			<div class="col-xs-8 col-sm-4">
				<h1>{{ getConfig('name') }}</h1>
			</div>
			<div class="col-xs-4 col-sm-8">
				<div id="mainnav">
					<ul class="top-nav hidden-sm hidden-xs">
						<li class="{{ crurl('/') }}"><a href='{{ url('/') }}'>Main</a></li>
						<li class="{{ crurl('auth/login') }}"><a href='{{ action('Auth\UserAuthController@loginSystem') }}'>Login</a></li>
						@if (getConfig('registration') == 'true')
						<li class="{{ crurl('auth/register') }}"><a href='{{ action('Auth\UserAuthController@registerSystem') }}'>Register</a></li>
						@endif
						@if (getConfig('upgrade') == 'true')
						<li><a href='{{ url('/') }}#pricing'>Pricing</a></li>
						@endif
					</ul>
				</div>
				<div class="visible-xs-block visible-sm-block text-right">
					<a id="simple-menu" href="#mainnav"><i class="fa fa-bars"></i></a>
				</div>
			</div>
		</div>
	</div>

	@yield('content')

	<!-- Include jQuery -->
	<script src="//cdn.jsdelivr.net/jquery/2.2.0/jquery.min.js"></script>
	<!-- Include the Sidr JS -->
	<script src="//cdn.jsdelivr.net/jquery.sidr/2.2.1/jquery.sidr.min.js"></script>
	<script>
		$(document).ready(function() {
			$('#simple-menu').sidr({
				name: 'sidr-main',
				source: '#mainnav'
			});
		});
	</script>

</body>
</html>