@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-3">
		@include('themes.basic.user.sidebar')
	</div>
	<div class="col-sm-9">

		<ol class="breadcrumb">
			<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
			<li class="active">Upgrade Account</li>
		</ol>

		<div class="page-header">
			<h1>Upgrade your Account - Payment</h1>
		</div>

		<div class="row">
			<div class="col-md-4">
				<!-- Plans -->
				<section id="plans">
					<div class="row">

						<!-- item -->
						<div class="col-md-12 text-center">
							<div class="panel panel-info panel-pricing">
								<div class="panel-heading">
									<i class="fa fa-desktop"></i>
									<h3>{{ $package->name }}</h3>
								</div>
								<div class="panel-body text-center">
									<p><strong>{{ $package->costString() }}</strong></p>
								</div>
								<ul class="list-group text-center">
									<li class="list-group-item">@if ($package->adverts == 1) Adverts @else No Adverts @endif</li>
									<li class="list-group-item">@if ($package->daily_hits == 0) &infin; @else {{ $package->daily_hits }} @endif Daily Hits</li>
									<li class="list-group-item">@if ($package->history == 0) &infin; @else {{ $package->history }} @endif Days History</li>
									<li class="list-group-item">@if ($package->sites == 0) &infin; @else {{ $package->sites }} @endif Site/s</li>
								</ul>
							</div>
						</div>
						<!-- /item -->

					</div>
				</section>
				<!-- /Plan -->				
			</div>		
			<div class="col-md-8">

				@if (isset($error))
				<div class="alert alert-danger">
					{!! $error !!}
				</div>
				@endif

				@if (Auth::user()->current_package_subscription != "")
					<div class="alert alert-info">
						<p><strong>You already have a subscription</strong></p>
						<p>By choosing a new package, we'll cancel your previous subscription ({{ Auth::user()->package->name }})</p>
					</div>
				@endif

				@if ($package->cost == "0")
				<p>As there is no cost for this package, click the button below to process your account into this package instantly.</p>
				<p>&nbsp;</p>

				<form id="checkout" method="post">
					{{ csrf_field() }}
					<input type="submit" value="Move to {{ $package->name }} package" class="btn btn-info">
				</form>

				@else

				<form id="checkout" method="post">
					{{ csrf_field() }}
					<div id="payment-form"></div>

					@if ($package->time_period == "One-off Payment")
					<input type="submit" value="Pay ${{ number_format($package->cost, 2) }}" class="btn btn-info">
					@else 
					<input type="submit" value="Setup subscription and pay ${{ number_format($package->cost, 2) }} now" class="btn btn-info">
					@endif

				</form>

				@endif
			</div>
		</div>

	</div>
</div>

@endsection

@section('page-end')
@parent

@if ($package->cost != "0")
<script src="https://js.braintreegateway.com/js/braintree-2.22.1.min.js"></script>
<script>
// We generated a client token for you so you can test out this code
// immediately. In a production-ready integration, you will need to
// generate a client token on your server (see section below).
var clientToken = "{{ $token }}";

braintree.setup(clientToken, "dropin", {
	container: "payment-form"
});
</script>
@endif

@endsection