@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-3">
		@include('themes.basic.user.sidebar') 
	</div>
	<div class="col-sm-9">

		<ol class="breadcrumb">
			<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
			<li class="active">Upgrade Account</li>
		</ol>

		<div class="page-header">
			<h1>Upgrade your Account</h1>
		</div>

		<div class="row">
			<div class="col-md-12">

				@if (session()->get('success') != null)
				<div class="alert alert-success">
					{!! session()->get('success') !!}
				</div>
				@endif

				@if (Auth::user()->current_package_subscription != "")
					<div class="alert alert-info">
						<p><strong>You already have a subscription</strong></p>
						<p>By choosing a new package, we'll cancel your previous subscription ({{ Auth::user()->package->name }})</p>
					</div>
				@endif

				<!-- Plans -->
				<section id="plans">
					<div class="row">

						<?php

                        $col_size = 6;
                        if (count($packages) % 3 == 0) {
                            $col_size = 4;
                        }

                        ?>

						@foreach($packages AS $package)
						<!-- item -->
						<div class="col-sm-{{ $col_size }} text-center">
							<div class="panel @if (Auth::user()->package_id == $package->id) panel-info @else panel-success @endif panel-pricing">
								<div class="panel-heading">
									<i class="fa fa-desktop"></i>
									<h3>{{ $package->name }}</h3>
								</div>
								<div class="panel-body text-center">
									<p><strong>{{ $package->costString() }}</strong></p>
								</div>
								<ul class="list-group text-center">
									<li class="list-group-item">@if ($package->adverts == 1) Adverts @else No Adverts @endif</li>
									<li class="list-group-item">@if ($package->daily_hits == 0) &infin; @else {{ $package->daily_hits }} @endif Daily Hits</li>
									<li class="list-group-item">@if ($package->history == 0) &infin; @else {{ $package->history }} @endif Days History</li>
									<li class="list-group-item">@if ($package->sites == 0) &infin; @else {{ $package->sites }} @endif Site/s</li>
								</ul>
								<div class="panel-footer">	
									@if (Auth::user()->package_id == $package->id)
									<a class="btn btn-block btn-info" href="#">Current Package</a>
									@else
									<a class="btn btn-block btn-success" href="{{ action('User\UserController@showUserUpgradePayment', $package->name_slug) }}">Select <strong>{{ $package->name }}</strong></a>
									@endif
								</div>
							</div>
						</div>
						<!-- /item -->
						@endforeach

					</div>
				</section>

				
			</div>		
		</div>

	</div>
</div>

@stop

@section('head')
@endsection

@section('page-end')
@parent

@endsection