@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-3">
		@include('themes.basic.user.sidebar')
	</div>
	<div class="col-sm-9">

		<ol class="breadcrumb">
			<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
			<li><a href="{{ action('User\SiteController@siteDashboard', $site->uuid) }}">{{ $site->name }}</a></li>
			<li class="active">Locations</li>
		</ol>

		@include('themes.basic.user.site.live_ribbon')

		<div class="page-header">
			<h1>Technology - Browsers</h1>
		</div>

		<div class="row">

			<div class="col-md-12">
				<div class="panel panel-default">	
					<div class="panel-heading">Browsers</div>
					<table class="table">
						<thead>
							<tr>
								<th width="50%">Browser</th>
								<th class="text-right">Views</th>
								<th class="text-right">Visitors</th>
								<th class="text-right">Avg Time</th>
							</tr>
						</thead>
						<tbody>
						@foreach($site->getMetric($report['start_format'], $report['end_format'], 0, 'browser_name') AS $row)
						<?php $stats = $site->getContentStats($report['start_format'], $report['end_format'], 'browser_name', $row->browser_name); ?>
						<tr>
							<td>{{ $row->browser_name }}</td>
							<td class="text-right">{{ number_format($row->total_hits, 0) }}</td>
							<td class="text-right">{{ $stats['visitors'] }}</td>
							<td class="text-right">{{ secs_to_human($stats['avg']) }}</td> 
						</tr>
						@endforeach
						</tbody>
					</table>
				</div>
			</div>	

			<div class="col-md-6">
				<div class="panel panel-default">	
					<div class="panel-heading">Top Resolutions</div>
					<table class="table">
						<thead>
							<tr>
								<th>Resolution</th>
								<th class="text-right">Actions</th>
							</tr>
						</thead>
						<tbody>
						@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'resolution') AS $r)
							<tr>
								<td>{{ $r->resolution }}</td>
								<td class="text-right">{{ number_format($r->total_hits, 0) }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
			</div>

			<div class="col-md-6">
				<div class="panel panel-default">	
					<div class="panel-heading">Top Devices</div>
					<table class="table">
						<thead>
							<tr>
								<th>Device</th>
								<th class="text-right">Actions</th>
							</tr>
						</thead>
						<tbody>
						@foreach($site->getMetric($report['start_format'], $report['end_format'], 5, 'device') AS $r)
							<tr>
								<td>{{ $r->device }}</td>
								<td class="text-right">{{ number_format($r->total_hits, 0) }}</td>
							</tr>
						@endforeach
						</tbody>
					</table>
				</div>
			</div>		

		</div>

	</div>
</div>

@stop