@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-3">
		@include('themes.basic.user.sidebar')
	</div>
	<div class="col-sm-9">

		<ol class="breadcrumb">
			<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
			<li><a href="{{ action('User\SiteController@siteDashboard', $site->uuid) }}">{{ $site->name }}</a></li>
			<li class="active">Locations</li>
		</ol>

		@include('themes.basic.user.site.live_ribbon')

		<div class="page-header">
			<h1>Site Settings</h1>
		</div>

		<div class="row">
			<div class="col-sm-12">

				<div class="panel panel-default">	
					<div class="panel-heading">Embed Code</div>
					<div class="panel-body">
						<p>This is the tracking code for this site. To start getting analytics for this site, copy and paste this code into every webpage you want to track.</p>
						<p>&nbsp;</p>
						<textarea class="form-control" rows="12" readonly><!-- Tracking -->
<script type="text/javascript">
	var jTrack = jTrack || {};
	jTrack.key = "{{ $site->uuid }}";
	jTrack.collector = "{{ action('API\APIController@visitBeacon', str_random(5) . ".png") }}";
	(function() {
		var sf = document.createElement("script"), script = document.getElementsByTagName("script")[0];
		sf.type = "text/javascript"; sf.async = true; sf.src = "{{ action('API\APIController@sendJS', str_random(5) . ".js") }}";
		script.parentNode.insertBefore(sf, script);
	})();
</script>
						</textarea>
					</div>
				</div> 

				<div class="panel panel-default">	
					<div class="panel-heading">Change Information</div>
					<div class="panel-body">

						@if (count($errors) > 0)
						<div class="alert alert-danger">
							<p><strong>There was a problem creating your site.</strong></p>
							<ul style="margin-top: 10px">
								@foreach ($errors->all() as $error)
								<li>{{ $error }}</li>
								@endforeach
							</ul>
						</div>
						@endif

						@if (isset($success))
						<div class="alert alert-success">
							{!! $success !!}
						</div>
						@endif

						<form method="POST">

							{{ csrf_field() }}

							<div class="form-group">
								<label for="exampleInputEmail1">Site Name</label>
								<input type="text" name="name" class="form-control" id="exampleInputEmail1" placeholder="" value="{{ $site->name }}">
							</div>

							<div class="form-group">
								<label for="exampleInputPassword1">Site URL</label>
								<input type="text" name="url" class="form-control" id="exampleInputPassword1" placeholder="Include http://" value="{{ $site->url }}">
							</div>

							<div class="form-group">
								<label for="exampleInputPassword1">Site Timezone</label>
								<select class="form-control select2" name="timezone">
								@foreach(tz_list() AS $t)
									<option value="{{ $t['zone'] }}" @if($site->timezone == $t['zone']) selected @endif>{{ $t['diff_from_GMT'] . ' - ' . $t['zone'] }}</option>
								@endforeach
								</select>
							</div>

							<hr />

							<div class="row">
								<div class="col-sm-6">
									<button type="submit" class="btn btn-info">Save this site</button>
								</div>
							</div>

						</form>

					</div>
				</div>

				<div class="panel panel-default">	
					<div class="panel-heading">Delete this site</div>
					<div class="panel-body">

						<p>By deleteing this site you will be deleting all the data contained for this site, and the site itself. This process is final, there is no way to get back deleted data.</p>
						<p>&nbsp;</p>
						<hr />
						<a href='{{ action('User\SiteController@siteDelete', $site->uuid) }}' class="btn btn-danger" onclick="return confirm('There is no system to bring back deleted data - please be sure before you click OK.')">I am sure, delete this site</a>

					</div>
				</div>

			</div>
		</div>

	</div>
</div>

@stop

@section('head')
<link href='https://select2.github.io/dist/css/select2.min.css' rel="stylesheet">
<link href='https://select2.github.io/select2-bootstrap-theme/css/select2-bootstrap.css' rel="stylesheet">
@stop

@section('page-end')
<script src='https://select2.github.io/dist/js/select2.min.js'></script>
<script>
$(document).ready(function() { 
	$(".select2").select2({
		theme: "bootstrap"
	}); 
});
</script>
@stop