@extends('themes.basic.master')

@section('content')

<div class="row">
	<div class="col-sm-3">
		@include('themes.basic.user.sidebar')
	</div>
	<div class="col-sm-9">

		<ol class="breadcrumb">
			<li><a href="{{ action('User\UserController@showDashboard') }}">Dashboard</a></li>
			<li><a href="{{ action('User\SiteController@siteDashboard', $site->uuid) }}">{{ $site->name }}</a></li>
			<li class="active">Referers</li>
		</ol>

		@include('themes.basic.user.site.live_ribbon')

		<div class="page-header">
			<h1>Referers</h1>
		</div>

		<div class="row">
			<div class="col-md-12">

				<table class="table">
					<thead>
						<tr>
							<th width="50%">Referer</th>
							<th class="text-right">Actions</th>
							<th class="text-right">Visitors</th>
							<th class="text-right">Avg Time</th>
						</tr>
					</thead>
					<tbody>
						@foreach($site->getMetric($report['start_format'], $report['end_format'], 30, 'referer_url') AS $row)
						<?php $stats = $site->getContentStats($report['start_format'], $report['end_format'], 'referer_url', $row->referer_url); ?>
						<tr>
							<td>
							@if ($row->referer_url == '')
							Direct or no Referer
							@else
							{{ $row->referer_url }}
							@endif
							</td>
							<td class="text-right">{{ number_format($row->total_hits, 0) }}</td>
							<td class="text-right">{{ $stats['visitors'] }}</td>
							<td class="text-right">{{ secs_to_human($stats['avg']) }}</td>
						</tr>
						@endforeach
					</tbody>
				</table>
				
			</div>		
		</div>

	</div>
</div>

@stop

@section('head')
@endsection

@section('page-end')
@parent

@endsection