<div class="row">
	<div class="col-sm-6">
		<ul class="quick-info">
			<li><span class="ribbon-live">{{ $site->getLiveVisitors() }}</span> Live</li>
			<li><span>{{ $site->getVisitorDateRange() }}</span> Visitors today</li>
			<li><span>{{ $site->getHitsDateRange() }}</span> Actions today</li>
		</ul>
	</div>
	<div class="col-sm-6">
		<div class="input-group" id="reportrange">
			<span class="input-group-addon reportrange-spinner"><i class="fa fa-calendar"></i></span>
			<input type="text" class="form-control reportrange-value" value="{{ date("F jS Y", strtotime($report['start_format'])) }} - {{ date("F jS Y", strtotime($report['end_format'])) }}">
		</div>

	</div>
</div>

@section('head')
@parent
<link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap.daterangepicker/2/daterangepicker.css" />
@endsection

@section('page-end')
@parent
<script type="text/javascript" src="{{ asset('assets/themes/basic/js/daterangepicker.js') }}"></script>
<script>
	//-- Code to power the date control at the top
	//-- of the page. Will refresh the page and data
	//-- when changed
	$(function() {

		$('#reportrange').daterangepicker({
			"opens": "left",
			"startDate": moment('{{ $report['start_format'] }}'),
			"endDate": moment('{{ $report['end_format'] }}'),
			locale: {
		      format: 'MMMM Do YYYY'
		    },
		}, function(start, end) {
			//-- Asthetics change and send away
			$('.reportrange-value').val(start.format('MMMM Do YYYY') + " - " + end.format('MMMM Do YYYY'));
			$('.reportrange-spinner').html("<i class='fa fa-refresh fa-spin'></i>");	
			window.location = "{{ action('User\UserController@changeDateControl') }}?start=" + start.format('MMMM Do YYYY') + "&end=" + end.format('MMMM Do YYYY');
		});

	});
</script>
<script>
/**
 * Function to grab live data from the server
 *
 */
getLiteLiveData()
function getLiteLiveData() 
{
	$.get('{{ action('User\SiteController@getLiveStats', $site->uuid) }}', function(data) {
		//-- Main visitors
		$('.ribbon-live').html(data.visitors);
		document.title = "(" + data.visitors + ") {{ $site->name }}";
	});

	//-- Fire again in 5 seconds
	setTimeout(getLiteLiveData, 5000)
}
</script>
@endsection

@section('title')
(0) {{ $site->name }}
@endsection